# This is file 'vc-svn.awk' from the vc bundle for TeX.
# The original file can be found at CTAN:support/vc.
# This file is Public Domain.
BEGIN {
    
### Process output of "svn info".
		if (script=="info") {
				MaxRevision = 0
		}
		
### Process output of "svn status".
		if (script=="status") {
				modified = 0
		}
		
}



### Process output of "svn info".
### Save all lines of the current record in a corresponding variable.
script=="info" && /^Path:/ { RecPath = $0; next }
script=="info" && /^Name:/ { RecName = $0; next }
script=="info" && /^URL:/ { RecUrl = $0; next }
script=="info" && /^Repository Root:/ { RecRepositoryRoot = $0; next }
script=="info" && /^Repository UUID:/ { RecRepositoryUuid = $0; next }
script=="info" && /^Revision:/ { RecRevision = $2; next }
script=="info" && /^Node Kind:/ { RecNodeKind = $0; next }
script=="info" && /^Last Changed Author:/ { RecLastChangedAuthor = $0; next }
script=="info" && /^Last Changed Rev:/ { RecLastChangedRevision = $0; next }
script=="info" && /^Last Changed Date:/ { RecLastChangedDate = $0; next }
script=="info" && /^[\r]*$/ {
### If revision number of the new record is higher,
### save all lines from the new record.
    if (RecRevision > MaxRevision) {
				MaxPath = RecPath
				MaxName = RecName
				MaxUrl = RecUrl
				MaxRepositoryRoot = RecRepositoryRoot
				MaxRepositoryUuid = RecRepositoryUuid
				MaxRevision = RecRevision
				MaxNodeKind = RecNodeKind
				MaxLastChangedAuthor = RecLastChangedAuthor
				MaxLastChangedRev = RecLastChangedRevision
				MaxLastChangedDate = RecLastChangedDate
    }
}

### Process output of "svn status".
### File with local modifications?
script=="status" && /^[^ ?]/ { modified = 1 }
### File with property modifications?
script=="status" && /^.[^ ]/ { modified = 2 }



END {
		
### Process output of "svn info".
		if (script=="info") {
### Remove possible Windows line endings (e.g., for Msys).
				gsub("\r$", "", MaxPath)
				gsub("\r$", "", MaxName)
				gsub("\r$", "", MaxUrl)
				gsub("\r$", "", MaxRepositoryRoot)
				gsub("\r$", "", MaxRepositoryUuid)
				gsub("\r$", "", MaxRevision)
				gsub("\r$", "", MaxNodeKind)
				gsub("\r$", "", MaxLastChangedAuthor)
				gsub("\r$", "", MaxLastChangedRev)
				gsub("\r$", "", MaxLastChangedDate)
### Escape % characters for TeX compatibility.
				gsub("%", "\\%", MaxUrl)
				gsub("%", "\\%", MaxRepositoryRoot)
### Extract relevant information from variables.
				Path = substr(MaxPath, 2+match(MaxPath, ":"))
				Name = substr(MaxName, 2+match(MaxName, ":"))
				Url = substr(MaxUrl, 2+match(MaxUrl, ":"))
				RepositoryRoot = substr(MaxRepositoryRoot, 2+match(MaxRepositoryRoot, ":"))
				RepositoryUuid = substr(MaxRepositoryUuid, 2+match(MaxRepositoryUuid, ":"))
				Revision = MaxRevision
				NodeKind = substr(MaxNodeKind, 2+match(MaxNodeKind, ":"))
				LastChangedAuthor = substr(MaxLastChangedAuthor, 2+match(MaxLastChangedAuthor, ":"))
				LastChangedRev = substr(MaxLastChangedRev, 2+match(MaxLastChangedRev, ":"))
				LastChangedDate = substr(MaxLastChangedDate, 2+match(MaxLastChangedDate, ":"))
				LongDate = substr(LastChangedDate, 1, 25)
				DateRAW = substr(LongDate, 1, 10)
				DateISO = DateRAW
				DateTEX = DateISO
				gsub("-", "/", DateTEX)
				Time = substr(LongDate, 12, 14)
### Write file identification to vc.tex.
				print "%%% This file has been generated by the vc bundle for TeX."
				print "%%% Do not edit this file!"
				print "%%%"
### Write Subversion specific macros.
				print "%%% Define Subversion specific macros."
				print "\\gdef\\SVNRevision{" Revision "}%"
				print "\\gdef\\SVNLastChangedRev{" LastChangedRev "}%"
				print "\\gdef\\SVNLastChangedAuthor{" LastChangedAuthor "}%"
				print "\\gdef\\SVNLastChangedDate{" LastChangedDate "}%"
				print "\\gdef\\SVNRepositoryUuid{" RepositoryUuid "}%"
				if (full==1) {
						print "\\gdef\\SVNPath{" Path "}%"
						print "\\gdef\\SVNName{" Name "}%"
						print "\\gdef\\SVNUrl{" Url "}%"
						print "\\gdef\\SVNNodeKind{" NodeKind "}%"
						print "\\gdef\\SVNRepositoryRoot{" RepositoryRoot "}%"
				}
### Write generic version control macros.
				print "%%% Define generic version control macros."
				print "\\gdef\\VCRevision{\\SVNRevision}%"
				print "\\gdef\\VCAuthor{\\SVNLastChangedAuthor}%"
				print "\\gdef\\VCDateRAW{" DateRAW "}%"
				print "\\gdef\\VCDateISO{" DateISO "}%"
				print "\\gdef\\VCDateTEX{" DateTEX "}%"
				print "\\gdef\\VCTime{" Time "}%"
				print "\\gdef\\VCModifiedText{\\textcolor{red}{with local modifications!}}%"
				print "%%% Assume clean working copy."
				print "\\gdef\\VCModified{0}%"
				print "\\gdef\\VCRevisionMod{\\VCRevision}%"
				MaxRevision = 0
		}
		
### Process output of "svn status".
		if (script=="status") {
				print "%%% Is working copy modified?"
				print "\\gdef\\VCModified{" modified "}%"
				if (modified==0) {
						print "\\gdef\\VCRevisionMod{\\VCRevision}%"
				} else {
						print "\\gdef\\VCRevisionMod{\\VCRevision~\\VCModifiedText}%"
				}
		}
		
}
