/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog;

import com.declarativa.interprolog.ObjectExamplePair;
import com.declarativa.interprolog.PrologEngine;
import com.declarativa.interprolog.PrologOperatorsContext;
import com.declarativa.interprolog.TermModelListener;
import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.VariableNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TermModel
implements Serializable,
TreeModel {
    public Object node;
    public TermModel[] children;
    protected boolean hasListFunctor;
    private transient Vector treeListeners = null;
    private transient Vector termListeners;
    public transient TermModel root;
    static PrologOperatorsContext defaultOperatorContext = new PrologOperatorsContext();
    public static final int listMaxLength = 100;

    public static ObjectExamplePair example() {
        return new ObjectExamplePair("TermModel", new TermModel(new Integer(1), null, false), new TermModel(".", new TermModel[2], true));
    }

    public Object clone() {
        Object object = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            throw new IPException("Failed to clone");
        }
        return object;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TermModel)) {
            return false;
        }
        TermModel termModel = (TermModel)object;
        if (!this.node.equals(termModel.node)) {
            return false;
        }
        if (this.getChildCount() != termModel.getChildCount()) {
            return false;
        }
        int n = 0;
        while (n < this.getChildCount()) {
            if (!this.getChild(n).equals(termModel.getChild(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setNodeValue(Object object) {
        if (object != null) {
            if (!(object instanceof Serializable)) {
                throw new IPException("TermModel nodes must be Serializable");
            }
            if (!(object instanceof Number || object instanceof String || object instanceof VariableNode)) {
                throw new IPException("Bad TermModel node type");
            }
        }
        boolean bl = object != this.node;
        this.node = object;
        if (bl) {
            this.fireTermChanged();
        }
    }

    public void setChild(int n, TermModel termModel) {
        boolean bl = termModel != this.children[n];
        this.children[n] = termModel;
        if (bl) {
            this.fireTermChanged();
        }
    }

    public void setChildren(TermModel[] termModelArray) {
        boolean bl = this.children != termModelArray;
        this.children = termModelArray;
        if (bl) {
            this.fireTermChanged();
        }
    }

    public TermModel[] getChildren() {
        return this.children;
    }

    public void addChildren(TermModel[] termModelArray) {
        if (termModelArray.length == 0) {
            return;
        }
        TermModel[] termModelArray2 = new TermModel[this.getChildCount() + termModelArray.length];
        int n = 0;
        while (n < this.getChildCount()) {
            termModelArray2[n] = this.children[n];
            ++n;
        }
        int n2 = this.getChildCount();
        while (n2 < this.getChildCount() + termModelArray.length) {
            termModelArray2[n2] = termModelArray[n2 - this.getChildCount()];
            ++n2;
        }
        this.setChildren(termModelArray2);
    }

    /*
     * Unable to fully structure code
     */
    public void deleteChildren(int[] var1_1) {
        if (var1_1.length == 0) {
            return;
        }
        var2_2 = new TermModel[this.getChildCount() - var1_1.length];
        var3_3 = 0;
        var4_4 = 0;
        ** GOTO lbl13
        {
            ++var3_3;
            do {
                if (TermModel.inArray(var3_3, var1_1)) continue block0;
                var2_2[var4_4] = this.children[var3_3];
                ++var3_3;
                ++var4_4;
lbl13:
                // 2 sources

            } while (var4_4 < var2_2.length);
        }
        this.setChildren(var2_2);
    }

    public void deleteChildren(TermModel[] termModelArray) {
        if (termModelArray.length == 0) {
            return;
        }
        Vector<TermModel> vector = new Vector<TermModel>();
        int n = 0;
        while (n < this.children.length) {
            if (!TermModel.inArray(this.children[n], termModelArray)) {
                vector.addElement(this.children[n]);
            }
            ++n;
        }
        TermModel[] termModelArray2 = new TermModel[vector.size()];
        int n2 = 0;
        while (n2 < termModelArray2.length) {
            termModelArray2[n2] = (TermModel)vector.elementAt(n2);
            ++n2;
        }
        this.setChildren(termModelArray2);
    }

    static boolean inArray(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static boolean inArray(Object object, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (object.equals(objectArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void assignToVar(VariableNode variableNode, Object object) {
        if (variableNode.equals(this.node)) {
            this.setNodeValue(object);
        }
        int n = 0;
        while (n < this.getChildCount()) {
            this.children[n].assignToVar(variableNode, object);
            ++n;
        }
    }

    public void assignTermChanges(TermModel termModel) {
        if (!this.nodeIsVar() && termModel.nodeIsVar()) {
            return;
        }
        if (this.nodeIsVar() && !termModel.nodeIsVar()) {
            this.setNodeValue(termModel.node);
            this.setChildren(termModel.getChildren());
            return;
        }
        if (!(this.nodeIsVar() || termModel.nodeIsVar() || this.node.equals(termModel.node))) {
            throw new IPException("Inconsistent term: " + this.node + " different from " + termModel.node);
        }
        int n = 0;
        while (n < this.getChildCount()) {
            ((TermModel)this.getChild(n)).assignTermChanges((TermModel)termModel.getChild(n));
            ++n;
        }
    }

    public void setRoot() {
        this.setRoot(this);
    }

    public void setRoot(TermModel termModel) {
        if (this.root != null) {
            return;
        }
        this.root = termModel;
        this.propagateRoot();
    }

    public boolean isRoot() {
        return this.root == this;
    }

    protected void propagateRoot() {
        int n = 0;
        while (n < this.getChildCount()) {
            this.children[n].setRoot(this.root);
            ++n;
        }
    }

    public String getTemplate() {
        StringBuffer stringBuffer = new StringBuffer(this.node.toString());
        int n = 0;
        while (n < this.getChildCount()) {
            if (n == 0) {
                stringBuffer.append("(");
            }
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("_");
            ++n;
        }
        if (this.getChildCount() > 0) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String getFunctorArity() {
        return String.valueOf(String.valueOf(this.node)) + "/" + this.getChildCount();
    }

    public Object getRoot() {
        return this;
    }

    public Object getChild(Object object, int n) {
        return ((TermModel)object).children[n];
    }

    public int getChildCount(Object object) {
        TermModel[] termModelArray = ((TermModel)object).children;
        if (termModelArray == null) {
            return 0;
        }
        return termModelArray.length;
    }

    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        throw new RuntimeException("I can not handle term edition!");
    }

    public int getIndexOfChild(Object object, Object object2) {
        TermModel[] termModelArray = ((TermModel)object).children;
        if (termModelArray == null) {
            return 0;
        }
        int n = 0;
        while (n < termModelArray.length) {
            if (termModelArray[n] == object2) {
                return n + 1;
            }
            ++n;
        }
        return 0;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.treeListeners == null) {
            this.treeListeners = new Vector();
        }
        this.treeListeners.addElement(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (!this.treeListeners.removeElement(treeModelListener)) {
            throw new IPException("Bad removal of TermModel listener");
        }
    }

    public Object getChild(int n) {
        return this.getChild(this, n);
    }

    public int getChildCount() {
        return this.getChildCount(this);
    }

    public boolean isLeaf() {
        return this.isLeaf(this);
    }

    public void addTermModelListener(TermModelListener termModelListener) {
        if (!this.isRoot()) {
            throw new IPException("addTermModelListener can be sent to the TermModel root only");
        }
        if (this.termListeners == null) {
            this.termListeners = new Vector();
        }
        this.termListeners.addElement(termModelListener);
    }

    public void removeTermModelListener(TermModelListener termModelListener) {
        if (!this.termListeners.removeElement(termModelListener)) {
            throw new IPException("Bad removal of TermModelListener");
        }
    }

    public void fireTermChanged() {
        if (this.isRoot()) {
            if (this.termListeners != null) {
                int n = 0;
                while (n < this.termListeners.size()) {
                    ((TermModelListener)this.termListeners.elementAt(n)).termChanged(this);
                    ++n;
                }
            }
        } else if (this.root != null) {
            this.root.fireTermChanged();
        }
    }

    public static TreePath findPathForNode(String string, TermModel termModel, boolean bl) {
        Vector vector = new Vector();
        TermModel.foundPathForNode(string, termModel, bl, vector);
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new Object[vector.size()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = vector.elementAt(objectArray.length - n - 1);
            ++n;
        }
        return new TreePath(objectArray);
    }

    static boolean foundPathForNode(String string, TermModel termModel, boolean bl, Vector vector) {
        if (bl ? termModel.node.equals(string) : termModel.node.toString().startsWith(string)) {
            vector.addElement(termModel);
            return true;
        }
        int n = 0;
        while (n < termModel.getChildCount()) {
            if (TermModel.foundPathForNode(string, (TermModel)termModel.getChild(n), bl, vector)) {
                vector.addElement(termModel);
                return true;
            }
            ++n;
        }
        return false;
    }

    public TermModel() {
    }

    public TermModel(Object object) {
        this(object, (TermModel[])null);
    }

    public TermModel(Object object, TermModel[] termModelArray) {
        this(object, termModelArray, false);
    }

    public TermModel(Object object, boolean bl) {
        this(object, null, bl);
    }

    public TermModel(Object object, TermModel[] termModelArray, boolean bl) {
        this.children = termModelArray;
        this.node = object;
        this.hasListFunctor = bl;
        if (this.hasListFunctor && !this.node.equals(".") && !this.node.equals("[]")) {
            throw new IPException("Inconsistent list functor");
        }
    }

    public TermModel(int n) {
        this(new Integer(n));
    }

    public TermModel(Object object, Vector vector) {
        this.node = object;
        if (vector.size() == 0) {
            this.children = null;
        } else {
            this.children = new TermModel[vector.size()];
            int n = 0;
            while (n < this.children.length) {
                this.children[n] = (TermModel)vector.elementAt(n);
                ++n;
            }
        }
    }

    public static TermModel makeList(TermModel[] termModelArray) {
        if (termModelArray == null) {
            return new TermModel((Object)".", true);
        }
        if (termModelArray.length == 0) {
            return new TermModel((Object)".", true);
        }
        return TermModel.makeList(0, termModelArray);
    }

    public static TermModel makeList(Vector vector) {
        if (vector == null) {
            return new TermModel((Object)".", true);
        }
        if (vector.size() == 0) {
            return new TermModel((Object)".", true);
        }
        return TermModel.makeList(0, vector);
    }

    protected static TermModel makeList(int n, TermModel[] termModelArray) {
        TermModel[] termModelArray2 = new TermModel[]{termModelArray[n], n == termModelArray.length - 1 ? new TermModel((Object)"[]", true) : TermModel.makeList(n + 1, termModelArray)};
        return new TermModel(".", termModelArray2, true);
    }

    protected static TermModel makeList(int n, Vector vector) {
        TermModel[] termModelArray = new TermModel[]{(TermModel)vector.elementAt(n), n == vector.size() - 1 ? new TermModel((Object)"[]", true) : TermModel.makeList(n + 1, vector)};
        return new TermModel(".", termModelArray, true);
    }

    public Vector makeIntegerVector() {
        TermModel[] termModelArray = TermModel.flatList(this);
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n < termModelArray.length) {
            vector.addElement(new Integer(termModelArray[n].intValue()));
            ++n;
        }
        return vector;
    }

    public int intValue() {
        if (!this.isLeaf() || !(this.node instanceof Number)) {
            throw new RuntimeException("intValue() requires a Number leaf");
        }
        return ((Number)this.node).intValue();
    }

    public String toString() {
        return this.toString(defaultOperatorContext);
    }

    public String toString(PrologOperatorsContext prologOperatorsContext) {
        if (this.getChildCount() == 0) {
            return this.node.toString();
        }
        if (this.isList()) {
            return this.listToString(prologOperatorsContext);
        }
        if (this.children.length == 1) {
            if (prologOperatorsContext.prefixOperator(this.node)) {
                return String.valueOf(String.valueOf(this.node)) + " " + this.children[0].toString(prologOperatorsContext);
            }
            if (prologOperatorsContext.postfixOperator(this.node)) {
                return String.valueOf(this.children[0].toString(prologOperatorsContext)) + " " + this.node;
            }
            return String.valueOf(String.valueOf(this.node)) + "(" + this.children[0].toString(prologOperatorsContext) + ")";
        }
        if (this.children.length == 2 && prologOperatorsContext.infixOperator(this.node)) {
            return String.valueOf(this.children[0].toString(prologOperatorsContext)) + this.node + this.children[1].toString(prologOperatorsContext);
        }
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.node.toString()) + "(" + this.children[0].toString(prologOperatorsContext));
        int n = 1;
        while (n < this.children.length) {
            stringBuffer.append("," + this.children[n].toString(prologOperatorsContext));
            ++n;
        }
        return String.valueOf(String.valueOf(stringBuffer)) + ")";
    }

    public String toString(PrologEngine prologEngine) {
        return this.toString(prologEngine.getImplementationPeer().getOperators());
    }

    public String listToString(PrologOperatorsContext prologOperatorsContext) {
        StringBuffer stringBuffer = new StringBuffer("[");
        TermModel termModel = this;
        int n = 0;
        while (n < 100) {
            stringBuffer.append(termModel.children[0].toString(prologOperatorsContext));
            termModel = termModel.children[1];
            if (termModel.isListEnd() || !termModel.isList()) break;
            stringBuffer.append(',');
            ++n;
        }
        if (n == 100) {
            stringBuffer.append("...");
        } else if (!termModel.isListEnd()) {
            stringBuffer.append('|');
            stringBuffer.append(termModel.toString(prologOperatorsContext));
        }
        return String.valueOf(String.valueOf(stringBuffer)) + "]";
    }

    public boolean isListEnd() {
        return this.isLeaf() && this.isList();
    }

    public boolean isList() {
        return this.hasListFunctor && (this.node.equals(".") || this.node.equals("[]"));
    }

    public boolean isAtom() {
        return this.isLeaf() && this.node instanceof String;
    }

    public boolean isNumber() {
        return this.isLeaf() && this.node instanceof Number;
    }

    public boolean isInteger() {
        return this.isLeaf() && this.node instanceof Integer;
    }

    public boolean isVar() {
        return this.isLeaf() && this.nodeIsVar();
    }

    public boolean nodeIsVar() {
        return this.node instanceof VariableNode;
    }

    public TermModel[] flatList() {
        return TermModel.flatList(this);
    }

    public static TermModel[] flatList(TermModel termModel) {
        Vector vector = new Vector();
        TermModel.flatList(termModel, vector);
        TermModel[] termModelArray = new TermModel[vector.size()];
        int n = 0;
        while (n < termModelArray.length) {
            termModelArray[n] = (TermModel)vector.elementAt(n);
            ++n;
        }
        return termModelArray;
    }

    static void flatList(TermModel termModel, Vector vector) {
        while (termModel != null) {
            if (termModel.isListEnd()) break;
            if (termModel.isList()) {
                vector.addElement(termModel.children[0]);
                termModel = termModel.children[1];
                continue;
            }
            throw new IPException("Not a well formed list:" + termModel);
        }
    }

    public static Hashtable props2Hashtable(TermModel[] termModelArray) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = 0;
        while (n < termModelArray.length) {
            TermModel termModel = termModelArray[n];
            if (termModel.isLeaf()) {
                hashtable.put(termModel.node.toString(), termModel.node);
            } else {
                if (!termModel.node.equals("=") || termModel.getChildCount() != 2) {
                    throw new RuntimeException("bad proplist");
                }
                hashtable.put(termModel.children[0].toString(), termModel.children[1]);
            }
            ++n;
        }
        return hashtable;
    }

    public boolean unifies(TermModel termModel) {
        if (termModel == null) {
            return false;
        }
        if (this.isVar() || termModel.isVar()) {
            return true;
        }
        if (!this.node.equals(termModel.node)) {
            return false;
        }
        if (this.getChildCount() != termModel.getChildCount()) {
            return false;
        }
        int n = 0;
        while (n < this.getChildCount()) {
            if (!((TermModel)this.getChild(n)).unifies((TermModel)termModel.getChild(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

