/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.QNameValue;

public class IndependentContext
extends AbstractStaticContext
implements XPathStaticContext,
NamespaceResolver {
    protected HashMap<String, NamespaceUri> namespaces = new HashMap(10);
    protected HashMap<StructuredQName, XPathVariable> variables = new HashMap(20);
    protected NamespaceResolver externalResolver = null;
    protected ItemType requiredContextItemType = AnyItemType.getInstance();
    protected Set<NamespaceUri> importedSchemaNamespaces = new HashSet<NamespaceUri>();
    protected boolean autoDeclare = false;
    protected Executable executable;
    protected RetainedStaticContext retainedStaticContext;
    protected OptimizerOptions optimizerOptions;
    protected boolean parentlessContextItem;

    public IndependentContext() {
        this(new Configuration());
    }

    public IndependentContext(Configuration config) {
        this.setConfiguration(config);
        this.clearNamespaces();
        this.setDefaultFunctionLibrary(31);
        this.setDefaultCollationName(config.getDefaultCollationName());
        this.setOptimizerOptions(config.getOptimizerOptions());
        PackageData pd = new PackageData(config);
        pd.setHostLanguage(HostLanguage.XPATH, 31);
        pd.setSchemaAware(false);
        this.setPackageData(pd);
    }

    public IndependentContext(IndependentContext ic) {
        this(ic.getConfiguration());
        this.setPackageData(ic.getPackageData());
        this.setBaseURI(ic.getStaticBaseURI());
        this.setContainingLocation(ic.getContainingLocation());
        this.setDefaultElementNamespace(ic.getDefaultElementNamespace());
        this.setDefaultFunctionNamespace(ic.getDefaultFunctionNamespace());
        this.setBackwardsCompatibilityMode(ic.isInBackwardsCompatibleMode());
        this.namespaces = new HashMap<String, NamespaceUri>(ic.namespaces);
        this.variables = new HashMap(10);
        FunctionLibraryList libList = (FunctionLibraryList)ic.getFunctionLibrary();
        if (libList != null) {
            this.setFunctionLibrary((FunctionLibraryList)libList.copy());
        }
        this.setDefaultCollationName(ic.getDefaultCollationName());
        this.setImportedSchemaNamespaces(ic.importedSchemaNamespaces);
        this.externalResolver = ic.externalResolver;
        this.autoDeclare = ic.autoDeclare;
        this.setUnprefixedElementMatchingPolicy(ic.getUnprefixedElementMatchingPolicy());
        this.setXPathLanguageLevel(ic.getXPathVersion());
        this.requiredContextItemType = ic.requiredContextItemType;
        this.setExecutable(ic.getExecutable());
        this.setOptimizerOptions(ic.getOptimizerOptions());
    }

    @Override
    public RetainedStaticContext makeRetainedStaticContext() {
        if (this.retainedStaticContext == null) {
            this.retainedStaticContext = new RetainedStaticContext(this);
        }
        return this.retainedStaticContext;
    }

    public void declareNamespace(String prefix, NamespaceUri uri) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        if ("".equals(prefix)) {
            this.setDefaultElementNamespace(uri);
        } else {
            this.namespaces.put(prefix, uri);
        }
    }

    @Override
    public void setDefaultElementNamespace(NamespaceUri uri) {
        if (uri == null) {
            uri = NamespaceUri.NULL;
        }
        super.setDefaultElementNamespace(uri);
        this.namespaces.put("", uri);
    }

    public void clearNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", NamespaceUri.XML);
        this.declareNamespace("xsl", NamespaceUri.XSLT);
        this.declareNamespace("saxon", NamespaceUri.SAXON);
        this.declareNamespace("xs", NamespaceUri.SCHEMA);
        this.declareNamespace("", NamespaceUri.NULL);
    }

    public void clearAllNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", NamespaceUri.XML);
        this.declareNamespace("", NamespaceUri.NULL);
    }

    public void setNamespaces(NodeInfo node) {
        this.namespaces.clear();
        int kind = node.getNodeKind();
        if (kind == 2 || kind == 3 || kind == 8 || kind == 7 || kind == 13) {
            node = node.getParent();
        }
        if (node == null) {
            return;
        }
        AxisIterator iter = node.iterateAxis(8);
        NodeInfo ns;
        while ((ns = iter.next()) != null) {
            String prefix = ns.getLocalPart();
            if ("".equals(prefix)) {
                this.setDefaultElementNamespace(NamespaceUri.of(ns.getStringValue()));
                continue;
            }
            this.declareNamespace(ns.getLocalPart(), NamespaceUri.of(ns.getStringValue()));
        }
        return;
    }

    @Override
    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.externalResolver = resolver;
    }

    public void setAllowUndeclaredVariables(boolean allow) {
        this.autoDeclare = allow;
    }

    public boolean isAllowUndeclaredVariables() {
        return this.autoDeclare;
    }

    @Override
    public XPathVariable declareVariable(QNameValue qname) {
        return this.declareVariable(qname.getStructuredQName());
    }

    @Override
    public XPathVariable declareVariable(NamespaceUri namespaceURI, String localName) {
        StructuredQName qName = new StructuredQName("", namespaceURI == null ? NamespaceUri.NULL : namespaceURI, localName);
        return this.declareVariable(qName);
    }

    public XPathVariable declareVariable(StructuredQName qName) {
        XPathVariable var = this.variables.get(qName);
        if (var != null) {
            return var;
        }
        var = XPathVariable.make(qName);
        int slot = this.variables.size();
        var.setSlotNumber(slot);
        this.variables.put(qName, var);
        return var;
    }

    public Iterable<XPathVariable> getExternalVariables() {
        return this.variables.values();
    }

    public XPathVariable getExternalVariable(StructuredQName qName) {
        return this.variables.get(qName);
    }

    public int getSlotNumber(QNameValue qname) {
        StructuredQName sq = qname.getStructuredQName();
        XPathVariable var = this.variables.get(sq);
        if (var == null) {
            return -1;
        }
        return var.getLocalSlotNumber();
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        if (this.externalResolver != null) {
            return this.externalResolver;
        }
        return this;
    }

    @Override
    public NamespaceUri getURIForPrefix(String prefix, boolean useDefault) {
        if (this.externalResolver != null) {
            return this.externalResolver.getURIForPrefix(prefix, useDefault);
        }
        if (prefix.isEmpty()) {
            return useDefault ? this.getDefaultElementNamespace() : NamespaceUri.NULL;
        }
        return this.namespaces.get(prefix);
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        if (this.externalResolver != null) {
            return this.externalResolver.iteratePrefixes();
        }
        return this.namespaces.keySet().iterator();
    }

    @Override
    public Expression bindVariable(StructuredQName qName) throws XPathException {
        XPathVariable var = this.variables.get(qName);
        if (var == null) {
            if (this.autoDeclare) {
                return new LocalVariableReference(this.declareVariable(qName));
            }
            throw new XPathException("Undeclared variable in XPath expression: $" + qName.getClarkName(), "XPST0008");
        }
        return new LocalVariableReference(var);
    }

    @Override
    public SlotManager getStackFrameMap() {
        SlotManager map = this.getConfiguration().makeSlotManager();
        XPathVariable[] va = new XPathVariable[this.variables.size()];
        XPathVariable[] xPathVariableArray = this.variables.values().iterator();
        while (xPathVariableArray.hasNext()) {
            XPathVariable var;
            va[var.getLocalSlotNumber()] = var = xPathVariableArray.next();
        }
        for (XPathVariable v : va) {
            map.allocateSlotNumber(v.getVariableQName(), v);
        }
        return map;
    }

    public Collection<XPathVariable> getDeclaredVariables() {
        return this.variables.values();
    }

    @Override
    public boolean isImportedSchema(NamespaceUri namespace) {
        return this.importedSchemaNamespaces.contains(namespace);
    }

    @Override
    public Set<NamespaceUri> getImportedSchemaNamespaces() {
        return this.importedSchemaNamespaces;
    }

    public void setImportedSchemaNamespaces(Set<NamespaceUri> namespaces) {
        this.importedSchemaNamespaces = namespaces;
        if (!namespaces.isEmpty()) {
            this.setSchemaAware(true);
        }
    }

    public void setRequiredContextItemType(ItemType type) {
        this.requiredContextItemType = type;
    }

    @Override
    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public void setOptimizerOptions(OptimizerOptions options) {
        this.optimizerOptions = options;
    }

    @Override
    public OptimizerOptions getOptimizerOptions() {
        return this.optimizerOptions;
    }

    public void setExecutable(Executable exec) {
        this.executable = exec;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    @Override
    public boolean isContextItemParentless() {
        return this.parentlessContextItem;
    }

    public void setContextItemParentless(boolean parentless) {
        this.parentlessContextItem = parentless;
    }
}

