/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util.CharConvBuilder;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import oracle.gss.util.CharConvBuilder.TokenParser;
import oracle.gss.util.UnicodeProperty;
import oracle.sql.ConverterArchive;

public class UniPropBuilder {
    private StreamTokenizer m_tokenizer;
    private static Hashtable nameMapping = null;
    private static final String UNIPROPNAME = "unicodeprop.glb";
    private static final String UNIPROPDIR = "/oracle/gss/util/data/";

    public UniPropBuilder(String string, String string2, boolean bl, FileInputStream fileInputStream) throws IOException {
        if (nameMapping == null) {
            nameMapping = this.createMappingTable();
        }
        this.m_tokenizer = TokenParser.getTokenizer(fileInputStream);
        this.m_tokenizer.wordChars(95, 95);
        this.m_tokenizer.lowerCaseMode(false);
        this.getUniProp(string, string2, bl, fileInputStream);
    }

    private Hashtable createMappingTable() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(50);
        hashtable.put("LOWERCASE_LETTER", new Integer(19));
        hashtable.put("UPPERCASE_LETTER", new Integer(2));
        hashtable.put("TITLECASE_LETTER", new Integer(3));
        hashtable.put("NON_SPACING_MARK", new Integer(4));
        hashtable.put("COMBINING_SPACING_MARK", new Integer(5));
        hashtable.put("ENCLOSING_MARK", new Integer(6));
        hashtable.put("DECIMAL_DIGIT_NUMBER", new Integer(7));
        hashtable.put("LETTER_NUMBER", new Integer(8));
        hashtable.put("OTHER_NUMBER", new Integer(9));
        hashtable.put("SPACE_SEPARATOR", new Integer(10));
        hashtable.put("LINE_SEPARATOR", new Integer(11));
        hashtable.put("PARAGRAPH_SEPARATOR", new Integer(12));
        hashtable.put("CONTROL", new Integer(13));
        hashtable.put("FORMAT", new Integer(14));
        hashtable.put("SURROGATE", new Integer(15));
        hashtable.put("HIGH_SURROGATE", new Integer(15));
        hashtable.put("LOW_SURROGATE", new Integer(15));
        hashtable.put("PRIVATE_USE", new Integer(16));
        hashtable.put("NOT_ASSIGNED", new Integer(17));
        hashtable.put("MODIFIER_LETTER", new Integer(18));
        hashtable.put("OTHER_LETTER", new Integer(19));
        hashtable.put("CONNECTOR_PUNCTUATION", new Integer(20));
        hashtable.put("DASH_PUNCTUATION", new Integer(21));
        hashtable.put("START_PUNCTUATION", new Integer(22));
        hashtable.put("INITIAL_QUOTE_PUNCTUATION", new Integer(23));
        hashtable.put("FINAL_QUOTE_PUNCTUATION", new Integer(24));
        hashtable.put("END_PUNCTUATION", new Integer(25));
        hashtable.put("OTHER_PUNCTUATION", new Integer(26));
        hashtable.put("MATH_SYMBOL", new Integer(27));
        hashtable.put("CURRENCY_SYMBOL", new Integer(28));
        hashtable.put("MODIFIER_SYMBOL", new Integer(29));
        hashtable.put("OTHER_SYMBOL", new Integer(30));
        return hashtable;
    }

    private void getUniProp(String string, String string2, boolean bl, FileInputStream fileInputStream) throws IOException {
        int n;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 65535L;
        String string3 = null;
        UnicodeProperty unicodeProperty = new UnicodeProperty();
        TokenParser.searchKeyword("Unicode_property", this.m_tokenizer);
        TokenParser.skipToEol(this.m_tokenizer);
        while ((n = this.m_tokenizer.nextToken()) != -1) {
            if (n == 125) break;
            if (this.m_tokenizer.ttype != -2) {
                this.throwErrorMessage();
            }
            n = this.m_tokenizer.nextToken();
            if (this.m_tokenizer.ttype == -3) {
                l = TokenParser.hexToLong(this.m_tokenizer.sval);
            }
            if ((n = this.m_tokenizer.nextToken()) == 45) {
                n = this.m_tokenizer.nextToken();
                if (this.m_tokenizer.ttype != -2) {
                    this.throwErrorMessage();
                }
                n = this.m_tokenizer.nextToken();
                if (this.m_tokenizer.ttype == -3) {
                    l2 = TokenParser.hexToLong(this.m_tokenizer.sval);
                    n = this.m_tokenizer.nextToken();
                } else {
                    this.throwErrorMessage();
                }
            } else if (n == 61) {
                l2 = l;
            } else {
                this.throwErrorMessage();
            }
            if (n == -1) {
                this.throwErrorMessage();
            }
            if ((n = this.m_tokenizer.nextToken()) != 123) {
                this.throwErrorMessage();
            }
            n = this.m_tokenizer.nextToken();
            if (this.m_tokenizer.ttype == -3) {
                string3 = this.m_tokenizer.sval;
            } else {
                this.throwErrorMessage();
            }
            long l5 = l;
            while (l5 <= l2) {
                unicodeProperty.setData((int)l5, (Integer)nameMapping.get(string3), true);
                ++l5;
            }
            TokenParser.skipToEol(this.m_tokenizer);
        }
        TokenParser.searchKeyword("decomposition", this.m_tokenizer);
        TokenParser.skipToEol(this.m_tokenizer);
        while ((n = this.m_tokenizer.nextToken()) != -1) {
            if (n == 125) break;
            if (this.m_tokenizer.ttype != -2) {
                this.throwErrorMessage();
            }
            n = this.m_tokenizer.nextToken();
            if (this.m_tokenizer.ttype == -3) {
                l3 = TokenParser.hexToLong(this.m_tokenizer.sval);
            }
            n = this.m_tokenizer.nextToken();
            if (this.m_tokenizer.ttype != 59) {
                this.throwErrorMessage();
            }
            while ((n = this.m_tokenizer.nextToken()) != -1 && n != 59 && n != 44 && n != 10) {
            }
            if (n == 59 && (n = this.m_tokenizer.nextToken()) == -3 && this.m_tokenizer.sval.equals("C")) {
                unicodeProperty.setData((int)l3, unicodeProperty.getData((int)l3) | 0x8000, false);
            }
            if (l4 == l3) {
                unicodeProperty.setData((int)l3, unicodeProperty.getData((int)l3) & Short.MAX_VALUE, false);
            }
            l4 = l3;
            TokenParser.skipToEol(this.m_tokenizer);
        }
        if (unicodeProperty != null) {
            unicodeProperty.finishSet();
            ConverterArchive converterArchive = new ConverterArchive();
            try {
                if (bl) {
                    converterArchive.insertObjtoFile(string, UNIPROPNAME, unicodeProperty);
                } else {
                    converterArchive.insertSingleObj(string2, unicodeProperty, "/oracle/gss/util/data/unicodeprop.glb");
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                return;
            }
        }
    }

    private void throwErrorMessage() throws IOException {
        throw new IOException("Error in file at line: " + this.m_tokenizer.lineno());
    }
}

