/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.typeresolution;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.typeresolution.visitors.PMDASMVisitor;
import org.objectweb.asm.ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMDASMClassLoader
extends ClassLoader {
    private Set<String> dontBother = new HashSet<String>();

    public synchronized Map<String, String> getImportedClasses(String name) throws ClassNotFoundException {
        if (this.dontBother.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        try {
            ClassReader reader = new ClassReader(this.getResourceAsStream(name.replace('.', '/') + ".class"));
            PMDASMVisitor asmVisitor = new PMDASMVisitor();
            reader.accept(asmVisitor, 0);
            List<String> inner = asmVisitor.getInnerClasses();
            if (inner != null && !inner.isEmpty()) {
                inner = new LinkedList<String>(inner);
                for (String str : inner) {
                    reader = new ClassReader(this.getResourceAsStream(str.replace('.', '/') + ".class"));
                    reader.accept(asmVisitor, 0);
                }
            }
            return asmVisitor.getPackages();
        }
        catch (IOException e) {
            this.dontBother.add(name);
            throw new ClassNotFoundException(name);
        }
    }
}

