/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.sandbox.completion;

import com.jgoodies.common.base.Strings;
import com.jgoodies.search.Completion;
import com.jgoodies.search.CompletionProcessor;
import com.jgoodies.search.CompletionPublisher;
import com.jgoodies.search.CompletionState;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class FontFamilyNameCompletionProcessor
implements CompletionProcessor {
    private static final String EXAMPLE_STRING = "The quick brown fox jumps over the lazy dog\nTHE QUICK BROWN FOX JUMPS OVER THE LAZY DOG\n1234567890!@#$%^&*()-=\\`_+|~,./<>?;':\"[]{}";
    private final Locale locale;
    private String[] fontFamilyNames;

    public FontFamilyNameCompletionProcessor() {
        this(Locale.getDefault());
    }

    public FontFamilyNameCompletionProcessor(Locale locale) {
        this.locale = locale;
    }

    public void prepare() {
        this.getFontFamilyNames();
    }

    @Override
    public boolean isAutoActivatable(String content, int caretPosition) {
        if (Strings.isBlank(content)) {
            return false;
        }
        List<Completion> completions = this.search(content);
        return 1 <= completions.size() && completions.size() <= 10;
    }

    @Override
    public boolean search(String content, int caretPosition, CompletionPublisher publisher, CompletionState state) {
        publisher.publish(this.search(content));
        return true;
    }

    private List<Completion> search(String content) {
        String trimmedContent = content.trim();
        ArrayList<Completion> completions = new ArrayList<Completion>();
        for (String fontName : this.getFontFamilyNames()) {
            if (!FontFamilyNameCompletionProcessor.matchesExact(fontName, trimmedContent)) continue;
            completions.add(((Completion.Builder)((Completion.Builder)new Completion.Builder().replacementText(fontName, new Object[0])).additionalInfo("%1$s 11pt Plain\n%2$s", fontName, EXAMPLE_STRING)).build());
        }
        return completions;
    }

    private String[] getFontFamilyNames() {
        if (this.fontFamilyNames == null) {
            this.fontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(this.locale);
        }
        return this.fontFamilyNames;
    }

    private static boolean matchesExact(String str, String content) {
        return Strings.startsWithIgnoreCase(str, content) && str.length() != content.length();
    }
}

