/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.js.JavaScript;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;

public class HTMLAbstractUIElement
extends HTMLElementImpl {
    private Function onfocus;
    private Function onblur;
    private Function onclick;
    private Function ondblclick;
    private Function onmousedown;
    private Function onmouseup;
    private Function onmouseover;
    private Function onmousemove;
    private Function onmouseout;
    private Function onkeypress;
    private Function onkeydown;
    private Function onkeyup;
    private Function oncontextmenu;
    private Map functionByAttribute = null;

    public HTMLAbstractUIElement(String name) {
        super(name);
    }

    public Function getOnblur() {
        return this.getEventFunction(this.onblur, "onblur");
    }

    public void setOnblur(Function onblur) {
        this.onblur = onblur;
    }

    public Function getOnclick() {
        return this.getEventFunction(this.onclick, "onclick");
    }

    public void setOnclick(Function onclick) {
        this.onclick = onclick;
    }

    public Function getOndblclick() {
        return this.getEventFunction(this.ondblclick, "ondblclick");
    }

    public void setOndblclick(Function ondblclick) {
        this.ondblclick = ondblclick;
    }

    public Function getOnfocus() {
        return this.getEventFunction(this.onfocus, "onfocus");
    }

    public void setOnfocus(Function onfocus) {
        this.onfocus = onfocus;
    }

    public Function getOnkeydown() {
        return this.getEventFunction(this.onkeydown, "onkeydown");
    }

    public void setOnkeydown(Function onkeydown) {
        this.onkeydown = onkeydown;
    }

    public Function getOnkeypress() {
        return this.getEventFunction(this.onkeypress, "onkeypress");
    }

    public void setOnkeypress(Function onkeypress) {
        this.onkeypress = onkeypress;
    }

    public Function getOnkeyup() {
        return this.getEventFunction(this.onkeyup, "onkeyup");
    }

    public void setOnkeyup(Function onkeyup) {
        this.onkeyup = onkeyup;
    }

    public Function getOnmousedown() {
        return this.getEventFunction(this.onmousedown, "onmousedown");
    }

    public void setOnmousedown(Function onmousedown) {
        this.onmousedown = onmousedown;
    }

    public Function getOnmousemove() {
        return this.getEventFunction(this.onmousemove, "onmousemove");
    }

    public void setOnmousemove(Function onmousemove) {
        this.onmousemove = onmousemove;
    }

    public Function getOnmouseout() {
        return this.getEventFunction(this.onmouseout, "onmouseout");
    }

    public void setOnmouseout(Function onmouseout) {
        this.onmouseout = onmouseout;
    }

    public Function getOnmouseover() {
        return this.getEventFunction(this.onmouseover, "onmouseover");
    }

    public void setOnmouseover(Function onmouseover) {
        this.onmouseover = onmouseover;
    }

    public Function getOnmouseup() {
        return this.getEventFunction(this.onmouseup, "onmouseup");
    }

    public void setOnmouseup(Function onmouseup) {
        this.onmouseup = onmouseup;
    }

    public Function getOncontextmenu() {
        return this.getEventFunction(this.oncontextmenu, "oncontextmenu");
    }

    public void setOncontextmenu(Function oncontextmenu) {
        this.oncontextmenu = oncontextmenu;
    }

    public void focus() {
        UINode node = this.getUINode();
        if (node != null) {
            node.focus();
        }
    }

    public void blur() {
        UINode node = this.getUINode();
        if (node != null) {
            node.blur();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Function getEventFunction(Function varValue, String attributeName) {
        if (varValue != null) {
            return varValue;
        }
        String normalAttributeName = this.normalizeAttributeName(attributeName);
        HTMLAbstractUIElement hTMLAbstractUIElement = this;
        synchronized (hTMLAbstractUIElement) {
            Function f;
            HashMap<String, Function> fba = this.functionByAttribute;
            Function function = f = fba == null ? null : (Function)fba.get(normalAttributeName);
            if (f != null) {
                return f;
            }
            UserAgentContext uac = this.getUserAgentContext();
            if (uac == null) {
                throw new IllegalStateException("No user agent context.");
            }
            if (uac.isScriptingEnabled()) {
                String attributeValue = this.getAttribute(attributeName);
                if (attributeValue == null || attributeValue.length() == 0) {
                    f = null;
                } else {
                    String functionCode = "function " + normalAttributeName + "_" + System.identityHashCode(this) + "() { " + attributeValue + " }";
                    Document doc = this.document;
                    if (doc == null) {
                        throw new IllegalStateException("Element does not belong to a document.");
                    }
                    Context ctx = Executor.createContext(this.getDocumentURL(), uac);
                    try {
                        Scriptable scope = (Scriptable)doc.getUserData("cobra.js.scope");
                        if (scope == null) {
                            throw new IllegalStateException("Scriptable (scope) instance was expected to be keyed as UserData to document using cobra.js.scope");
                        }
                        Scriptable thisScope = (Scriptable)JavaScript.getInstance().getJavascriptObject(this, scope);
                        try {
                            f = ctx.compileFunction(thisScope, functionCode, this.getTagName() + "[" + this.getId() + "]." + attributeName, 1, null);
                        }
                        catch (EcmaError ecmaError) {
                            logger.log(Level.WARNING, "Javascript error at " + ecmaError.getSourceName() + ":" + ecmaError.getLineNumber() + ": " + ecmaError.getMessage(), ecmaError);
                            f = null;
                        }
                        catch (Throwable err) {
                            logger.log(Level.WARNING, "Unable to evaluate Javascript code", err);
                            f = null;
                        }
                    }
                    finally {
                        Context.exit();
                    }
                }
                if (fba == null) {
                    this.functionByAttribute = fba = new HashMap<String, Function>(1);
                }
                fba.put(normalAttributeName, f);
            }
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assignAttributeField(String normalName, String value) {
        super.assignAttributeField(normalName, value);
        if (normalName.startsWith("on")) {
            HTMLAbstractUIElement hTMLAbstractUIElement = this;
            synchronized (hTMLAbstractUIElement) {
                Map fba = this.functionByAttribute;
                if (fba != null) {
                    fba.remove(normalName);
                }
            }
        }
    }
}

