/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import pcgen.base.formula.Formula;
import pcgen.cdom.base.JEPFormula;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;

public final class FormulaFactory {
    public static final Formula ZERO = new IntegerFormula(0);
    public static final Formula ONE = new IntegerFormula(1);

    private FormulaFactory() {
    }

    public static Formula getFormulaFor(String formulaString) {
        if (formulaString == null || formulaString.length() == 0) {
            throw new IllegalArgumentException("Formula cannot be empty");
        }
        try {
            return FormulaFactory.getFormulaFor(Integer.valueOf(formulaString));
        }
        catch (NumberFormatException e) {
            try {
                return FormulaFactory.getFormulaFor(Double.valueOf(formulaString));
            }
            catch (NumberFormatException e2) {
                return new JEPFormula(formulaString);
            }
        }
    }

    public static Formula getJEPFormulaFor(String formulaString) {
        if (formulaString == null || formulaString.length() == 0) {
            throw new IllegalArgumentException("Formula cannot be empty");
        }
        try {
            return FormulaFactory.getFormulaFor(Integer.valueOf(formulaString));
        }
        catch (NumberFormatException e) {
            try {
                return FormulaFactory.getFormulaFor(Double.valueOf(formulaString));
            }
            catch (NumberFormatException e2) {
                return new JEPFormula(formulaString);
            }
        }
    }

    public static Formula getFormulaFor(Integer integer) {
        return new IntegerFormula(integer);
    }

    public static Formula getFormulaFor(Double dbl) {
        return new DoubleFormula(dbl);
    }

    private static class DoubleFormula
    implements Formula {
        private final Double dbl;

        public DoubleFormula(Double dblValue) {
            if (dblValue == null) {
                throw new IllegalArgumentException("Cannot create an DoubleFormula with a null Double");
            }
            this.dbl = dblValue;
        }

        @Override
        public Double resolve(PlayerCharacter pc, String source) {
            return this.dbl;
        }

        @Override
        public Double resolve(Equipment equipment, boolean primary, PlayerCharacter pc, String string) {
            return this.dbl;
        }

        public String toString() {
            return this.dbl.toString();
        }

        public int hashCode() {
            return this.dbl.intValue();
        }

        public boolean equals(Object obj) {
            return obj instanceof DoubleFormula && ((DoubleFormula)obj).dbl.equals(this.dbl);
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Double resolveStatic() {
            return this.dbl;
        }
    }

    private static class IntegerFormula
    implements Formula {
        private final Integer integer;

        public IntegerFormula(Integer intValue) {
            if (intValue == null) {
                throw new IllegalArgumentException("Cannot create an IntegerFormula with a null Integer");
            }
            this.integer = intValue;
        }

        @Override
        public Integer resolve(PlayerCharacter pc, String source) {
            return this.integer;
        }

        @Override
        public Integer resolve(Equipment equipment, boolean primary, PlayerCharacter pc, String source) {
            return this.integer;
        }

        public String toString() {
            return this.integer.toString();
        }

        public int hashCode() {
            return this.integer;
        }

        public boolean equals(Object obj) {
            return obj instanceof IntegerFormula && ((IntegerFormula)obj).integer.equals(this.integer);
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Integer resolveStatic() {
            return this.integer;
        }
    }
}

