/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.helper.StatLock;
import pcgen.core.PCStat;

public class StatMaxValueFacet
extends AbstractSourcedListFacet<CharID, StatLock>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private FormulaResolvingFacet formulaResolvingFacet;
    private CDOMObjectConsolidationFacet consolidationFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        List<StatLock> locks = cdo.getListFor(ListKey.STAT_MAXVALUE);
        if (locks != null) {
            this.addAll(dfce.getCharID(), locks, cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    public Number getStatMaxValue(CharID id, PCStat stat) {
        Number max = Double.POSITIVE_INFINITY;
        boolean hit = false;
        Map componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            for (Map.Entry me : componentMap.entrySet()) {
                Set<Object> set = me.getValue();
                StatLock lock = (StatLock)me.getKey();
                if (!lock.getLockedStat().equals(stat)) continue;
                for (Object source : set) {
                    String sourceString;
                    String string = sourceString = source instanceof CDOMObject ? ((CDOMObject)source).getQualifiedKey() : "";
                    Number val = this.formulaResolvingFacet.resolve(id, lock.getLockValue(), sourceString);
                    if (!(val.doubleValue() < max)) continue;
                    hit = true;
                    max = val;
                }
            }
        }
        return hit ? max : null;
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }
}

