/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import pcgen.base.formula.Formula;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;

public class VariableFacet
extends AbstractStorageFacet<CharID>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private FormulaResolvingFacet formulaResolvingFacet;
    private CDOMObjectConsolidationFacet consolidationFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        Set<VariableKey> keys = cdo.getVariableKeys();
        CharID id = dfce.getCharID();
        for (VariableKey vk : keys) {
            this.add(id, vk, cdo.get(vk), cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    private void add(CharID id, VariableKey vk, Formula formula, CDOMObject cdo) {
        WrappedMapSet sources;
        Map<VariableKey, Map<Formula, Set<CDOMObject>>> map = this.getConstructingCachedMap(id);
        Map<Formula, Set<CDOMObject>> subMap = map.get(vk);
        if (subMap == null) {
            subMap = new HashMap<Formula, Set<CDOMObject>>();
            map.put(vk, subMap);
        }
        if ((sources = subMap.get(formula)) == null) {
            sources = new WrappedMapSet(IdentityHashMap.class);
            subMap.put(formula, (Set<CDOMObject>)sources);
        }
        sources.add((CDOMObject)cdo);
    }

    private Map<VariableKey, Map<Formula, Set<CDOMObject>>> getCachedMap(CharID id) {
        return (Map)this.getCache(id);
    }

    private Map<VariableKey, Map<Formula, Set<CDOMObject>>> getConstructingCachedMap(CharID id) {
        Map<VariableKey, Map<Formula, Set<CDOMObject>>> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            componentMap = new HashMap<VariableKey, Map<Formula, Set<CDOMObject>>>();
            this.setCache(id, componentMap);
        }
        return componentMap;
    }

    public void removeAll(CharID id, Object source) {
        Map<VariableKey, Map<Formula, Set<CDOMObject>>> vkMap = this.getCachedMap(id);
        if (vkMap != null) {
            Iterator<Map<Formula, Set<CDOMObject>>> mit = vkMap.values().iterator();
            while (mit.hasNext()) {
                Map<Formula, Set<CDOMObject>> fMap = mit.next();
                Iterator<Set<CDOMObject>> sit = fMap.values().iterator();
                while (sit.hasNext()) {
                    Set<CDOMObject> set = sit.next();
                    if (!set.remove(source) || !set.isEmpty()) continue;
                    sit.remove();
                }
                if (!fMap.isEmpty()) continue;
                mit.remove();
            }
        }
    }

    public Double getVariableValue(CharID id, VariableKey key, boolean isMax) {
        Map<VariableKey, Map<Formula, Set<CDOMObject>>> vkMap = this.getCachedMap(id);
        if (vkMap == null) {
            return null;
        }
        Map<Formula, Set<CDOMObject>> fMap = vkMap.get(key);
        if (fMap == null) {
            return null;
        }
        Double returnValue = null;
        for (Map.Entry<Formula, Set<CDOMObject>> me : fMap.entrySet()) {
            Formula f = me.getKey();
            Set<CDOMObject> sources = me.getValue();
            for (CDOMObject source : sources) {
                double newVal = this.formulaResolvingFacet.resolve(id, f, source.getQualifiedKey()).doubleValue();
                if (returnValue == null) {
                    returnValue = newVal;
                    continue;
                }
                if (!(returnValue > newVal ^ isMax)) continue;
                returnValue = newVal;
            }
        }
        return returnValue;
    }

    public boolean contains(CharID id, VariableKey vk) {
        Map<VariableKey, Map<Formula, Set<CDOMObject>>> vkMap = this.getCachedMap(id);
        return vkMap != null && vkMap.containsKey(vk);
    }

    public int getVariableCount(CharID id) {
        Map<VariableKey, Map<Formula, Set<CDOMObject>>> vkMap = this.getCachedMap(id);
        return vkMap == null ? 0 : vkMap.size();
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        Map<VariableKey, Map<Formula, Set<CDOMObject>>> cm = this.getCachedMap(source);
        if (cm != null) {
            for (Map.Entry<VariableKey, Map<Formula, Set<CDOMObject>>> me : cm.entrySet()) {
                VariableKey vk = me.getKey();
                for (Map.Entry<Formula, Set<CDOMObject>> fme : me.getValue().entrySet()) {
                    Formula f = fme.getKey();
                    for (CDOMObject cdo : fme.getValue()) {
                        this.add(copy, vk, f, cdo);
                    }
                }
            }
        }
    }
}

