/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import pcgen.base.test.InequalityTester;
import pcgen.base.util.DoubleKeyMap;
import pcgen.cdom.base.PCGenIdentifier;
import pcgen.util.Logging;

public abstract class AbstractStorageFacet<T extends PCGenIdentifier> {
    private final Class<?> thisClass = this.getClass();
    private static final DoubleKeyMap<PCGenIdentifier, Class<?>, Object> CACHE = new DoubleKeyMap(WeakHashMap.class, HashMap.class);

    public abstract void copyContents(T var1, T var2);

    public Object removeCache(T id) {
        if (id == null) {
            throw new IllegalArgumentException("PCGenIdentifier cannot be null in removeCache");
        }
        return CACHE.remove(id, this.thisClass);
    }

    public Object setCache(T id, Object o) {
        if (id == null) {
            throw new IllegalArgumentException("PCGenIdentifier cannot be null in setCache");
        }
        return CACHE.put(id, this.thisClass, o);
    }

    public Object getCache(T id) {
        if (id == null) {
            throw new IllegalArgumentException("PCGenIdentifier cannot be null in getCache");
        }
        return CACHE.get(id, this.thisClass);
    }

    public static boolean areEqualCache(PCGenIdentifier id1, PCGenIdentifier id2, InequalityTester t) {
        Set set2;
        if (id1 == null) {
            throw new IllegalArgumentException("PCGenIdentifier #1 cannot be null in areEqualCache");
        }
        if (id2 == null) {
            throw new IllegalArgumentException("PCGenIdentifier #2 cannot be null in areEqualCache");
        }
        Set set1 = CACHE.getSecondaryKeySet((Object)id1);
        if (!set1.equals(set2 = CACHE.getSecondaryKeySet((Object)id2))) {
            ArrayList l1 = new ArrayList(set1);
            l1.removeAll(set2);
            ArrayList l2 = new ArrayList(set2);
            l2.removeAll(set1);
            Logging.errorPrint("Inequal: " + l1 + " " + l2);
            return false;
        }
        for (Class cl : set1) {
            Object obj2;
            Object obj1 = CACHE.get((Object)id1, (Object)cl);
            String equal = t.testEquality(obj1, obj2 = CACHE.get((Object)id2, (Object)cl), cl + "/");
            if (equal == null) continue;
            Logging.errorPrint(equal);
            return false;
        }
        return true;
    }

    public static Map<Class<?>, Object> peekAtCache(PCGenIdentifier id) {
        if (id == null) {
            throw new IllegalArgumentException("PCGenIdentifier cannot be null in peekAtCache");
        }
        return CACHE.getReadOnlyMapFor((Object)id);
    }
}

