/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.CDOMGroupRef;

public final class CDOMTypeRef<T>
extends CDOMGroupRef<T> {
    private List<T> referencedList = null;
    private final String[] types;

    public CDOMTypeRef(Class<T> objClass, String[] typeArray) {
        super(objClass, objClass.getSimpleName() + " " + Arrays.deepToString(typeArray));
        this.types = new String[typeArray.length];
        System.arraycopy(typeArray, 0, this.types, 0, typeArray.length);
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return "TYPE=" + StringUtil.join((String[])this.types, (String)".");
    }

    @Override
    public boolean contains(T item) {
        if (this.referencedList == null) {
            throw new IllegalStateException("Cannot ask for contains: Reference has not been resolved");
        }
        return this.referencedList.contains(item);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CDOMTypeRef) {
            CDOMTypeRef ref = (CDOMTypeRef)obj;
            return this.getReferenceClass().equals(ref.getReferenceClass()) && this.getName().equals(ref.getName()) && Arrays.deepEquals(this.types, ref.types);
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceClass().hashCode() ^ this.getName().hashCode();
    }

    @Override
    public void addResolution(T item) {
        if (item.getClass().equals(this.getReferenceClass())) {
            if (this.referencedList == null) {
                this.referencedList = new ArrayList<T>();
            }
        } else {
            throw new IllegalArgumentException("Cannot resolve a " + this.getReferenceClass().getSimpleName() + " Reference to a " + item.getClass().getSimpleName());
        }
        this.referencedList.add(item);
    }

    @Override
    public int getObjectCount() {
        return this.referencedList == null ? 0 : this.referencedList.size();
    }

    @Override
    public Collection<T> getContainedObjects() {
        if (this.referencedList == null) {
            throw new IllegalStateException("Cannot ask for contained objects: Reference has not been resolved");
        }
        return Collections.unmodifiableList(this.referencedList);
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    @Override
    public String getChoice() {
        return null;
    }
}

