/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.math.BigDecimal;
import java.util.List;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooseController;

public class AbilityChooseController
extends ChooseController<Ability> {
    private final Ability ability;
    private final AbilityCategory ac;
    private final PlayerCharacter pc;
    ChoiceManagerList<?> ccm;

    public AbilityChooseController(Ability a, AbilityCategory cat, PlayerCharacter aPC, ChoiceManagerList<?> cont) {
        if (a == null) {
            throw new IllegalArgumentException("Ability cannot be null for AbilityChooseController");
        }
        this.ability = a;
        this.ac = cat;
        this.pc = aPC;
        this.ccm = cont;
    }

    @Override
    public int getPool() {
        if (this.isMultYes()) {
            int availPool = this.pc.getAvailableAbilityPool(this.ac).intValue();
            return availPool == 0 && this.getCost() == 0.0 ? 1 : availPool;
        }
        return 1;
    }

    @Override
    public boolean isMultYes() {
        return this.ability.getSafe(ObjectKey.MULTIPLE_ALLOWED);
    }

    @Override
    public boolean isStackYes() {
        return this.ability.getSafe(ObjectKey.STACKS);
    }

    @Override
    public double getCost() {
        return this.ability.getSafe(ObjectKey.SELECTION_COST).doubleValue();
    }

    @Override
    public int getTotalChoices() {
        return this.isMultYes() ? Integer.MAX_VALUE : 1;
    }

    @Override
    public void adjustPool(List<? extends Ability> selected) {
        double cost;
        if (AbilityCategory.FEAT.equals(this.ac) && (cost = this.getCost()) > 0.0) {
            int preChooserChoices = this.ccm.getPreChooserChoices();
            int choicesPerUnitCost = this.ccm.getChoicesPerUnitCost();
            int basePriorCost = (preChooserChoices + (choicesPerUnitCost - 1)) / choicesPerUnitCost;
            int baseTotalCost = (selected.size() + (choicesPerUnitCost - 1)) / choicesPerUnitCost;
            this.pc.adjustAbilities(AbilityCategory.FEAT, new BigDecimal(cost * (double)(basePriorCost - baseTotalCost)));
        }
    }
}

