/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.CDOMChooserFacadeImpl;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooseController;
import pcgen.facade.core.ChooserFacade;
import pcgen.gui2.facade.Gui2InfoFactory;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;

public class CDOMChoiceManager<T>
implements ChoiceManagerList<T> {
    private final ChooseDriver owner;
    private final Integer numberOfChoices;
    protected final int choicesPerUnitCost;
    protected ChooseController<T> controller = new ChooseController();
    protected final ChooseInformation<T> info;
    private transient int preChooserChoices;

    public CDOMChoiceManager(ChooseDriver cdo, ChooseInformation<T> chooseType, Integer numChoices, int cost) {
        this.numberOfChoices = numChoices;
        this.owner = cdo;
        this.info = chooseType;
        this.choicesPerUnitCost = cost;
    }

    @Override
    public void getChoices(PlayerCharacter pc, List<T> availableList, List<T> selectedList) {
        availableList.addAll(this.info.getSet(pc));
        List<T> selected = this.info.getChoiceActor().getCurrentlySelected(this.owner, pc);
        if (selected != null) {
            selectedList.addAll(selected);
        }
        this.preChooserChoices = selectedList.size();
    }

    @Override
    public String typeHandled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean conditionallyApply(PlayerCharacter pc, T item) {
        List<T> oldSelections = this.info.getChoiceActor().getCurrentlySelected(this.owner, pc);
        boolean applied = false;
        if ((oldSelections == null || !oldSelections.contains(item)) && this.info.getSet(pc).contains(item)) {
            this.info.getChoiceActor().applyChoice(this.owner, item, pc);
            applied = true;
        }
        this.adjustPool(this.info.getChoiceActor().getCurrentlySelected(this.owner, pc));
        return applied;
    }

    @Override
    public boolean applyChoices(PlayerCharacter pc, List<T> selected) {
        List<T> oldSelections = this.info.getChoiceActor().getCurrentlySelected(this.owner, pc);
        ArrayList<T> toAdd = new ArrayList<T>();
        for (T obj : selected) {
            if (oldSelections != null && oldSelections.remove(obj)) continue;
            toAdd.add(obj);
        }
        int oldSize = 0;
        if (oldSelections != null) {
            oldSize = oldSelections.size();
            for (Object obj : oldSelections) {
                this.info.getChoiceActor().removeChoice(pc, this.owner, obj);
            }
        }
        for (Object obj : toAdd) {
            this.info.getChoiceActor().applyChoice(this.owner, obj, pc);
        }
        this.adjustPool(selected);
        return oldSize != selected.size();
    }

    @Override
    public List<T> doChooser(PlayerCharacter aPc, List<T> availableList, List<T> selectedList, List<String> reservedList) {
        String title;
        boolean dupsAllowed;
        int effectiveChoices = this.getNumEffectiveChoices(selectedList, reservedList, aPc);
        boolean bl = dupsAllowed = this.controller.isMultYes() && this.controller.isStackYes();
        if (!dupsAllowed) {
            availableList.removeAll(selectedList);
        }
        Globals.sortChooserLists(availableList, selectedList);
        String string = title = StringUtils.isBlank(this.info.getTitle()) ? "in_chooser" : this.info.getTitle();
        if (title.startsWith("in_")) {
            title = LanguageBundle.getString(title);
        }
        CDOMChooserFacadeImpl<T> chooserFacade = new CDOMChooserFacadeImpl<T>(title, availableList, selectedList, effectiveChoices);
        chooserFacade.setDefaultView(ChooserFacade.ChooserTreeViewType.NAME);
        chooserFacade.setAllowsDups(dupsAllowed);
        chooserFacade.setInfoFactory(new Gui2InfoFactory(aPc));
        ChooserFactory.getDelegate().showGeneralChooser(chooserFacade);
        return chooserFacade.getFinalSelected();
    }

    @Override
    public int getNumEffectiveChoices(List<? extends T> selectedList, List<String> reservedList, PlayerCharacter aPc) {
        int numChoices;
        int selectedPoolValue = (selectedList.size() + (this.choicesPerUnitCost - 1)) / this.choicesPerUnitCost;
        int reservedPoolValue = (reservedList.size() + (this.choicesPerUnitCost - 1)) / this.choicesPerUnitCost;
        int effectiveTotalChoices = this.numberOfChoices == null ? this.controller.getTotalChoices() : this.numberOfChoices - reservedPoolValue + selectedPoolValue;
        int effectiveChoices = Math.min(this.controller.getPool() + selectedPoolValue, effectiveTotalChoices / this.choicesPerUnitCost);
        effectiveChoices *= this.choicesPerUnitCost;
        Formula formula = this.owner.getNumChoices();
        if (formula != null && (numChoices = formula.resolve(aPc, this.owner.getFormulaSource()).intValue()) > 0) {
            effectiveChoices = Math.min(effectiveChoices, numChoices);
        }
        return effectiveChoices -= selectedList.size();
    }

    @Override
    public List<T> doChooserRemove(PlayerCharacter pc, List<T> availableList, List<T> selectedList, List<String> reservedList) {
        return this.doChooser(pc, availableList, selectedList, reservedList);
    }

    protected void adjustPool(List<? extends T> selected) {
        this.controller.adjustPool(selected);
    }

    @Override
    public void setController(ChooseController<T> cc) {
        this.controller = cc;
    }

    @Override
    public int getChoicesPerUnitCost() {
        return this.choicesPerUnitCost;
    }

    @Override
    public int getPreChooserChoices() {
        return this.preChooserChoices;
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, ChooseDriver target, String choice) {
        if (choice.length() > 0) {
            T ch = this.info.decodeChoice(Globals.getContext(), choice);
            if (ch == null) {
                Logging.errorPrint("Error finding " + this.info.getClassIdentity().getName() + " " + choice + ": Not Found");
            } else {
                this.info.restoreChoice(pc, target, ch);
            }
        }
    }

    protected String getTitle() {
        return new StringBuilder(50).append(this.info.getTitle()).append(" (").append(this.owner.getDisplayName()).append(')').toString();
    }

    @Override
    public void removeChoice(PlayerCharacter pc, ChooseDriver obj, T selection) {
        this.info.removeChoice(pc, obj, selection);
    }

    @Override
    public T decodeChoice(String choice) {
        return this.info.decodeChoice(Globals.getContext(), choice);
    }

    @Override
    public void applyChoice(PlayerCharacter pc, ChooseDriver cdo, T selection) {
        this.info.getChoiceActor().applyChoice(cdo, selection, pc);
    }

    @Override
    public String encodeChoice(T obj) {
        return this.info.encodeChoice(obj);
    }
}

