/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter.panel;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import pcgen.gui2.tools.Utility;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class ConversionChoiceDialog
extends JDialog
implements ActionListener {
    private List<String> choices;
    private String introText;
    private int result = -1;
    private JComboBox choiceCombo;
    private int defaultChoice;

    public ConversionChoiceDialog(Frame parent, String introText, List<String> choices, int defaultChoice) {
        super(parent, "PCGenDataConvert", true);
        this.introText = introText;
        this.choices = choices;
        this.defaultChoice = defaultChoice;
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    public int getResult() {
        return this.result;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JTextArea introLabel = new JTextArea(this.introText, 5, 40);
        introLabel.setEditable(false);
        introLabel.setWrapStyleWord(true);
        introLabel.setLineWrap(true);
        GridBagConstraints gbc = new GridBagConstraints();
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 1.0);
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 5, 10);
        this.add((Component)introLabel, gbc);
        this.choiceCombo = new JComboBox();
        for (String choice : this.choices) {
            this.choiceCombo.addItem(choice);
        }
        if (this.defaultChoice >= 0 && this.defaultChoice < this.choices.size()) {
            this.choiceCombo.setSelectedIndex(this.defaultChoice);
        }
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 0.0, 2, 17);
        gbc.insets = new Insets(5, 10, 5, 10);
        this.add((Component)this.choiceCombo, gbc);
        JLabel dummy = new JLabel(" ");
        Utility.buildRelativeConstraints(gbc, 1, 1, 1.0, 0.0, 2, 17);
        this.add((Component)dummy, gbc);
        JButton okButton = new JButton(LanguageBundle.getString("in_ok"));
        okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        Utility.buildRelativeConstraints(gbc, 0, 0, 0.0, 0.0, 0, 13);
        gbc.insets = new Insets(5, 5, 10, 10);
        this.add((Component)okButton, gbc);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConversionChoiceDialog.this.result = ConversionChoiceDialog.this.choiceCombo.getSelectedIndex();
                ConversionChoiceDialog.this.setVisible(false);
                ConversionChoiceDialog.this.logChoice();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.result = this.choiceCombo.getSelectedIndex();
        this.setVisible(false);
        this.logChoice();
    }

    private void logChoice() {
        Logging.log(Logging.INFO, "Decision required: " + this.introText + "\nChoices: " + this.choices + "\nChoice made: " + this.choices.get(this.result));
    }
}

