/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util.treetable;

import javax.swing.tree.DefaultTreeModel;
import pcgen.gui2.util.treetable.TreeTableModel;
import pcgen.gui2.util.treetable.TreeTableNode;
import pcgen.util.Logging;

public abstract class AbstractTreeTableModel
extends DefaultTreeModel
implements TreeTableModel {
    protected AbstractTreeTableModel() {
        this(null);
    }

    public AbstractTreeTableModel(TreeTableNode root) {
        super(root);
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return this.getColumnClass(column) == TreeTableNode.class;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column == 0) {
            return TreeTableNode.class;
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int column) {
        String result = "";
        while (column >= 0) {
            result = (char)((char)(column % 26) + 65) + result;
            column = column / 26 - 1;
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        if (node == null) {
            Logging.log(Logging.WARNING, "Ignored attempt to set value of a null node. " + aValue + " col " + column);
            return;
        }
        TreeTableNode aNode = (TreeTableNode)node;
        aNode.setValueAt(aValue, column);
        this.nodeChanged(aNode);
    }

    @Override
    public Object getValueAt(Object node, int column) {
        return node == null ? null : ((TreeTableNode)node).getValueAt(column);
    }
}

