/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Objects;
import pcgen.base.lang.ObjectUtil;
import pcgen.persistence.lst.URIFactory;
import pcgen.util.Logging;

public class URIEntry {
    private final String campaignName;
    private final URIFactory uriFac;
    private URI uri = null;

    URIEntry(String campaignName, URI uri) {
        this.campaignName = Objects.requireNonNull(campaignName);
        this.uri = Objects.requireNonNull(uri);
        this.uriFac = null;
    }

    private URIEntry(String campaignName, URIFactory fac) {
        this.campaignName = Objects.requireNonNull(campaignName);
        this.uriFac = Objects.requireNonNull(fac);
    }

    public URI getURI() {
        if (this.uri == null) {
            this.uri = this.uriFac.getURI();
        }
        return this.uri;
    }

    public boolean equals(Object arg0) {
        if (arg0 == this) {
            return true;
        }
        if (arg0 instanceof URIEntry) {
            URIEntry other = (URIEntry)arg0;
            return ObjectUtil.compareWithNull((Object)this.uriFac, (Object)other.uriFac) && this.getURI().equals(other.getURI());
        }
        return false;
    }

    public int hashCode() {
        return this.getLSTformat().hashCode();
    }

    public String toString() {
        StringBuilder sBuff = new StringBuilder();
        sBuff.append("Campaign: ");
        sBuff.append(this.campaignName);
        sBuff.append("; SourceFile: ");
        sBuff.append(this.getURI());
        return sBuff.toString();
    }

    public String getLSTformat() {
        if (this.uriFac == null) {
            return this.uri.toString();
        }
        return this.uriFac.getOffset();
    }

    public URIEntry getRelatedTarget(String fileName) {
        return new URIEntry(this.campaignName, new URIFactory(Objects.requireNonNull(this.uriFac).getRootURI(), fileName));
    }

    public static URIEntry getURIEntry(String campaignName, URI rootURI, String offset) {
        if (offset == null || offset.isEmpty()) {
            Logging.errorPrint("Cannot build URIEntry for empty value in " + rootURI);
            return null;
        }
        return new URIEntry(campaignName, new URIFactory(rootURI, offset));
    }
}

