/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.ability;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.Visibility;

public class VisibleToken
extends AbstractNonEmptyToken<Ability>
implements CDOMPrimaryToken<Ability> {
    @Override
    public String getTokenName() {
        return "VISIBLE";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, Ability ability, String value) {
        Visibility vis;
        if (value.equals("YES")) {
            vis = Visibility.DEFAULT;
        } else if (value.equals("DISPLAY")) {
            vis = Visibility.DISPLAY_ONLY;
        } else if (value.equals("EXPORT")) {
            vis = Visibility.OUTPUT_ONLY;
        } else if (value.equals("NO")) {
            vis = Visibility.HIDDEN;
        } else {
            return new ParseResult.Fail("Unable to understand " + this.getTokenName() + " tag: " + value, context);
        }
        context.getObjectContext().put((CDOMObject)ability, ObjectKey.VISIBILITY, vis);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Ability ability) {
        String visString;
        Visibility vis = context.getObjectContext().getObject(ability, ObjectKey.VISIBILITY);
        if (vis == null) {
            return null;
        }
        if (vis.equals((Object)Visibility.DEFAULT)) {
            visString = "YES";
        } else if (vis.equals((Object)Visibility.DISPLAY_ONLY)) {
            visString = "DISPLAY";
        } else if (vis.equals((Object)Visibility.OUTPUT_ONLY)) {
            visString = "EXPORT";
        } else if (vis.equals((Object)Visibility.HIDDEN)) {
            visString = "NO";
        } else {
            context.addWriteMessage("Visibility " + (Object)((Object)vis) + " is not a valid Visibility for an Ability");
            return null;
        }
        return new String[]{visString};
    }

    @Override
    public Class<Ability> getTokenClass() {
        return Ability.class;
    }
}

