/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SubClassCategory;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CategorizedCDOMReference;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.SubClass;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class FavoredclassToken
extends AbstractTokenWithSeparator<PCTemplate>
implements CDOMPrimaryToken<PCTemplate>,
ChooseSelectionActor<PCClass> {
    public static final Class<PCClass> PCCLASS_CLASS = PCClass.class;
    public static final Class<SubClass> SUBCLASS_CLASS = SubClass.class;

    @Override
    public String getTokenName() {
        return "FAVOREDCLASS";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCTemplate pct, String value) {
        context.getObjectContext().remove((CDOMObject)pct, ObjectKey.ANY_FAVORED_CLASS);
        context.getObjectContext().removeList(pct, ListKey.FAVORED_CLASS);
        context.getObjectContext().removeFromList(pct, ListKey.NEW_CHOOSE_ACTOR, this);
        return this.parseFavoredClass(context, pct, value);
    }

    public ParseResult parseFavoredClass(LoadContext context, CDOMObject cdo, String value) {
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            CDOMSingleRef<PCClass> ref;
            String token = tok.nextToken();
            if ("HIGHESTLEVELCLASS".equalsIgnoreCase(token)) {
                foundAny = true;
                context.getObjectContext().put(cdo, ObjectKey.ANY_FAVORED_CLASS, true);
                continue;
            }
            if ("%LIST".equalsIgnoreCase(token)) {
                context.getObjectContext().addToList(cdo, ListKey.NEW_CHOOSE_ACTOR, this);
                continue;
            }
            foundOther = true;
            int dotLoc = token.indexOf(46);
            if (dotLoc == -1) {
                ref = context.getReferenceContext().getCDOMReference(PCCLASS_CLASS, token);
            } else {
                ParseResult pr = this.checkForIllegalSeparator('.', token);
                if (!pr.passed()) {
                    return pr;
                }
                String parent = token.substring(0, dotLoc);
                String subclass = token.substring(dotLoc + 1);
                SubClassCategory scc = SubClassCategory.getConstant(parent);
                ref = context.getReferenceContext().getCDOMReference(SUBCLASS_CLASS, scc, subclass);
            }
            context.getObjectContext().addToList(cdo, ListKey.FAVORED_CLASS, ref);
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains " + "HIGHESTLEVELCLASS" + " and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCTemplate pct) {
        Collection<ChooseSelectionActor<?>> listAdded;
        Changes<CDOMReference<? extends PCClass>> changes = context.getObjectContext().getListChanges(pct, ListKey.FAVORED_CLASS);
        Changes<ChooseSelectionActor<?>> listChanges = context.getObjectContext().getListChanges(pct, ListKey.NEW_CHOOSE_ACTOR);
        Boolean anyfavored = context.getObjectContext().getObject(pct, ObjectKey.ANY_FAVORED_CLASS);
        TreeSet<String> set = new TreeSet<String>();
        if (anyfavored != null && anyfavored.booleanValue()) {
            set.add("HIGHESTLEVELCLASS");
        }
        if (changes != null && !changes.isEmpty() && changes.hasAddedItems()) {
            for (CDOMReference<? extends PCClass> ref : changes.getAdded()) {
                Class<? extends PCClass> refClass = ref.getReferenceClass();
                if (SUBCLASS_CLASS.equals(refClass)) {
                    Category parent = ((CategorizedCDOMReference)((Object)ref)).getCDOMCategory();
                    set.add(parent.toString() + "." + ref.getLSTformat(false));
                    continue;
                }
                set.add(ref.getLSTformat(false));
            }
        }
        if ((listAdded = listChanges.getAdded()) != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor<?> cra : listAdded) {
                if (!cra.getSource().equals(this.getTokenName())) continue;
                try {
                    set.add(cra.getLstFormat());
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + e);
                    return null;
                }
            }
        }
        if (set.isEmpty()) {
            return null;
        }
        return new String[]{StringUtil.join(set, (String)"|")};
    }

    @Override
    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }

    @Override
    public String getSource() {
        return this.getTokenName();
    }

    @Override
    public String getLstFormat() {
        return "%LIST";
    }

    @Override
    public void applyChoice(ChooseDriver obj, PCClass cls, PlayerCharacter pc) {
        pc.addFavoredClass(cls, obj);
    }

    @Override
    public void removeChoice(ChooseDriver obj, PCClass cls, PlayerCharacter pc) {
        pc.removeFavoredClass(cls, obj);
    }

    @Override
    public Class<PCClass> getChoiceClass() {
        return PCCLASS_CLASS;
    }
}

