/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache;

import coursierapi.shaded.coursier.cache.CachePolicy;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalOnly$;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalUpdateChanging$;
import coursierapi.shaded.coursier.cache.CachePolicy$Update$;
import coursierapi.shaded.coursier.credentials.Credentials;
import coursierapi.shaded.coursier.credentials.DirectCredentials;
import coursierapi.shaded.coursier.credentials.DirectCredentials$;
import coursierapi.shaded.coursier.credentials.FileCredentials;
import coursierapi.shaded.coursier.credentials.FileCredentials$;
import coursierapi.shaded.coursier.credentials.Password;
import coursierapi.shaded.coursier.credentials.Password$;
import coursierapi.shaded.coursier.parse.CachePolicyParser$;
import coursierapi.shaded.coursier.parse.CredentialsParser$;
import coursierapi.shaded.coursier.paths.CachePath;
import coursierapi.shaded.coursier.paths.CoursierPaths;
import coursierapi.shaded.coursier.util.Sync$;
import coursierapi.shaded.scala.Console$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.cli.config.ConfigDb;
import coursierapi.shaded.scala.cli.config.ConfigDb$;
import coursierapi.shaded.scala.cli.config.Keys$;
import coursierapi.shaded.scala.cli.config.PasswordOption;
import coursierapi.shaded.scala.cli.config.RepositoryCredentials;
import coursierapi.shaded.scala.collection.ArrayOps$;
import coursierapi.shaded.scala.collection.IterableOps;
import coursierapi.shaded.scala.collection.SeqFactory;
import coursierapi.shaded.scala.collection.SeqFactory$UnapplySeqWrapper$;
import coursierapi.shaded.scala.collection.SeqOps;
import coursierapi.shaded.scala.collection.StringOps$;
import coursierapi.shaded.scala.collection.immutable.$colon$colon;
import coursierapi.shaded.scala.collection.immutable.List;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.collection.mutable.ArraySeq;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.concurrent.duration.Duration$;
import coursierapi.shaded.scala.concurrent.duration.FiniteDuration;
import coursierapi.shaded.scala.concurrent.duration.package;
import coursierapi.shaded.scala.concurrent.duration.package$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Nothing$;
import coursierapi.shaded.scala.runtime.RichChar$;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Failure;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import coursierapi.shaded.scala.util.Success;
import coursierapi.shaded.scala.util.Try;
import coursierapi.shaded.scala.util.Try$;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;

public final class CacheDefaults$ {
    public static final CacheDefaults$ MODULE$ = new CacheDefaults$();
    private static File location;
    private static File archiveCacheLocation;
    private static int concurrentDownloadCount;
    private static ExecutorService pool;
    private static Option<Duration> ttl;
    private static int retryCount;
    private static FiniteDuration retryBackoffInitialDelay;
    private static double retryBackoffMultiplier;
    private static Option<Object> maxRedirections;
    private static final Seq<Option<String>> checksums;
    private static final int bufferSize;
    private static final Seq<CachePolicy.Mixed> noEnvCachePolicies;
    private static volatile int bitmap$0;

    static {
        checksums = new $colon$colon<Nothing$>((Nothing$)((Object)new Some<String>("SHA-1")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)None$.MODULE$), Nil$.MODULE$));
        bufferSize = 0x100000;
        noEnvCachePolicies = new $colon$colon<Nothing$>((Nothing$)((Object)CachePolicy$LocalUpdateChanging$.MODULE$), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)CachePolicy$LocalOnly$.MODULE$), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)CachePolicy$Update$.MODULE$), Nil$.MODULE$)));
    }

    private File location$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 1) == 0) {
                location = CachePath.defaultCacheDirectory();
                bitmap$0 |= 1;
            }
        }
        return location;
    }

    public File location() {
        if ((bitmap$0 & 1) == 0) {
            return this.location$lzycompute();
        }
        return location;
    }

    private File archiveCacheLocation$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 2) == 0) {
                archiveCacheLocation = CachePath.defaultArchiveCacheDirectory();
                bitmap$0 |= 2;
            }
        }
        return archiveCacheLocation;
    }

    public File archiveCacheLocation() {
        if ((bitmap$0 & 2) == 0) {
            return this.archiveCacheLocation$lzycompute();
        }
        return archiveCacheLocation;
    }

    private int defaultConcurrentDownloadCount() {
        return 6;
    }

    private int concurrentDownloadCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 4) == 0) {
                concurrentDownloadCount = BoxesRunTime.unboxToInt(coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.parallel-download-count").flatMap((Function1<String, Option> & Serializable)s -> Try$.MODULE$.apply(() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)s))).toOption()).getOrElse(() -> MODULE$.defaultConcurrentDownloadCount()));
                bitmap$0 |= 4;
            }
        }
        return concurrentDownloadCount;
    }

    public int concurrentDownloadCount() {
        if ((bitmap$0 & 4) == 0) {
            return this.concurrentDownloadCount$lzycompute();
        }
        return concurrentDownloadCount;
    }

    private ExecutorService pool$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 8) == 0) {
                pool = Sync$.MODULE$.fixedThreadPool(this.concurrentDownloadCount());
                bitmap$0 |= 8;
            }
        }
        return pool;
    }

    public ExecutorService pool() {
        if ((bitmap$0 & 8) == 0) {
            return this.pool$lzycompute();
        }
        return pool;
    }

    public Either<Throwable, Duration> parseDuration(String s) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)) && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(s), (Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(CacheDefaults$.$anonfun$parseDuration$1(BoxesRunTime.unboxToChar(x$1))))) {
            return new Right<Throwable, Duration>(Duration$.MODULE$.Zero());
        }
        Try try_ = Try$.MODULE$.apply((Function0<Duration> & Serializable)() -> Duration$.MODULE$.apply(s));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Duration s2 = (Duration)success.value();
            return new Right<Throwable, Duration>(s2);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            return new Left<Throwable, Duration>(t);
        }
        throw new MatchError(try_);
    }

    private Option<Duration> ttl$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x10) == 0) {
                Option fromEnv = Option$.MODULE$.apply(System.getenv("COURSIER_TTL")).flatMap((Function1<String, Option> & Serializable)x$2 -> MODULE$.parseDuration((String)x$2).toOption());
                ttl = fromEnv.orElse((Function0<Option> & Serializable)() -> CacheDefaults$.fromProps$1()).orElse((Function0<Some> & Serializable)() -> new Some<FiniteDuration>(CacheDefaults$.default$1()));
                bitmap$0 |= 0x10;
            }
        }
        return ttl;
    }

    public Option<Duration> ttl() {
        if ((bitmap$0 & 0x10) == 0) {
            return this.ttl$lzycompute();
        }
        return ttl;
    }

    public Seq<Option<String>> checksums() {
        return checksums;
    }

    public int defaultRetryCount() {
        return 5;
    }

    private FiniteDuration defaultRetryBackoffInitialDelay() {
        return new package.DurationInt(package$.MODULE$.DurationInt(10)).milliseconds();
    }

    private double defaultRetryBackoffMultiplier() {
        return 2.0;
    }

    private int retryCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x20) == 0) {
                retryCount = BoxesRunTime.unboxToInt(coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.exception-retry").flatMap((Function1<String, Option> & Serializable)s -> Try$.MODULE$.apply(() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)s))).toOption()).filter(x$4 -> x$4 >= 0).getOrElse(() -> MODULE$.defaultRetryCount()));
                bitmap$0 |= 0x20;
            }
        }
        return retryCount;
    }

    public int retryCount() {
        if ((bitmap$0 & 0x20) == 0) {
            return this.retryCount$lzycompute();
        }
        return retryCount;
    }

    private FiniteDuration retryBackoffInitialDelay$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x40) == 0) {
                retryBackoffInitialDelay = (FiniteDuration)coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.exception-retry-backoff-initial-delay").flatMap((Function1<String, Option> & Serializable)s -> MODULE$.parseDuration((String)s).toOption()).collect(new Serializable(){

                    public final <A1 extends Duration, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof FiniteDuration) {
                            FiniteDuration finiteDuration = (FiniteDuration)A1;
                            return (B1)finiteDuration;
                        }
                        return function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Duration x1) {
                        Duration duration = x1;
                        return duration instanceof FiniteDuration;
                    }
                }).getOrElse((Function0<FiniteDuration> & Serializable)() -> MODULE$.defaultRetryBackoffInitialDelay());
                bitmap$0 |= 0x40;
            }
        }
        return retryBackoffInitialDelay;
    }

    public FiniteDuration retryBackoffInitialDelay() {
        if ((bitmap$0 & 0x40) == 0) {
            return this.retryBackoffInitialDelay$lzycompute();
        }
        return retryBackoffInitialDelay;
    }

    private double retryBackoffMultiplier$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x80) == 0) {
                retryBackoffMultiplier = BoxesRunTime.unboxToDouble(coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.exception-retry-backoff-multiplier").flatMap((Function1<String, Option> & Serializable)s -> Try$.MODULE$.apply(() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString((String)s))).toOption()).filter(x$5 -> x$5 > 0.0).getOrElse(() -> MODULE$.defaultRetryBackoffMultiplier()));
                bitmap$0 |= 0x80;
            }
        }
        return retryBackoffMultiplier;
    }

    public double retryBackoffMultiplier() {
        if ((bitmap$0 & 0x80) == 0) {
            return this.retryBackoffMultiplier$lzycompute();
        }
        return retryBackoffMultiplier;
    }

    private Option<Object> defaultMaxRedirections() {
        return Option$.MODULE$.apply(BoxesRunTime.boxToInteger(20));
    }

    private Option<Object> maxRedirections$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((bitmap$0 & 0x100) == 0) {
                maxRedirections = CacheDefaults$.prop$1("coursierapi.shaded.coursier.http.maxRedirects").orElse((Function0<Option> & Serializable)() -> CacheDefaults$.prop$1("http.maxRedirects")).orElse((Function0<Option> & Serializable)() -> MODULE$.defaultMaxRedirections());
                bitmap$0 |= 0x100;
            }
        }
        return maxRedirections;
    }

    public Option<Object> maxRedirections() {
        if ((bitmap$0 & 0x100) == 0) {
            return this.maxRedirections$lzycompute();
        }
        return maxRedirections;
    }

    public int bufferSize() {
        return bufferSize;
    }

    private Option<String> credentialPropOpt() {
        return Option$.MODULE$.apply(System.getenv("COURSIER_CREDENTIALS")).orElse((Function0<Option> & Serializable)() -> coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.credentials")).map((Function1<String, String> & Serializable)s -> StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString((String)s), (Function1<Object, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(RichChar$.MODULE$.isSpaceChar$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar(x$8))))));
    }

    private boolean isPropFile(String s) {
        return s.startsWith("/") || s.startsWith("file:");
    }

    public Seq<Credentials> credentials() {
        Seq seq;
        if (this.credentialPropOpt().isEmpty()) {
            Seq configDirs = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps(CoursierPaths.configDirectories()));
            Seq mainCredentialsFiles = (Seq)configDirs.map((Function1<File, File> & Serializable)configDir -> new File((File)configDir, "credentials.properties"));
            Seq dirs2 = (Seq)configDirs.map((Function1<File, File> & Serializable)configDir -> new File((File)configDir, "credentials"));
            Seq files2 = (Seq)dirs2.flatMap((Function1<File, Seq> & Serializable)dir2 -> {
                File[] listOrNull = dir2.listFiles((dir, name) -> !name.startsWith(".") && name.endsWith(".properties"));
                return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(listOrNull)).toSeq().flatten((Function1<File[], ArraySeq.ofRef> & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
            });
            Seq otherFiles = (Seq)((IterableOps)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(files2)).toSeq().flatten(Predef$.MODULE$.$conforms())).map((Function1<File, FileCredentials> & Serializable)f -> FileCredentials$.MODULE$.apply(f.getAbsolutePath(), true));
            seq = (Seq)((IterableOps)mainCredentialsFiles.map((Function1<File, FileCredentials> & Serializable)f -> FileCredentials$.MODULE$.apply(f.getAbsolutePath(), true))).$plus$plus(otherFiles);
        } else {
            seq = (Seq)Option$.MODULE$.option2Iterable(this.credentialPropOpt()).toSeq().flatMap((Function1<String, Seq> & Serializable)x0$1 -> {
                String string = x0$1;
                switch (string == null ? 0 : string.hashCode()) {
                    default: 
                }
                if (MODULE$.isPropFile(string)) {
                    String path0 = string.startsWith("file:") ? new File(new URI(string)).getAbsolutePath() : string;
                    return new $colon$colon<Nothing$>((Nothing$)((Object)FileCredentials$.MODULE$.apply(path0, true)), Nil$.MODULE$);
                }
                return (Seq)CredentialsParser$.MODULE$.parseSeq(string).either().toSeq().flatten(Predef$.MODULE$.$conforms());
            });
        }
        Seq legacyCredentials = seq;
        Path configPath = CoursierPaths.scalaConfigFile();
        Seq<Credentials> configCredentials = this.credentialsFromConfig(configPath);
        return (Seq)configCredentials.$plus$plus(legacyCredentials);
    }

    public Seq<Credentials> credentialsFromConfig(Path configPath) {
        ConfigDb configDb = (ConfigDb)ConfigDb$.MODULE$.open(configPath).fold((Function1<Exception, Nothing$> & Serializable)e -> {
            throw new Exception((Throwable)e);
        }, (Function1<ConfigDb, ConfigDb> & Serializable)x -> Predef$.MODULE$.identity(x));
        return (Seq)configDb.get(Keys$.MODULE$.repositoryCredentials()).fold((Function1<ConfigDb.ConfigDbFormatError, Nothing$> & Serializable)e -> {
            throw new Exception((Throwable)e);
        }, (Function1<Option, List> & Serializable)x$9 -> ((List)x$9.getOrElse((Function0<Nil$> & Serializable)() -> Nil$.MODULE$)).map((Function1<RepositoryCredentials, DirectCredentials> & Serializable)c -> DirectCredentials$.MODULE$.apply(c.host(), c.user().map((Function1<PasswordOption, String> & Serializable)x$10 -> x$10.get().value()), c.password().map((Function1<PasswordOption, Password> & Serializable)p -> Password$.MODULE$.apply(p.get().value())), c.realm(), BoxesRunTime.unboxToBoolean(c.optional().getOrElse(() -> DirectCredentials$.MODULE$.defaultOptional())), BoxesRunTime.unboxToBoolean(c.matchHost().getOrElse(() -> DirectCredentials$.MODULE$.defaultMatchHost())), BoxesRunTime.unboxToBoolean(c.httpsOnly().getOrElse(() -> DirectCredentials$.MODULE$.defaultHttpsOnly())), BoxesRunTime.unboxToBoolean(c.passOnRedirect().getOrElse(() -> DirectCredentials$.MODULE$.defaultPassOnRedirect())))));
    }

    public Seq<CachePolicy.Mixed> noEnvCachePolicies() {
        return noEnvCachePolicies;
    }

    public Seq<CachePolicy> cachePolicies() {
        Option fromEnv = CacheDefaults$.fromOption$1(Option$.MODULE$.apply(System.getenv("COURSIER_MODE")), "COURSIER_MODE environment variable");
        return (Seq)fromEnv.orElse((Function0<Option> & Serializable)() -> CacheDefaults$.fromProps$2()).getOrElse((Function0<Seq> & Serializable)() -> MODULE$.noEnvCachePolicies());
    }

    public static final /* synthetic */ boolean $anonfun$parseDuration$1(char x$1) {
        return x$1 == '0';
    }

    private static final Option fromProps$1() {
        return coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.ttl").flatMap((Function1<String, Option> & Serializable)x$3 -> MODULE$.parseDuration((String)x$3).toOption());
    }

    private static final FiniteDuration default$1() {
        return new package.DurationInt(package$.MODULE$.DurationInt(24)).hours();
    }

    private static final Option prop$1(String name) {
        return coursierapi.shaded.scala.sys.package$.MODULE$.props().get(name).flatMap((Function1<String, Option> & Serializable)s -> Try$.MODULE$.apply(() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)s))).toOption()).filter(x$7 -> x$7 >= 0);
    }

    private static final Option fromOption$1(Option value, String description) {
        return value.filter((Function1<String, Object> & Serializable)x$11 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$11)))).flatMap((Function1<String, Option> & Serializable)str -> {
            boolean bl = false;
            Right right = null;
            Either<$colon$colon<String>, Seq<CachePolicy>> either = CachePolicyParser$.MODULE$.cachePolicies((String)str, MODULE$.noEnvCachePolicies()).either();
            if (either instanceof Right) {
                SeqOps seqOps;
                bl = true;
                right = (Right)either;
                Seq seq = (Seq)right.value();
                if (seq != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = coursierapi.shaded.scala.package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                    Console$.MODULE$.err().println(new StringBuilder(40).append("Warning: no mode found in ").append(description).append(", ignoring it.").toString());
                    return None$.MODULE$;
                }
            }
            if (bl) {
                Seq policies = (Seq)right.value();
                return new Some<Seq>(policies);
            }
            if (either instanceof Left) {
                Console$.MODULE$.err().println(new StringBuilder(44).append("Warning: unrecognized mode in ").append(description).append(", ignoring it.").toString());
                return None$.MODULE$;
            }
            throw new MatchError(either);
        });
    }

    private static final Option fromProps$2() {
        return CacheDefaults$.fromOption$1(coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.mode"), "Java property coursier.mode");
    }

    private CacheDefaults$() {
    }
}

