/*
 * Decompiled with CFR 0.152.
 */
package mill.scalalib;

import geny.Writable;
import geny.Writable$;
import java.io.Serializable;
import java.util.Base64;
import mainargs.ArgSig;
import mainargs.ArgSig$;
import mainargs.MainData$;
import mainargs.TokensReader$BooleanRead$;
import mainargs.TokensReader$IntRead$;
import mainargs.TokensReader$StringRead$;
import mainargs.arg;
import mainargs.arg$;
import mainargs.main;
import mainargs.main$;
import mill.api.Ctx;
import mill.api.PathRef;
import mill.api.Result;
import mill.api.Result$;
import mill.api.Result$Failure$;
import mill.define.Caller;
import mill.define.Command;
import mill.define.Ctx$;
import mill.define.Discover;
import mill.define.Discover$;
import mill.define.EnclosingClass;
import mill.define.ExternalModule;
import mill.define.Task;
import mill.define.Task$;
import mill.define.TaskModule;
import mill.main.Tasks;
import mill.main.Tasks$;
import mill.moduledefs.Scaladoc;
import mill.package$;
import mill.scalalib.PublishModule;
import mill.scalalib.publish.Artifact;
import mill.scalalib.publish.SonatypeHelpers$;
import mill.scalalib.publish.SonatypePublisher;
import os.CommandResult;
import os.Path;
import os.ProcessInput;
import os.ProcessInput$;
import os.ProcessOutput;
import os.Shellable;
import os.Shellable$;
import os.Source;
import os.Source$;
import os.call$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;
import upickle.default$;

public final class PublishModule$
extends ExternalModule
implements TaskModule {
    public static final PublishModule$ MODULE$ = new PublishModule$();
    private static Discover millDiscover;
    private static final Seq<String> defaultGpgArgs;
    private static volatile boolean bitmap$0;

    static {
        defaultGpgArgs = MODULE$.defaultGpgArgsForPassphrase(None$.MODULE$);
    }

    @Override
    public String defaultCommandName() {
        return "publishAll";
    }

    public Seq<String> defaultGpgArgs() {
        return defaultGpgArgs;
    }

    public void pgpImportSecretIfProvided(Map<String, String> env) {
        env.get("MILL_PGP_SECRET_BASE64").foreach((Function1<String, CommandResult> & Serializable)secret -> {
            Shellable x$24 = (Shellable)Shellable$.MODULE$.tuple5Conversion((Tuple5)new Tuple5<String, String, String, String, String>("gpg", "--import", "--no-tty", "--batch", "--yes"), (Function1<String, Shellable> & Serializable)s -> Shellable$.MODULE$.StringShellable((String)s), (Function1<String, Shellable> & Serializable)s -> Shellable$.MODULE$.StringShellable((String)s), (Function1<String, Shellable> & Serializable)s -> Shellable$.MODULE$.StringShellable((String)s), (Function1<String, Shellable> & Serializable)s -> Shellable$.MODULE$.StringShellable((String)s), (Function1<String, Shellable> & Serializable)s -> Shellable$.MODULE$.StringShellable((String)s));
            ProcessInput x$25 = ProcessInput$.MODULE$.makeSourceInput(Base64.getDecoder().decode((String)secret), (Function1<byte[], Source.WritableSource> & Serializable)s -> Source$.MODULE$.WritableSource(s, (Function1<byte[], Writable.ByteArrayWritable> & Serializable)a -> Writable$.MODULE$.ByteArrayWritable((byte[])a)));
            Map<String, String> x$26 = call$.MODULE$.apply$default$2();
            Path x$27 = call$.MODULE$.apply$default$3();
            ProcessOutput x$28 = call$.MODULE$.apply$default$5();
            ProcessOutput x$29 = call$.MODULE$.apply$default$6();
            boolean x$30 = call$.MODULE$.apply$default$7();
            long x$31 = call$.MODULE$.apply$default$8();
            boolean x$32 = call$.MODULE$.apply$default$9();
            boolean x$33 = call$.MODULE$.apply$default$10();
            long x$34 = call$.MODULE$.apply$default$11();
            boolean x$35 = call$.MODULE$.apply$default$12();
            return call$.MODULE$.apply(x$24, x$26, x$27, x$25, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35);
        });
    }

    public Seq<String> defaultGpgArgsForPassphrase(Option<String> passphrase) {
        return (Seq)Option$.MODULE$.option2Iterable(passphrase.map((Function1<String, String> & Serializable)x$34 -> new StringBuilder(13).append("--passphrase=").append((String)x$34).toString())).toSeq().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)"--no-tty"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"--pinentry-mode"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"loopback"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"--batch"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"--yes"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"-a"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"-b"), Nil$.MODULE$))))))));
    }

    @Scaladoc(value="/**\n   * Publish all given artifacts to Sonatype.\n   * Uses environment variables SONATYPE_USERNAME and SONATYPE_PASSWORD as\n   * credentials.\n   *\n   * @param publishArtifacts what artifacts you want to publish. Defaults to `__.publishArtifacts`\n   *                         which selects all `PublishModule`s in your build\n   * @param sonatypeCreds Sonatype credentials in format username:password.\n   *                      If specified, environment variables will be ignored.\n   *                      <i>Note: consider using environment variables over this argument due\n   *                      to security reasons.</i>\n   * @param signed\n   * @param gpgArgs       GPG arguments. Defaults to `--passphrase=$MILL_PGP_PASSPHRASE,--no-tty,--pienty-mode,loopback,--batch,--yes,-a,-b`.\n   *                      Specifying this will override/remove the defaults.\n   *                      Add the default args to your args to keep them.\n   * @param release Whether to release the artifacts after staging them\n   * @param sonatypeUri Sonatype URI to use. Defaults to `oss.sonatype.org`, newer projects\n   *                    may need to set it to https://s01.oss.sonatype.org/service/local\n   * @param sonatypeSnapshotUri Sonatype snapshot URI to use. Defaults to `oss.sonatype.org`, newer projects\n   *                            may need to set it to https://s01.oss.sonatype.org/content/repositories/snapshots\n   * @param readTimeout How long to wait before timing out network reads\n   * @param connectTimeout How long to wait before timing out network connections\n   * @param awaitTimeout How long to wait before timing out on failed uploads\n   * @param stagingRelease\n   * @return\n   */")
    public Command<BoxedUnit> publishAll(Tasks<PublishModule.PublishData> publishArtifacts, String sonatypeCreds, boolean signed, String gpgArgs, boolean release, String sonatypeUri, String sonatypeSnapshotUri, int readTimeout, int connectTimeout, int awaitTimeout, boolean stagingRelease) {
        return new Command<BoxedUnit>((Task<BoxedUnit>)Task$.MODULE$.traverseCtx(new $colon$colon<Nothing$>((Nothing$)((Object)Task$.MODULE$.sequence(publishArtifacts.value())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.checkSonatypeCreds(sonatypeCreds)), Nil$.MODULE$)), (Function2<Seq, Ctx, Result> & Serializable)(items$macro$1, ctx$macro$2) -> {
            Seq x = (Seq)((Seq)items$macro$1.apply(false)).map((Function1<PublishModule.PublishData, Tuple2> & Serializable)x0$1 -> {
                PublishModule.PublishData publishData = x0$1;
                if (publishData != null) {
                    Artifact a = publishData.meta();
                    Seq<Tuple2<PathRef, String>> s = publishData.payload();
                    return new Tuple2(s.map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            PathRef p = (PathRef)tuple2._1();
                            String f = (String)tuple2._2();
                            return new Tuple2<Path, String>(p.path(), f);
                        }
                        throw new MatchError(tuple2);
                    }), a);
                }
                throw new MatchError(publishData);
            });
            MODULE$.pgpImportSecretIfProvided(Task$.MODULE$.env((Ctx.Env)ctx$macro$2));
            return Result$.MODULE$.create(() -> new SonatypePublisher(sonatypeUri, sonatypeSnapshotUri, (String)items$macro$1.apply(true), signed, gpgArgs.isEmpty() ? MODULE$.defaultGpgArgsForPassphrase(Task$.MODULE$.env((Ctx.Env)ctx$macro$2).get("MILL_PGP_PASSPHRASE")) : Predef$.MODULE$.copyArrayToImmutableIndexedSeq(StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(gpgArgs), ',')), readTimeout, connectTimeout, Task$.MODULE$.log((Ctx.Log)ctx$macro$2), Task$.MODULE$.workspace((Ctx)ctx$macro$2), Task$.MODULE$.env((Ctx.Env)ctx$macro$2), awaitTimeout, stagingRelease).publishAll(release, x));
        }), Ctx$.MODULE$.make(new Enclosing("mill.scalalib.PublishModule.publishAll"), new Line(661), this.millModuleBasePath(), this.millModuleSegments(), this.millModuleExternal(), this.millModuleShared(), new File("/home/runner/work/mill/mill/scalalib/src/mill/scalalib/PublishModule.scala"), new Caller(this)), default$.MODULE$.UnitWriter(), new EnclosingClass(this.getClass()).value(), (Option<Object>)new Some<Object>(BoxesRunTime.boxToBoolean(false)));
    }

    public Tasks<PublishModule.PublishData> publishAll$default$1() {
        return Tasks$.MODULE$.resolveMainDefault(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"__.publishArtifacts"}));
    }

    public String publishAll$default$2() {
        return "";
    }

    public boolean publishAll$default$3() {
        return true;
    }

    public String publishAll$default$4() {
        return "";
    }

    public boolean publishAll$default$5() {
        return true;
    }

    public String publishAll$default$6() {
        return "https://oss.sonatype.org/service/local";
    }

    public String publishAll$default$7() {
        return "https://oss.sonatype.org/content/repositories/snapshots";
    }

    public int publishAll$default$8() {
        return 1800000;
    }

    public int publishAll$default$9() {
        return 1800000;
    }

    public int publishAll$default$10() {
        return 1800000;
    }

    public boolean publishAll$default$11() {
        return true;
    }

    private Task<Tuple2<String, String>> getSonatypeCredsFromEnv() {
        return Task$.MODULE$.traverseCtx((Seq)Nil$.MODULE$, (Function2<Seq, Ctx, Product> & Serializable)(items$macro$1, ctx$macro$2) -> (Product)Task$.MODULE$.env((Ctx.Env)ctx$macro$2).get(SonatypeHelpers$.MODULE$.USERNAME_ENV_VARIABLE_NAME()).orElse((Function0<Option> & Serializable)() -> Task$.MODULE$.env((Ctx.Env)ctx$macro$2).get("SONATYPE_USERNAME")).flatMap((Function1<String, Option> & Serializable)username -> Task$.MODULE$.env((Ctx.Env)ctx$macro$2).get(SonatypeHelpers$.MODULE$.PASSWORD_ENV_VARIABLE_NAME()).orElse((Function0<Option> & Serializable)() -> Task$.MODULE$.env((Ctx.Env)ctx$macro$2).get("SONATYPE_PASSWORD")).map((Function1<String, Result.Success> & Serializable)password -> new Result.Success<Tuple2<String, String>>(new Tuple2<String, String>((String)username, (String)password)))).getOrElse((Function0<Result.Failure> & Serializable)() -> new Result.Failure<Nothing$>(new StringBuilder(74).append("Consider using ").append(SonatypeHelpers$.MODULE$.USERNAME_ENV_VARIABLE_NAME()).append("/").append(SonatypeHelpers$.MODULE$.PASSWORD_ENV_VARIABLE_NAME()).append(" environment variables or passing `sonatypeCreds` argument").toString(), Result$Failure$.MODULE$.apply$default$2())));
    }

    public Task<String> checkSonatypeCreds(String sonatypeCreds) {
        if (sonatypeCreds.isEmpty()) {
            return this.getSonatypeCredsFromEnv().withFilter((Function1<Tuple2<String, String>, Object>)(Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(PublishModule$.$anonfun$checkSonatypeCreds$1(check$ifrefutable$1))).map((Function1<Tuple2, String> & Serializable)x$35 -> {
                Tuple2 tuple2 = x$35;
                if (tuple2 != null) {
                    String username = (String)tuple2._1();
                    String password = (String)tuple2._2();
                    return new StringBuilder(1).append(username).append(":").append(password).toString();
                }
                throw new MatchError(tuple2);
            });
        }
        return Task$.MODULE$.traverseCtx((Seq)Nil$.MODULE$, (Function2<Seq, Ctx, Result> & Serializable)(items$macro$1, ctx$macro$2) -> {
            if (sonatypeCreds.split(":").length >= 2) {
                return new Result.Success<String>(sonatypeCreds);
            }
            return new Result.Failure<Nothing$>("Sonatype credentials must be set in the following format - username:password. Incorrect format received.", Result$Failure$.MODULE$.apply$default$2());
        });
    }

    private Discover millDiscover$lzycompute() {
        PublishModule$ publishModule$ = this;
        synchronized (publishModule$) {
            if (!bitmap$0) {
                millDiscover = Discover$.MODULE$.apply2((Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(PublishModule$.class), ((Function0<Tuple3> & Serializable)(Function0<Tuple3> & Serializable)() -> new Tuple3<$colon$colon<Nothing$>, $colon$colon<Nothing$>, $colon$colon<Nothing$>>(new $colon$colon<Nothing$>((Nothing$)((Object)"publishAll"), Nil$.MODULE$), new $colon$colon<Nothing$>((Nothing$)((Object)MainData$.MODULE$.create("publishAll", new main(main$.MODULE$.$lessinit$greater$default$1(), main$.MODULE$.$lessinit$greater$default$2()), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ArgSig[]{ArgSig$.MODULE$.create("publishArtifacts", new arg(arg$.MODULE$.$lessinit$greater$default$1(), arg$.MODULE$.$lessinit$greater$default$2(), arg$.MODULE$.$lessinit$greater$default$3(), arg$.MODULE$.$lessinit$greater$default$4(), arg$.MODULE$.$lessinit$greater$default$5(), arg$.MODULE$.$lessinit$greater$default$6()), new Some<Function1<PublishModule$, Tasks> & Serializable>((Function1<PublishModule$, Tasks> & Serializable)fresh$macro$3 -> fresh$macro$3.publishAll$default$1()), package$.MODULE$.millTasksTokenReader()), ArgSig$.MODULE$.create("sonatypeCreds", new arg(arg$.MODULE$.$lessinit$greater$default$1(), arg$.MODULE$.$lessinit$greater$default$2(), arg$.MODULE$.$lessinit$greater$default$3(), arg$.MODULE$.$lessinit$greater$default$4(), arg$.MODULE$.$lessinit$greater$default$5(), arg$.MODULE$.$lessinit$greater$default$6()), new Some<Function1<PublishModule$, String> & Serializable>((Function1<PublishModule$, String> & Serializable)fresh$macro$4 -> fresh$macro$4.publishAll$default$2()), TokensReader$StringRead$.MODULE$), ArgSig$.MODULE$.create("signed", new arg(arg$.MODULE$.$lessinit$greater$default$1(), arg$.MODULE$.$lessinit$greater$default$2(), arg$.MODULE$.$lessinit$greater$default$3(), arg$.MODULE$.$lessinit$greater$default$4(), arg$.MODULE$.$lessinit$greater$default$5(), arg$.MODULE$.$lessinit$greater$default$6()), new Some<Function1<PublishModule$, Object> & Serializable>((Function1<PublishModule$, Object> & Serializable)fresh$macro$5 -> BoxesRunTime.boxToBoolean(((PublishModule$)fresh$macro$5).publishAll$default$3())), TokensReader$BooleanRead$.MODULE$), ArgSig$.MODULE$.create("gpgArgs", new arg(arg$.MODULE$.$lessinit$greater$default$1(), arg$.MODULE$.$lessinit$greater$default$2(), arg$.MODULE$.$lessinit$greater$default$3(), arg$.MODULE$.$lessinit$greater$default$4(), arg$.MODULE$.$lessinit$greater$default$5(), arg$.MODULE$.$lessinit$greater$default$6()), new Some<Function1<PublishModule$, String> & Serializable>((Function1<PublishModule$, String> & Serializable)fresh$macro$6 -> fresh$macro$6.publishAll$default$4()), TokensReader$StringRead$.MODULE$), ArgSig$.MODULE$.create("release", new arg(arg$.MODULE$.$lessinit$greater$default$1(), arg$.MODULE$.$lessinit$greater$default$2(), arg$.MODULE$.$lessinit$greater$default$3(), arg$.MODULE$.$lessinit$greater$default$4(), arg$.MODULE$.$lessinit$greater$default$5(), arg$.MODULE$.$lessinit$greater$default$6()), new Some<Function1<PublishModule$, Object> & Serializable>((Function1<PublishModule$, Object> & Serializable)fresh$macro$7 -> BoxesRunTime.boxToBoolean(((PublishModule$)fresh$macro$7).publishAll$default$5())), TokensReader$BooleanRead$.MODULE$), ArgSig$.MODULE$.create("sonatypeUri", new arg(arg$.MODULE$.$lessinit$greater$default$1(), arg$.MODULE$.$lessinit$greater$default$2(), arg$.MODULE$.$lessinit$greater$default$3(), arg$.MODULE$.$lessinit$greater$default$4(), arg$.MODULE$.$lessinit$greater$default$5(), arg$.MODULE$.$lessinit$greater$default$6()), new Some<Function1<PublishModule$, String> & Serializable>((Function1<PublishModule$, String> & Serializable)fresh$macro$8 -> fresh$macro$8.publishAll$default$6()), TokensReader$StringRead$.MODULE$), ArgSig$.MODULE$.create("sonatypeSnapshotUri", new arg(arg$.MODULE$.$lessinit$greater$default$1(), arg$.MODULE$.$lessinit$greater$default$2(), arg$.MODULE$.$lessinit$greater$default$3(), arg$.MODULE$.$lessinit$greater$default$4(), arg$.MODULE$.$lessinit$greater$default$5(), arg$.MODULE$.$lessinit$greater$default$6()), new Some<Function1<PublishModule$, String> & Serializable>((Function1<PublishModule$, String> & Serializable)fresh$macro$9 -> fresh$macro$9.publishAll$default$7()), TokensReader$StringRead$.MODULE$), ArgSig$.MODULE$.create("readTimeout", new arg(arg$.MODULE$.$lessinit$greater$default$1(), arg$.MODULE$.$lessinit$greater$default$2(), arg$.MODULE$.$lessinit$greater$default$3(), arg$.MODULE$.$lessinit$greater$default$4(), arg$.MODULE$.$lessinit$greater$default$5(), arg$.MODULE$.$lessinit$greater$default$6()), new Some<Function1<PublishModule$, Object> & Serializable>((Function1<PublishModule$, Object> & Serializable)fresh$macro$10 -> BoxesRunTime.boxToInteger(((PublishModule$)fresh$macro$10).publishAll$default$8())), TokensReader$IntRead$.MODULE$), ArgSig$.MODULE$.create("connectTimeout", new arg(arg$.MODULE$.$lessinit$greater$default$1(), arg$.MODULE$.$lessinit$greater$default$2(), arg$.MODULE$.$lessinit$greater$default$3(), arg$.MODULE$.$lessinit$greater$default$4(), arg$.MODULE$.$lessinit$greater$default$5(), arg$.MODULE$.$lessinit$greater$default$6()), new Some<Function1<PublishModule$, Object> & Serializable>((Function1<PublishModule$, Object> & Serializable)fresh$macro$11 -> BoxesRunTime.boxToInteger(((PublishModule$)fresh$macro$11).publishAll$default$9())), TokensReader$IntRead$.MODULE$), ArgSig$.MODULE$.create("awaitTimeout", new arg(arg$.MODULE$.$lessinit$greater$default$1(), arg$.MODULE$.$lessinit$greater$default$2(), arg$.MODULE$.$lessinit$greater$default$3(), arg$.MODULE$.$lessinit$greater$default$4(), arg$.MODULE$.$lessinit$greater$default$5(), arg$.MODULE$.$lessinit$greater$default$6()), new Some<Function1<PublishModule$, Object> & Serializable>((Function1<PublishModule$, Object> & Serializable)fresh$macro$12 -> BoxesRunTime.boxToInteger(((PublishModule$)fresh$macro$12).publishAll$default$10())), TokensReader$IntRead$.MODULE$), ArgSig$.MODULE$.create("stagingRelease", new arg(arg$.MODULE$.$lessinit$greater$default$1(), arg$.MODULE$.$lessinit$greater$default$2(), arg$.MODULE$.$lessinit$greater$default$3(), arg$.MODULE$.$lessinit$greater$default$4(), arg$.MODULE$.$lessinit$greater$default$5(), arg$.MODULE$.$lessinit$greater$default$6()), new Some<Function1<PublishModule$, Object> & Serializable>((Function1<PublishModule$, Object> & Serializable)fresh$macro$13 -> BoxesRunTime.boxToBoolean(((PublishModule$)fresh$macro$13).publishAll$default$11())), TokensReader$BooleanRead$.MODULE$)})), (Function2<PublishModule$, Seq, Command> & Serializable)(fresh$macro$1, argsList$macro$2) -> fresh$macro$1.publishAll((Tasks)argsList$macro$2.apply(false), (String)argsList$macro$2.apply(true), BoxesRunTime.unboxToBoolean(argsList$macro$2.apply(2)), (String)argsList$macro$2.apply(3), BoxesRunTime.unboxToBoolean(argsList$macro$2.apply(4)), (String)argsList$macro$2.apply(5), (String)argsList$macro$2.apply(6), BoxesRunTime.unboxToInt(argsList$macro$2.apply(7)), BoxesRunTime.unboxToInt(argsList$macro$2.apply(8)), BoxesRunTime.unboxToInt(argsList$macro$2.apply(9)), BoxesRunTime.unboxToBoolean(argsList$macro$2.apply(10))))), Nil$.MODULE$), new $colon$colon<Nothing$>((Nothing$)((Object)"publishAll"), Nil$.MODULE$))).apply())})));
                bitmap$0 = true;
            }
        }
        return millDiscover;
    }

    @Override
    public Discover millDiscover() {
        if (!bitmap$0) {
            return this.millDiscover$lzycompute();
        }
        return millDiscover;
    }

    public static final /* synthetic */ boolean $anonfun$checkSonatypeCreds$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private PublishModule$() {
        super(new Enclosing("mill.scalalib.PublishModule"), new Line(584));
    }
}

