/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.Collections;
import java.util.List;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemBuilder;
import org.gradle.api.problems.ProblemBuilderSpec;
import org.gradle.api.problems.ProblemTransformer;
import org.gradle.api.problems.ReportableProblem;
import org.gradle.api.problems.internal.DefaultBuildableProblemBuilder;
import org.gradle.api.problems.internal.DefaultProblemProgressDetails;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.problems.NoOpProblemDiagnosticsFactory;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.problems.buildtree.ProblemStream;

@ServiceScope(value=Scopes.BuildTree.class)
public class DefaultProblems
implements InternalProblems {
    private final BuildOperationProgressEventEmitter buildOperationProgressEventEmitter;
    private final List<ProblemTransformer> transformers;
    private final ProblemStream problemStream;

    public DefaultProblems(BuildOperationProgressEventEmitter buildOperationProgressEventEmitter) {
        this(buildOperationProgressEventEmitter, Collections.emptyList(), NoOpProblemDiagnosticsFactory.EMPTY_STREAM);
    }

    public DefaultProblems(BuildOperationProgressEventEmitter buildOperationProgressEventEmitter, List<ProblemTransformer> transformers, ProblemStream problemStream) {
        this.buildOperationProgressEventEmitter = buildOperationProgressEventEmitter;
        this.transformers = transformers;
        this.problemStream = problemStream;
    }

    @Override
    public DefaultBuildableProblemBuilder createProblemBuilder() {
        return new DefaultBuildableProblemBuilder(this);
    }

    @Override
    public ProblemStream getProblemStream() {
        return this.problemStream;
    }

    @Override
    public RuntimeException throwing(ProblemBuilderSpec action) {
        DefaultBuildableProblemBuilder defaultProblemBuilder = this.createProblemBuilder();
        action.apply(defaultProblemBuilder);
        throw this.throwError(defaultProblemBuilder.getException(), defaultProblemBuilder.build());
    }

    @Override
    public RuntimeException rethrowing(RuntimeException e, ProblemBuilderSpec action) {
        DefaultBuildableProblemBuilder defaultProblemBuilder = this.createProblemBuilder();
        ProblemBuilder problemBuilder = action.apply(defaultProblemBuilder);
        problemBuilder.withException(e);
        throw this.throwError(e, defaultProblemBuilder.build());
    }

    @Override
    public ReportableProblem create(ProblemBuilderSpec action) {
        DefaultBuildableProblemBuilder defaultProblemBuilder = this.createProblemBuilder();
        action.apply(defaultProblemBuilder);
        return defaultProblemBuilder.build();
    }

    public RuntimeException throwError(RuntimeException exception, Problem problem) {
        this.reportAsProgressEvent(problem);
        throw exception;
    }

    @Override
    public void reportAsProgressEvent(Problem problem) {
        for (ProblemTransformer transformer : this.transformers) {
            problem = transformer.transform(problem);
        }
        this.buildOperationProgressEventEmitter.emitNowIfCurrent((Object)new DefaultProblemProgressDetails(problem));
    }
}

