/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import org.me4se.impl.lcdui.FontInfo;

public class Font {
    static Font defaultFont;
    FontInfo info;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int SIZE_SMALL = 8;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_LARGE = 16;
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int FACE_SYSTEM = 0;
    public static final int FONT_STATIC_TEXT = 0;
    public static final int FONT_INPUT_TEXT = 1;
    int face;
    int style;
    int size;

    Font(int face, int style, int size) {
        this.face = face;
        this.style = style;
        this.size = size;
        StringBuffer buf = new StringBuffer();
        boolean awtStyle = false;
        switch (face) {
            case 0: {
                buf.append("system");
                break;
            }
            case 64: {
                buf.append("proportional");
                break;
            }
            case 32: {
                buf.append("monospace");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (this.isBold()) {
            buf.append(".bold");
        }
        if (this.isItalic()) {
            buf.append(".italic");
        }
        if (this.isUnderlined()) {
            buf.append(".underlined");
        }
        if (!(this.isBold() || this.isItalic() || this.isUnderlined())) {
            buf.append(".plain");
        }
        switch (size) {
            case 0: {
                buf.append(".medium");
                break;
            }
            case 8: {
                buf.append(".small");
                break;
            }
            case 16: {
                buf.append(".large");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.info = FontInfo.getFontInfo(buf.toString());
    }

    public int charWidth(char c) {
        return this.info.font.charWidth(c);
    }

    public int charsWidth(char[] c, int ofs, int len) {
        return this.info.font.charsWidth(c, ofs, len);
    }

    public int getBaselinePosition() {
        return this.info.font.ascent;
    }

    public static Font getDefaultFont() {
        if (defaultFont == null) {
            defaultFont = new Font(0, 0, 0);
        }
        return defaultFont;
    }

    public int getFace() {
        return this.face;
    }

    public static Font getFont(int face, int style, int size) {
        return new Font(face, style, size);
    }

    public int getHeight() {
        return this.info.font.height;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isUnderlined() {
        return (this.style & 4) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public int stringWidth(String s) {
        return this.info.font.stringWidth(s);
    }

    public int substringWidth(String s, int ofs, int len) {
        return this.info.font.stringWidth(s.substring(ofs, ofs + len));
    }

    public static Font getFont(int fontSpecifier) {
        switch (fontSpecifier) {
            case 0: 
            case 1: {
                return Font.getFont(0, 0, 0);
            }
        }
        throw new IllegalArgumentException();
    }
}

