/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.ApplicationManager;
import org.kobjects.util.Csv;
import org.me4se.impl.lcdui.FontInfo;
import org.me4se.scm.ScmComponent;
import org.me4se.scm.ScmContainer;

public class ScmDeviceComponent
extends ScmComponent {
    protected FontInfo[] fontInfo;
    public boolean selectButtonRequired;
    String type;
    public Item item;
    public String[] location;

    public ScmDeviceComponent(Item item, String type, boolean focusable) {
        this.item = item;
        this.type = type = type.toLowerCase();
        this.fontInfo = new FontInfo[]{FontInfo.getFontInfo(type), FontInfo.getFontInfo(type + ".focus")};
        this.setFocusable(focusable);
        String props = ApplicationManager.getProperty(type);
        if (props != null) {
            this.location = Csv.decode(props);
            this.setBounds(Integer.parseInt(this.location[0]), Integer.parseInt(this.location[1]), Integer.parseInt(this.location[2]), Integer.parseInt(this.location[3]));
        }
    }

    public void paint(Graphics g) {
        int round;
        super.paint(g);
        int fillX = 0;
        int fillY = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        FontInfo fi = this.getFontInfo();
        int n = round = (fi.decoration & 0x10) != 0 ? 1 : 0;
        if ((fi.decoration & 0x20) != 0) {
            g.setColor(fi.shadow);
            g.drawLine(2 + round, h - 1, w - 1 - round, h - 1);
            g.drawLine(w - 1, 2 + round, w - 1, h - 1 - round);
            g.drawLine(w - 1 - round, h - 1 - round, w - 1 - round, h - 1 - round);
            --w;
            --h;
        }
        int fillW = w;
        int fillH = h;
        if ((fi.decoration & 0xF) != 0) {
            g.setColor(fi.border);
            if ((fi.decoration & 1) != 0) {
                g.drawLine(0, round, 0, h - round - 1);
                ++fillX;
                --fillW;
            }
            if ((fi.decoration & 2) != 0) {
                g.drawLine(w - 1, round, w - 1, h - round - 1);
                --fillW;
            }
            if ((fi.decoration & 4) != 0) {
                g.drawLine(round, 0, w - round - 1, 0);
                ++fillY;
                --fillH;
            }
            if ((fi.decoration & 8) != 0) {
                g.drawLine(round, h - 1, w - round - 1, h - 1);
                --fillH;
            }
        }
        if (fi.background != null && (fi.decoration & 0x40) == 0) {
            g.setColor(fi.background);
            g.fillRect(fillX, fillY, fillW, fillH);
        }
        g.setColor(fi.foreground);
    }

    public boolean keyPressed(String code) {
        ScmComponent c;
        int i0;
        int dir = 0;
        if (code.equals("UP")) {
            dir = -1;
        } else if (code.equals("DOWN")) {
            dir = 1;
        }
        if (dir == 0) {
            return false;
        }
        ScmContainer parent = this.getParent();
        if (parent == null) {
            return false;
        }
        ScmContainer grandParent = parent.getParent();
        if (grandParent == null) {
            return false;
        }
        int count = parent.getComponentCount();
        int i = i0 = parent.indexOf(this);
        boolean cycle = ApplicationManager.getFlag("cycleList");
        do {
            if ((i += dir) < 0) {
                i = cycle ? count - 1 : i0;
            } else if (i >= count) {
                i = cycle ? 0 : i0;
            }
            c = parent.getComponent(i);
        } while (parent.getY() + c.getY() >= 0 && parent.getY() + c.getY() + c.getHeight() <= parent.getParent().getHeight() && !c.getFocusable() && i != i0);
        parent.getComponent(i).requestFocus();
        return true;
    }

    public void focusGained() {
        this.getParent().focusGained();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
    }

    protected FontInfo getFontInfo() {
        return this.fontInfo[this.hasFocus() && this.getFocusable() ? 1 : 0];
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, this.getFontInfo().height);
    }

    public String toString() {
        return "ScmDeviceComponent type " + this.type + " for " + this.item;
    }
}

