/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.scm;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.System;
import org.me4se.impl.Log;
import org.me4se.scm.ScmComponent;
import org.me4se.scm.ScmContainer;

public class ScmWrapper
extends Canvas
implements MouseMotionListener,
MouseListener,
ComponentListener,
KeyListener,
MouseWheelListener,
FocusListener {
    public ScmComponent component;
    boolean invalid;
    int pressedX = -1;
    int pressedY = -1;
    float scale = 1.0f;
    String pressing;
    public int paintCount;
    public BufferedImage offScreenCache;
    Helper helper = new Helper();
    ApplicationManager manager;
    Rectangle clip = new Rectangle();
    boolean keyDown;
    boolean menu;

    public ScmWrapper(ApplicationManager manager) {
        this(manager, 1.0f);
    }

    public ScmWrapper(ApplicationManager manager, float scale) {
        this.scale = scale;
        this.manager = manager;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.addKeyListener(this);
        this.addMouseWheelListener(this);
        this.setFocusTraversalKeysEnabled(false);
        this.addFocusListener(this);
    }

    public void focusGained(FocusEvent e) {
        this.pressing = null;
        Displayable dis = Display.getDisplay(this.manager.active).getCurrent();
        if (dis instanceof javax.microedition.lcdui.Canvas) {
            ((javax.microedition.lcdui.Canvas)dis)._showNotify();
        }
    }

    public void focusLost(FocusEvent e) {
        this.pressing = null;
        Displayable dis = Display.getDisplay(this.manager.active).getCurrent();
        if (dis instanceof javax.microedition.lcdui.Canvas) {
            ((javax.microedition.lcdui.Canvas)dis)._hideNotify();
        }
    }

    public void componentResized(ComponentEvent ev) {
        this.invalid = false;
        Dimension d = this.getSize();
        this.component.setBounds(0, 0, (int)((float)d.width / this.scale), (int)((float)d.height / this.scale));
    }

    public void componentMoved(ComponentEvent ev) {
    }

    public void componentHidden(ComponentEvent ev) {
    }

    public void componentShown(ComponentEvent ev) {
    }

    public void setComponent(ScmComponent component) {
        if (this.component != null) {
            this.helper.remove(this.component);
        }
        if (component.parent != null) {
            throw new RuntimeException("component already assigned");
        }
        this.component = component;
        this.helper.add(component);
        this.repaint();
    }

    public BufferedImage getOffScreen() {
        Dimension size = this.getSize();
        if (size.width <= 0 || size.height <= 0 || size.width > 1000000000 || size.height > 100000000) {
            size = new Dimension(320, 640);
        }
        size.width = (int)((float)size.width / this.scale);
        size.height = (int)((float)size.height / this.scale);
        if (this.offScreenCache == null || this.offScreenCache.getWidth(this) != size.width || this.offScreenCache.getHeight(this) != size.height) {
            this.offScreenCache = new BufferedImage(size.width, size.height, 1);
        }
        return this.offScreenCache;
    }

    public void update(Graphics g) {
        if (this.invalid) {
            this.component.doLayout();
            this.invalid = false;
        }
        Dimension size = this.getSize();
        if (size.width <= 0 || size.height <= 0) {
            return;
        }
        BufferedImage offScreen = this.getOffScreen();
        Graphics2D offScreenGraphics = offScreen.createGraphics();
        offScreenGraphics.scale(1.0f / this.scale, 1.0f / this.scale);
        offScreenGraphics.setClip(g.getClip());
        offScreenGraphics.scale(this.scale, this.scale);
        offScreenGraphics.setColor(Color.black);
        this.helper.paint(offScreenGraphics);
        ++this.paintCount;
        this.paint(g);
    }

    public void paint(Graphics g) {
        Log.log(1, "AWT paint entered: " + g.getClipRect());
        if (this.offScreenCache == null) {
            this.update(g);
        } else {
            g.getClipBounds(this.clip);
            if (!g.drawImage(this.offScreenCache, this.clip.x, this.clip.y, this.clip.x + this.clip.width, this.clip.y + this.clip.height, (int)((float)this.clip.x / this.scale), (int)((float)this.clip.y / this.scale), (int)((float)(this.clip.x + this.clip.width) / this.scale), (int)((float)(this.clip.y + this.clip.height) / this.scale), this)) {
                System.out.println("DRAWIMAGE WAS RETURNING FALSE!!!");
            }
        }
        Log.log(1, "AWT paint left");
    }

    public void mouseDragged(MouseEvent ev) {
        this.component.mouseDragged((int)((float)ev.getX() / this.scale), (int)((float)ev.getY() / this.scale), ev.getModifiers());
    }

    int getMouseButton(InputEvent ev) {
        int modifiers = ev.getModifiers();
        if ((modifiers & 0x10) != 0) {
            return 1;
        }
        if ((modifiers & 8) != 0) {
            return 2;
        }
        if ((modifiers & 4) != 0) {
            return 3;
        }
        return 0;
    }

    public void mouseMoved(MouseEvent ev) {
        this.component.mouseMoved((int)((float)ev.getX() / this.scale), (int)((float)ev.getY() / this.scale), ev.getModifiers());
    }

    public void mousePressed(MouseEvent ev) {
        this.component.mousePressed(this.getMouseButton(ev), (int)((float)ev.getX() / this.scale), (int)((float)ev.getY() / this.scale), ev.getModifiers());
        this.pressedX = ev.getX();
        this.pressedY = ev.getY();
        this.menu = false;
    }

    public void mouseReleased(MouseEvent ev) {
        this.component.mouseReleased(this.getMouseButton(ev), (int)((float)ev.getX() / this.scale), (int)((float)ev.getY() / this.scale), ev.getModifiers());
        int maxdelta = 6;
        if (this.pressedX != -1 && this.pressedY != -1 && Math.abs(this.pressedX - ev.getX()) < maxdelta && (Math.abs(this.pressedX - ev.getX()) > 0 || Math.abs(this.pressedY - ev.getY()) > 0) && Math.abs(this.pressedY - ev.getY()) < maxdelta) {
            this.mouseClicked(ev);
        }
        this.pressedX = -1;
        this.pressedY = -1;
    }

    public void mouseClicked(MouseEvent ev) {
        this.component.mouseClicked(this.getMouseButton(ev), (int)((float)ev.getX() / this.scale), (int)((float)ev.getY() / this.scale), ev.getModifiers(), ev.getClickCount());
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void mouseExited(MouseEvent ev) {
        this.mouseMoved(ev);
    }

    public void keyPressed(KeyEvent ev) {
        String name = this.manager.getButtonName(ev);
        if (name != null) {
            if (name.equals(this.pressing)) {
                this.component.keyRepeated(name);
            } else {
                this.pressing = name;
                this.component.keyPressed(name);
            }
        }
        if (!this.keyDown) {
            this.keyDown = true;
            if (ev.getKeyCode() == 18) {
                this.menu = true;
            }
        }
        if (ev.getKeyCode() != 18) {
            this.menu = false;
        }
    }

    public void keyTyped(KeyEvent ev) {
    }

    public void keyReleased(KeyEvent ev) {
        String name = this.manager.getButtonName(ev);
        if (name == null) {
            name = this.pressing;
        }
        this.pressing = null;
        if (name != null) {
            this.component.keyReleased(name);
        }
        if (this.menu && ev.getKeyCode() == 18) {
            this.component.keyPressed("MENU");
            this.component.keyReleased("MENU");
            ev.consume();
        }
        this.menu = false;
        this.keyDown = false;
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public Dimension getMinimumSize() {
        Dimension d = this.component.getMinimumSize();
        return d;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int a;
        int c = a = e.getWheelRotation();
        if (a < 0) {
            ++c;
            this.component.keyPressed("UP");
        } else {
            --c;
            this.component.keyPressed("DOWN");
        }
        while (c != 0) {
            if (a < 0) {
                ++c;
                this.component.keyRepeated("UP");
                continue;
            }
            --c;
            this.component.keyRepeated("DOWN");
        }
        if (a < 0) {
            this.component.keyReleased("UP");
        } else {
            this.component.keyReleased("DOWN");
        }
    }

    class Helper
    extends ScmContainer {
        Helper() {
        }

        public void repaint(int x, int y, int w, int h) {
            Log.log(1, "sending repaint request to AWT: " + x + "," + y + "," + w + "," + h);
            int x1 = (int)((float)x * ScmWrapper.this.scale);
            int y1 = (int)((float)y * ScmWrapper.this.scale);
            int x2 = (int)Math.ceil((float)(x + w) * ScmWrapper.this.scale);
            int y2 = (int)Math.ceil((float)(y + h) * ScmWrapper.this.scale);
            if (x1 < 0) {
                x1 = 0;
            }
            if (y1 < 0) {
                y1 = 0;
            }
            if (x2 > ScmWrapper.this.getWidth()) {
                x2 = ScmWrapper.this.getWidth();
            }
            if (y2 > ScmWrapper.this.getHeight()) {
                y2 = ScmWrapper.this.getHeight();
            }
            ScmWrapper.this.repaint(x1, y1, x2 - x1, y2 - y1);
            Log.log(1, "repaint request sent to AWT");
        }

        public Graphics getGraphics() {
            Graphics2D g = (Graphics2D)ScmWrapper.this.getOffScreen().getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            return g;
        }

        public void invalidate() {
            if (!ScmWrapper.this.invalid) {
                ScmWrapper.this.invalid = true;
                ScmWrapper.this.repaint(0, 0, ScmWrapper.this.getSize().width, ScmWrapper.this.getSize().height);
            }
        }
    }
}

