/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class DiffUtils {
    private final List<String> stringList = new ArrayList<String>();
    private final Map<String, Integer> stringToId = new HashMap<String, Integer>();
    private int[] original;
    private int[] revised;
    private int[][] lcs;
    private final List<Character> unifiedDiffType = new ArrayList<Character>();
    private final List<Integer> unifiedDiffContentId = new ArrayList<Integer>();
    private final List<String> reducedUnifiedDiff = new ArrayList<String>();
    private int offsetHead = 0;
    private int offsetTail = 0;

    DiffUtils() {
    }

    private List<String> diff(List<String> originalLines, List<String> revisedLines, int contextSize) {
        int i;
        this.reduceEqualLinesFromHeadAndTail(originalLines, revisedLines, contextSize);
        originalLines = originalLines.subList(this.offsetHead, originalLines.size() - this.offsetTail);
        revisedLines = revisedLines.subList(this.offsetHead, revisedLines.size() - this.offsetTail);
        this.original = new int[originalLines.size() + 1];
        this.revised = new int[revisedLines.size() + 1];
        this.lcs = new int[originalLines.size() + 1][revisedLines.size() + 1];
        for (i = 0; i < originalLines.size(); ++i) {
            this.original[i + 1] = this.getIdByLine(originalLines.get(i));
        }
        for (i = 0; i < revisedLines.size(); ++i) {
            this.revised[i + 1] = this.getIdByLine(revisedLines.get(i));
        }
        for (i = 1; i < this.original.length; ++i) {
            for (int j = 1; j < this.revised.length; ++j) {
                this.lcs[i][j] = this.original[i] == this.revised[j] ? this.lcs[i - 1][j - 1] + 1 : Math.max(this.lcs[i][j - 1], this.lcs[i - 1][j]);
            }
        }
        this.calcUnifiedDiff(originalLines.size(), revisedLines.size());
        this.calcReducedUnifiedDiff(contextSize);
        return this.reducedUnifiedDiff;
    }

    private Integer getIdByLine(String line) {
        int newId = this.stringList.size();
        Integer existingId = this.stringToId.put(line, newId);
        if (existingId == null) {
            this.stringList.add(line);
            return newId;
        }
        this.stringToId.put(line, existingId);
        return existingId;
    }

    private void reduceEqualLinesFromHeadAndTail(List<String> original, List<String> revised, int contextSize) {
        int tail;
        int head;
        int maxHead = Math.min(original.size(), revised.size());
        for (head = 0; head < maxHead && original.get(head).equals(revised.get(head)); ++head) {
        }
        this.offsetHead = head = Math.max(head - contextSize, 0);
        int maxTail = Math.min(original.size() - head - contextSize, revised.size() - head - contextSize);
        for (tail = 0; tail < maxTail && original.get(original.size() - 1 - tail).equals(revised.get(revised.size() - 1 - tail)); ++tail) {
        }
        this.offsetTail = tail = Math.max(tail - contextSize, 0);
    }

    private void calcUnifiedDiff(int i, int j) {
        while (i > 0 || j > 0) {
            if (i > 0 && j > 0 && this.original[i] == this.revised[j] && this.lcs[i - 1][j - 1] + 1 > this.lcs[i - 1][j] && this.lcs[i - 1][j - 1] + 1 > this.lcs[i][j - 1]) {
                this.unifiedDiffType.add(Character.valueOf(' '));
                this.unifiedDiffContentId.add(this.original[i]);
                --i;
                --j;
                continue;
            }
            if (j > 0 && (i == 0 || this.lcs[i][j - 1] >= this.lcs[i - 1][j])) {
                this.unifiedDiffType.add(Character.valueOf('+'));
                this.unifiedDiffContentId.add(this.revised[j]);
                --j;
                continue;
            }
            if (i <= 0 || j != 0 && this.lcs[i][j - 1] >= this.lcs[i - 1][j]) continue;
            this.unifiedDiffType.add(Character.valueOf('-'));
            this.unifiedDiffContentId.add(this.original[i]);
            --i;
        }
        Collections.reverse(this.unifiedDiffType);
        Collections.reverse(this.unifiedDiffContentId);
    }

    private void calcReducedUnifiedDiff(int contextSize) {
        int next = 0;
        int lineNumOrigin = this.offsetHead;
        int lineNumRevised = this.offsetHead;
        while (next < this.unifiedDiffType.size()) {
            while (next < this.unifiedDiffType.size() && this.unifiedDiffType.get(next).equals(Character.valueOf(' '))) {
                ++next;
                ++lineNumOrigin;
                ++lineNumRevised;
            }
            if (next == this.unifiedDiffType.size()) break;
            int start = Math.max(0, next - contextSize);
            int startLineOrigin = lineNumOrigin - (next - start - 1);
            int startLineRevised = lineNumRevised - (next - start - 1);
            int equalLines = 0;
            int end = next;
            while (next < this.unifiedDiffType.size() && equalLines < contextSize * 2 + 1) {
                if (this.unifiedDiffType.get(next).equals(Character.valueOf(' '))) {
                    ++equalLines;
                    ++lineNumOrigin;
                    ++lineNumRevised;
                } else {
                    equalLines = 0;
                    end = next;
                    if (this.unifiedDiffType.get(next).equals(Character.valueOf('-'))) {
                        ++lineNumOrigin;
                    } else {
                        ++lineNumRevised;
                    }
                }
                ++next;
            }
            end = Math.min(end + contextSize + 1, this.unifiedDiffType.size());
            int blockSizeOrigin = lineNumOrigin - startLineOrigin - (next - end - 1);
            int blockSizeRevised = lineNumRevised - startLineRevised - (next - end - 1);
            StringBuilder header = new StringBuilder();
            header.append("@@ -").append(startLineOrigin).append(",").append(blockSizeOrigin).append(" +").append(startLineRevised).append(",").append(blockSizeRevised).append(" @@");
            this.reducedUnifiedDiff.add(header.toString());
            for (int i = start; i < end; ++i) {
                String string = String.valueOf(this.unifiedDiffType.get(i));
                String string2 = this.stringList.get(this.unifiedDiffContentId.get(i));
                this.reducedUnifiedDiff.add(new StringBuilder(String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).toString());
            }
        }
    }

    static List<String> generateUnifiedDiff(List<String> original, List<String> revised, int contextSize) {
        return new DiffUtils().diff(original, revised, contextSize);
    }
}

