/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.jstestdriver.URLTranslator;
import java.net.MalformedURLException;
import java.net.URL;

public class DefaultURLTranslator
implements URLTranslator {
    private static final String FORWARD = "/forward";
    private final BiMap<String, String> cache = HashBiMap.create();

    public void translate(String url) throws MalformedURLException {
        URL netUrl = new URL(url);
        String file = netUrl.getFile();
        if (file.length() == 0) {
            file = "/";
        }
        this.cache.put(url, FORWARD + file);
    }

    public String getTranslation(String url) {
        return (String)this.cache.get(url);
    }

    public String getOriginal(String translatedUrl) {
        return (String)this.cache.inverse().get(translatedUrl);
    }

    public void clear() {
        this.cache.clear();
    }
}

