/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.FailureException;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.model.RunData;
import com.google.jstestdriver.output.TestResultHolder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

public class FailureCheckerAction
implements Action {
    private final FailureAccumulator accumulator;
    private final TestResultHolder holder;

    @Inject
    public FailureCheckerAction(FailureAccumulator accumulator, TestResultHolder holder) {
        this.accumulator = accumulator;
        this.holder = holder;
    }

    public RunData run(RunData runData) {
        if (this.accumulator.hasFailures()) {
            throw new FailureException("Tests failed. See log for details.");
        }
        LinkedList<String> failures = Lists.newLinkedList();
        Map<BrowserInfo, Collection<TestResult>> resultsCollections = this.holder.getResults().asMap();
        if (this.holder.getResults().isEmpty()) {
            throw new FailureException("No tests executed.");
        }
        for (Map.Entry<BrowserInfo, Collection<TestResult>> entry : resultsCollections.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            failures.add(entry.getKey() + " had no tests executed.");
        }
        if (!failures.isEmpty()) {
            throw new FailureException(Joiner.on("\n").join(failures));
        }
        return runData;
    }
}

