/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.hooks.TestsPreProcessor;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.model.RunData;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunTestsAction
implements BrowserAction {
    private final List<String> tests;
    private final boolean captureConsole;
    private final Set<TestsPreProcessor> preProcessors;
    private final ResponseStreamFactory responseStreamFactory;

    public RunTestsAction(ResponseStreamFactory responseStreamFactory, List<String> tests, boolean captureConsole, Set<TestsPreProcessor> preProcessors) {
        this.responseStreamFactory = responseStreamFactory;
        this.tests = tests;
        this.captureConsole = captureConsole;
        this.preProcessors = preProcessors;
    }

    @Override
    public ResponseStream run(String id, JsTestDriverClient client, RunData runData, JstdTestCase testCase) {
        List<String> testsToRun = this.tests;
        for (TestsPreProcessor preProcessor : this.preProcessors) {
            testsToRun = preProcessor.process(id, testsToRun.iterator());
        }
        ResponseStream runTestsActionResponseStream = this.responseStreamFactory.getRunTestsActionResponseStream(id);
        if (testsToRun.size() == 1 && testsToRun.get(0).equals("all")) {
            client.runAllTests(id, runTestsActionResponseStream, this.captureConsole, testCase);
        } else if (testsToRun.size() > 0) {
            client.runTests(id, runTestsActionResponseStream, testsToRun, this.captureConsole, testCase);
        }
        return runTestsActionResponseStream;
    }

    public List<String> getTests() {
        return this.tests;
    }

    public boolean isCaptureConsole() {
        return this.captureConsole;
    }
}

