/* goa.h was originally generated by the autoSql program, which also 
 * generated goa.c and goa.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef GOA_H
#define GOA_H

#define GOA_NUM_COLS 15

struct goa
/* GO Association. See http://www.geneontology.org/doc/GO.annotation.html#file */
    {
    struct goa *next;  /* Next in singly linked list. */
    char *db;	/* Database - SPTR for SwissProt */
    char *dbObjectId;	/* Database accession - like 'Q13448' */
    char *dbObjectSymbol;	/* Name - like 'CIA1_HUMAN' */
    char *notId;	/* (Optional) If 'NOT'. Indicates object isn't goId */
    char *goId;	/* GO ID - like 'GO:0015888' */
    char *dbReference;	/* something like SGD:8789|PMID:2676709 */
    char *evidence;	/* Evidence for association.  Somthing like 'IMP' */
    char *withFrom;	/* (Optional) Database support for evidence I think */
    char *aspect;	/*  P (process), F (function) or C (cellular component) */
    char *dbObjectName;	/* (Optional) multi-word name of gene or product */
    char *synonym;	/* (Optional) field for gene symbol, often like IPI00003084 */
    char *dbObjectType;	/* Either gene, transcript, protein, or protein_structure */
    char *taxon;	/* Species (sometimes multiple) in form taxon:9606 */
    char *date;	/* Date annotation made in YYYYMMDD format */
    char *assignedBy;	/* Database that made the annotation. Like 'SPTR' */
    };

void goaStaticLoad(char **row, struct goa *ret);
/* Load a row from goa table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct goa *goaLoad(char **row);
/* Load a goa from row fetched with select * from goa
 * from database.  Dispose of this with goaFree(). */

struct goa *goaLoadAll(char *fileName);
/* Load all goa from whitespace-separated file.
 * Dispose of this with goaFreeList(). */

struct goa *goaLoadAllByChar(char *fileName, char chopper);
/* Load all goa from chopper separated file.
 * Dispose of this with goaFreeList(). */

#define goaLoadAllByTab(a) goaLoadAllByChar(a, '\t');
/* Load all goa from tab separated file.
 * Dispose of this with goaFreeList(). */

struct goa *goaCommaIn(char **pS, struct goa *ret);
/* Create a goa out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new goa */

void goaFree(struct goa **pEl);
/* Free a single dynamically allocated goa such as created
 * with goaLoad(). */

void goaFreeList(struct goa **pList);
/* Free a list of dynamically allocated goa's */

void goaOutput(struct goa *el, FILE *f, char sep, char lastSep);
/* Print out goa.  Separate fields with sep. Follow last field with lastSep. */

#define goaTabOut(el,f) goaOutput(el,f,'\t','\n');
/* Print out goa as a line in a tab-separated file. */

#define goaCommaOut(el,f) goaOutput(el,f,',',',');
/* Print out goa as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* GOA_H */

