/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.xmind.cathy.internal.HandledItemMatcher;
import org.xmind.cathy.internal.WorkbenchMessages;

public class DashboardAutomationAddon {
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    private Selector itemMatcher = new HandledItemMatcher("org.xmind.ui.command.toggleDashboard");

    public void setModelService(EModelService modelService) {
        this.modelService = modelService;
    }

    public void setApplication(MApplication application) {
        this.application = application;
    }

    public void showDashboard(MWindow window) {
        if (this.doShowDashboard(window)) {
            this.updateDashboardToolItems(window);
        }
        DashboardAutomationAddon.hideVisiblePart(window, "org.xmind.ui.stack.right");
    }

    @Inject
    @Optional
    public void updateDashboardVisibilityWhenWindowTagsChanged(@EventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        Object element = event.getProperty("ChangedElement");
        if (!(element instanceof MWindow) || !"org.xmind.cathy.window.main".equals(((MWindow)element).getElementId())) {
            return;
        }
        MWindow window = (MWindow)element;
        if ("ADD".equals(event.getProperty("EventType")) && "CathyShowDashboard".equals(event.getProperty("NewValue"))) {
            if (!this.doShowDashboard(window)) {
                window.getTags().remove("CathyShowDashboard");
                return;
            }
        } else if ("REMOVE".equals(event.getProperty("EventType")) && "CathyShowDashboard".equals(event.getProperty("OldValue")) && !this.doHideDashboard(window)) {
            window.getTags().add("CathyShowDashboard");
            return;
        }
        this.updateDashboardToolItems(window);
    }

    private boolean doShowDashboard(MWindow window) {
        MPart dashboardPart = this.findReferencedDashboardPartIn(window, true);
        if (dashboardPart == null) {
            return false;
        }
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        if (partService == null) {
            return false;
        }
        partService.activate(dashboardPart, true);
        return partService.getActivePart() == dashboardPart;
    }

    private boolean doHideDashboard(MWindow window) {
        MPart dashboardPart = this.findReferencedDashboardPartIn(window, false);
        if (dashboardPart == null) {
            return true;
        }
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        if (partService == null) {
            return false;
        }
        partService.hidePart(dashboardPart);
        return partService.getActivePart() != dashboardPart;
    }

    @Inject
    @Optional
    public void updateWindowTagsWhenDashboardVisibilityChanged(@EventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*") Event event) {
        Object element = event.getProperty("ChangedElement");
        if (!(element instanceof MElementContainer)) {
            return;
        }
        MElementContainer container = (MElementContainer)element;
        MWindow window = this.modelService.getTopLevelWindowFor((MUIElement)container);
        if (window == null || !"org.xmind.cathy.window.main".equals(window.getElementId())) {
            return;
        }
        MPart activePart = this.findSelectedElementIn((MUIElement)window, MPart.class);
        if (activePart != null && "org.xmind.cathy.part.dashboard".equals(activePart.getElementId())) {
            if (!window.getTags().contains("CathyShowDashboard")) {
                window.getTags().add("CathyShowDashboard");
            }
        } else if (window.getTags().contains("CathyShowDashboard")) {
            window.getTags().remove("CathyShowDashboard");
        }
    }

    @Inject
    @Optional
    public void showDashboardWhenAllEditorsAreRemoved(@EventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/children/*") Event event) {
        if (!UIEvents.isREMOVE((Event)event)) {
            return;
        }
        Object element = event.getProperty("ChangedElement");
        if (!(element instanceof MElementContainer)) {
            return;
        }
        boolean partRemoved = false;
        for (Object removed : UIEvents.asIterable((Event)event, (String)"OldValue")) {
            if (!(removed instanceof MPart)) continue;
            partRemoved = true;
            break;
        }
        if (!partRemoved) {
            return;
        }
        MWindow window = this.modelService.getTopLevelWindowFor((MUIElement)element);
        if (window == null || !"org.xmind.cathy.window.main".equals(window.getElementId())) {
            return;
        }
        List editors = this.modelService.findElements((MUIElement)window, null, MPart.class, Arrays.asList("Editor"));
        if (!editors.isEmpty()) {
            return;
        }
        DashboardAutomationAddon.hideVisiblePart(window, "org.xmind.ui.stack.right");
    }

    private MPart findReferencedDashboardPartIn(MWindow window, boolean createIfMissing) {
        MUIElement part;
        MPart dashboardPart = null;
        List dashboardParts = this.modelService.findElements((MUIElement)window, "org.xmind.cathy.part.dashboard", MPart.class, null);
        if (!dashboardParts.isEmpty()) {
            dashboardPart = (MPart)dashboardParts.get(0);
        } else {
            for (MUIElement p : window.getChildren()) {
                if (!(p instanceof MPart) || !"org.xmind.cathy.part.dashboard".equals(p.getElementId())) continue;
                dashboardPart = (MPart)p;
                break;
            }
        }
        if (dashboardPart == null && createIfMissing && (part = this.modelService.cloneSnippet((MSnippetContainer)this.application, "org.xmind.cathy.part.dashboard", window)) != null && part instanceof MPart && "org.xmind.cathy.part.dashboard".equals(part.getElementId())) {
            dashboardPart = (MPart)part;
            window.getChildren().add(dashboardPart);
        }
        return dashboardPart;
    }

    private <T extends MUIElement> T findSelectedElementIn(MUIElement root, Class<T> type) {
        if (type.isInstance(root)) {
            return (T)((MUIElement)type.cast(root));
        }
        if (root instanceof MPlaceholder) {
            return this.findSelectedElementIn(((MPlaceholder)root).getRef(), type);
        }
        if (root instanceof MElementContainer) {
            return this.findSelectedElementIn(((MElementContainer)root).getSelectedElement(), type);
        }
        return null;
    }

    private void updateDashboardToolItems(MWindow window) {
        boolean selected;
        String tooltip;
        if (window.getTags().contains("CathyShowDashboard")) {
            tooltip = WorkbenchMessages.DashboardHideHome_tooltip;
            selected = true;
        } else {
            tooltip = WorkbenchMessages.DashboardShowHome_tooltip;
            selected = false;
        }
        List items = this.modelService.findElements((MApplicationElement)window, MHandledItem.class, 29, this.itemMatcher);
        for (MHandledItem item : items) {
            item.setTooltip(tooltip);
            item.setSelected(selected);
        }
    }

    public static final String hideVisiblePart(MWindow window, String partStackId) {
        if (window == null || partStackId == null) {
            return null;
        }
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        List partStacks = modelService.findElements((MUIElement)window, partStackId, MPartStack.class, null);
        if (partStacks.isEmpty()) {
            return null;
        }
        MPartStack partStack = (MPartStack)partStacks.get(0);
        MStackElement selectedElement = (MStackElement)partStack.getSelectedElement();
        String hidePartId = DashboardAutomationAddon.hidePart(partService, selectedElement);
        if (hidePartId != null) {
            return hidePartId;
        }
        List children = partStack.getChildren();
        for (MStackElement child : children) {
            DashboardAutomationAddon.hidePart(partService, child);
        }
        return null;
    }

    private static String hidePart(EPartService partService, MStackElement element) {
        MPart visiblePart = null;
        if (element instanceof MPlaceholder) {
            MPlaceholder placeholder = (MPlaceholder)element;
            visiblePart = partService.findPart(placeholder.getElementId());
        } else if (element instanceof MPart) {
            visiblePart = (MPart)element;
        }
        if (visiblePart != null) {
            visiblePart.setVisible(false);
            partService.hidePart(visiblePart);
            return visiblePart.getElementId();
        }
        return null;
    }
}

