/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap.filtering;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IContributedContentsView;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.mindmap.filtering.AssigneeFilterSection;
import org.xmind.ui.internal.mindmap.filtering.FilterViewer;
import org.xmind.ui.internal.mindmap.filtering.IFilterViewerContainer;
import org.xmind.ui.internal.mindmap.filtering.LabelFilterSection;
import org.xmind.ui.internal.mindmap.filtering.MarkerFilterSection;
import org.xmind.ui.internal.mindmap.filtering.Messages;

public class AdvancedFilterDialog
extends Dialog
implements IContributedContentsView,
IPartListener,
IPageChangedListener,
IFilterViewerContainer {
    private static final int SHOW_ALL_BUTTON_ID = 1025;
    private String imagePath = "platform:/plugin/org.xmind.ui.mindmap.filtering/icons/advanced_filter.png";
    private IGraphicalEditor contributingPart;
    private Image image;
    private FilterViewer viewer;
    private Button exitFilterButton;

    protected AdvancedFilterDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(3312);
        this.setBlockOnOpen(false);
        VerifyUI20141031.getUsageDataCollector().increase("ShowAdvancedFilterDialogCount");
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.AdvancedFilterDialog_Title);
        URL url = null;
        try {
            url = new URL(this.imagePath);
            this.image = new Image((Device)Display.getDefault(), url.openStream());
            shell.setImage(this.image);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void initializeBounds() {
        this.getShell().setBounds(300, 150, 516, 500);
        super.initializeBounds();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 14;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createDescriptionArea(composite);
        Composite content = new Composite(composite, 2048);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)new GridData(1808));
        this.createViewerPart(content);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)this);
        this.partActivated((IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor());
        return content;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 13;
        layout.marginHeight = 23;
        layout.horizontalSpacing = 18;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    private void createDescriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 18;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label discriptionLabel = new Label(composite, 64);
        GridData discriptionLabelData = new GridData(4, 0x1000000, true, true);
        discriptionLabel.setLayoutData((Object)discriptionLabelData);
        discriptionLabel.setAlignment(16384);
        discriptionLabel.setText(Messages.AdvancedFilterDialog_Discription_Label);
    }

    private void createViewerPart(Composite parent) {
        this.viewer = new FilterViewer(false);
        this.viewer.setContainer(this);
        this.viewer.addSection(new MarkerFilterSection(2));
        this.viewer.addSection(new LabelFilterSection(2));
        this.viewer.addSection(new AssigneeFilterSection(2));
        this.viewer.createControl(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.exitFilterButton = this.createButton(parent, 1025, Messages.ShowAll_text, false);
        this.exitFilterButton.setToolTipText(Messages.ShowAll_toolTip);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (12 == buttonId) {
            this.close();
        } else if (1025 == buttonId) {
            this.viewer.handleShowAll();
        }
    }

    public int open() {
        int openResult = super.open();
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
        return openResult;
    }

    public boolean close() {
        this.viewer.handleShowAll();
        boolean correctClosed = super.close();
        if (correctClosed) {
            if (this.image != null && !this.image.isDisposed()) {
                this.image.dispose();
            }
            this.setContributingPart(null);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener((IPartListener)this);
        }
        return correctClosed;
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IGraphicalEditor) {
            this.setContributingPart((IGraphicalEditor)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.contributingPart) {
            this.setContributingPart(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void pageChanged(PageChangedEvent event) {
        if (this.viewer != null) {
            this.viewer.setContributingViewer(this.getContributingViewer(this.contributingPart));
        }
    }

    public IWorkbenchPart getContributingPart() {
        return this.contributingPart;
    }

    private void setContributingPart(IGraphicalEditor part) {
        if (this.contributingPart != null) {
            this.contributingPart.removePageChangedListener((IPageChangedListener)this);
        }
        this.contributingPart = part;
        if (this.viewer != null) {
            this.viewer.setContributingViewer(this.getContributingViewer(part));
        }
        if (part != null) {
            part.addPageChangedListener((IPageChangedListener)this);
        }
    }

    private IGraphicalViewer getContributingViewer(IGraphicalEditor editor) {
        IGraphicalEditorPage page;
        if (editor != null && (page = editor.getActivePageInstance()) != null) {
            return page.getViewer();
        }
        return null;
    }

    public void updateActions(boolean hasFilters) {
        if (this.exitFilterButton != null && !this.exitFilterButton.isDisposed()) {
            this.exitFilterButton.setEnabled(hasFilters);
        }
    }
}

