/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.service.ZoomingAndPanningRevealService;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITopicPart;

public class MindMapRevealService
extends ZoomingAndPanningRevealService {
    public MindMapRevealService(IGraphicalViewer viewer) {
        super(viewer);
        this.setShouldRevealOnIntersection(false);
    }

    protected boolean exclude(IGraphicalPart part) {
        return part instanceof ISheetPart;
    }

    public void inputChanged(Object oldInput, Object newInput) {
        super.inputChanged(oldInput, newInput);
        this.centerOnCentralTopic();
    }

    public void centerOnCentralTopic() {
        final ITopicPart centralTopic = (ITopicPart)this.getViewer().getAdapter(ITopicPart.class);
        if (centralTopic == null) {
            return;
        }
        ((GraphicalViewer)this.getViewer()).getLightweightSystem().getUpdateManager().runWithUpdate(new Runnable(){

            @Override
            public void run() {
                if (MindMapRevealService.this.getViewer().getFocused() == null) {
                    MindMapRevealService.this.centerOnCentralTopic(centralTopic);
                    FigureCanvas canvas = MindMapRevealService.this.getViewer().getCanvas();
                    canvas.addListener(9, new Listener((Canvas)canvas, centralTopic){
                        private final /* synthetic */ Canvas val$canvas;
                        private final /* synthetic */ ITopicPart val$centralTopic;
                        {
                            this.val$canvas = canvas;
                            this.val$centralTopic = iTopicPart;
                        }

                        public void handleEvent(Event event) {
                            this.val$canvas.removeListener(9, (Listener)this);
                            MindMapRevealService.this.centerOnCentralTopic(this.val$centralTopic);
                        }
                    });
                }
            }
        });
    }

    private void centerOnCentralTopic(ITopicPart centralTopic) {
        boolean selected = this.getViewer().getProperties().getBoolean("selectCentralTopic", Boolean.TRUE.booleanValue());
        if (selected) {
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)centralTopic), false);
            this.getViewer().center(centralTopic.getFigure().getBounds());
        }
    }
}

