/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Point;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;

public class MfCmdOffsetViewportOrg
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_X = 1;
    private static final int POS_Y = 0;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;

    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        Point p = this.getScaledDestination();
        state.setViewportOrg(state.getViewportOrgX() + p.x, state.getViewportOrgY() + p.y);
    }

    public MfCmd getInstance() {
        return new MfCmdOffsetViewportOrg();
    }

    public Point getDestination() {
        return new Point(this.x, this.y);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[OFFSET_VIEWPORT] destination=");
        b.append(this.getDestination());
        return b.toString();
    }

    public void setDestination(int x, int y) {
        this.x = x;
        this.y = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setDestination(Point p) {
        this.setDestination(p.x, p.y);
    }

    public int getFunction() {
        return 529;
    }

    public void setRecord(MfRecord record) {
        int y = record.getParam(0);
        int x = record.getParam(1);
        this.setDestination(x, y);
    }

    public MfRecord getRecord() {
        Point dest = this.getDestination();
        MfRecord record = new MfRecord(2);
        record.setParam(0, dest.y);
        record.setParam(1, dest.x);
        return record;
    }

    public Point getScaledDestination() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }
}

