#ifndef _ISO_88591_20_H_
#define _ISO_88591_20_H_
#include <devfont.h>

#define START_CHARACTER		32
#define SPECIAL_CHARACTER_START	(0x80 - START_CHARACTER)
#define TOTAL_CHARACTER_NUM 256
#define SPECIAL_CHARACTER_NUM        160

static const FONTINDEX ISO_88591_20_font_map[TOTAL_CHARACTER_NUM] = {
{0x20,2,0x0},
{0x21,5,0x3},
{0x22,5,0x10},
{0x23,12,0x1d},
{0x24,11,0x3c},
{0x25,15,0x58},
{0x26,11,0x7e},
{0x27,5,0x9a},
{0x28,5,0xa7},
{0x29,5,0xb4},
{0x2a,6,0xc1},
{0x2b,8,0xd1},
{0x2c,5,0xe6},
{0x2d,6,0xf3},
{0x2e,5,0x103},
{0x2f,5,0x110},
{0x30,10,0x11d},
{0x31,10,0x137},
{0x32,10,0x151},
{0x33,10,0x16b},
{0x34,10,0x185},
{0x35,10,0x19f},
{0x36,10,0x1b9},
{0x37,10,0x1d3},
{0x38,10,0x1ed},
{0x39,10,0x207},
{0x3a,5,0x221},
{0x3b,5,0x22e},
{0x3c,7,0x23b},
{0x3d,8,0x24d},
{0x3e,7,0x262},
{0x3f,9,0x274},
{0x40,17,0x28b},
{0x41,13,0x2b6},
{0x42,10,0x2d7},
{0x43,10,0x2f1},
{0x44,10,0x30b},
{0x45,8,0x325},
{0x46,8,0x33a},
{0x47,10,0x34f},
{0x48,10,0x369},
{0x49,5,0x383},
{0x4a,8,0x390},
{0x4b,10,0x3a5},
{0x4c,8,0x3bf},
{0x4d,13,0x3d4},
{0x4e,10,0x3f5},
{0x4f,11,0x40f},
{0x50,10,0x42b},
{0x51,12,0x445},
{0x52,10,0x464},
{0x53,10,0x47e},
{0x54,10,0x498},
{0x55,11,0x4b2},
{0x56,10,0x4ce},
{0x57,16,0x4e8},
{0x58,11,0x511},
{0x59,10,0x52d},
{0x5a,9,0x547},
{0x5b,5,0x55e},
{0x5c,5,0x56b},
{0x5d,5,0x578},
{0x5e,11,0x585},
{0x5f,10,0x5a1},
{0x60,5,0x5bb},
{0x61,10,0x5c8},
{0x62,10,0x5e2},
{0x63,9,0x5fc},
{0x64,10,0x613},
{0x65,9,0x62d},
{0x66,6,0x644},
{0x67,9,0x654},
{0x68,9,0x66b},
{0x69,5,0x682},
{0x6a,5,0x68f},
{0x6b,10,0x69c},
{0x6c,5,0x6b6},
{0x6d,16,0x6c3},
{0x6e,9,0x6ec},
{0x6f,10,0x703},
{0x70,10,0x71d},
{0x71,10,0x737},
{0x72,9,0x751},
{0x73,10,0x768},
{0x74,8,0x782},
{0x75,9,0x797},
{0x76,11,0x7ae},
{0x77,16,0x7ca},
{0x78,9,0x7f3},
{0x79,10,0x80a},
{0x7a,7,0x824},
{0x7b,6,0x836},
{0x7c,5,0x846},
{0x7d,6,0x853},
{0x7e,11,0x863},
{0x7f,0,0x87f},
{0x0,0,0x0},
{0xa8bb,11,0xa86},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8a2,8,0x897},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8b3,8,0x9d1},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8ab,5,0x941},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8bc,7,0xaa2},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8a3,8,0x8ac},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8b4,8,0x9e6},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8ac,5,0x94e},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8bd,9,0xab4},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8a4,8,0x8c1},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8b5,11,0x9fb},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8ad,8,0x95b},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8be,8,0xacb},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8a5,8,0x8d6},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8b6,9,0xa17},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8ae,8,0x970},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8bf,9,0xae0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8a6,8,0x8eb},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8b7,7,0xa2e},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8af,8,0x985},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8c0,8,0xaf7},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8a7,7,0x900},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8b8,11,0xa40},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8b0,5,0x99a},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8a8,8,0x912},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8b9,8,0xa5c},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8b1,8,0x9a7},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8a9,5,0x927},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8ba,8,0xa71},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8a1,8,0x882},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8b2,8,0x9bc},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0x0,0,0x0},
{0xa8aa,5,0x934},
{0x0,0,0x0}
};

static unsigned char ISO_88591_20_osdfont_dat[] = {
//0x020 -- 0x20      0x20
0x0,0x0,0x0,
//0x021 -- 0x21  !   5x20
0x0,0x0,0x6,0x31,0x8c,0x63,0x18,0xc6,0x30,0xc,0x60,0x0,0x0,
//0x022 -- 0x22  "   5x20
0x0,0x0,0xf,0xef,0x7b,0xd8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
//0x023 -- 0x23  #   12x20
0x0,0x0,0x0,0x0,0x0,0x0,0xc,0xc0,0xcc,0xc,0xc0,0xcc,0x7f,0xf7,0xff,0x19,0x81,0x98,0xff,0xef,0xfe,0x33,0x3,0x30,0x33,0x0,0x0,0x0,0x0,0x0,0x0,
//0x024 -- 0x24  $   11x20
0x0,0x0,0x0,0x18,0x3,0x1,0xf8,0xff,0x1d,0x86,0x30,0xc6,0x1c,0xc1,0xff,0x3f,0xe0,0xce,0x18,0xc3,0x73,0xfe,0x7f,0x1,0x80,0x30,0x0,0x0,
//0x025 -- 0x25  %   15x20
0x0,0x0,0x0,0x0,0x0,0x1,0x81,0x87,0x87,0x19,0x8c,0x33,0x38,0x66,0x60,0x79,0xc0,0x63,0x0,0xe,0x60,0x19,0xe0,0x76,0x60,0xcc,0xc3,0x99,0x86,0x1e,0xc,0x18,0x0,0x0,0x0,0x0,0x0,0x0,
//0x026 -- 0x26  &   11x20
0x0,0x0,0x0,0x0,0x7,0x1,0xf0,0x66,0xc,0xc1,0x98,0x1e,0x7,0xc1,0xd8,0x71,0x8c,0x37,0x83,0xf0,0x77,0xff,0x7f,0x60,0x0,0x0,0x0,0x0,
//0x027 -- 0x27  '   5x20
0x0,0x0,0x6,0x31,0x8c,0x60,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
//0x028 -- 0x28  (   5x20
0x0,0x0,0x3,0xbd,0x98,0xc6,0x31,0x8c,0x61,0x8f,0x38,0x0,0x0,
//0x029 -- 0x29  )   5x20
0x0,0x0,0xe,0x78,0xc3,0x18,0xc6,0x31,0x8c,0xde,0xe0,0x0,0x0,
//0x02a -- 0x2a  *   6x20
0x0,0x0,0x0,0xcf,0x33,0x3f,0xfc,0xcc,0xf3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
//0x02b -- 0x2b  +   8x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x18,0x18,0xff,0xff,0x18,0x18,0x18,0x0,0x0,0x0,0x0,0x0,
//0x02c -- 0x2c  ,   5x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0x61,0x10,0x0,
//0x02d -- 0x2d  -   6x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f,0xfc,0x0,0x0,0x0,0x0,0x0,0x0,
//0x02e -- 0x2e  .   5x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0x60,0x0,0x0,
//0x02f -- 0x2f  /   5x20
0x0,0x0,0x1,0x8c,0x67,0x31,0x9c,0xc6,0x73,0x18,0xc0,0x0,0x0,
//0x030 -- 0x30  0   10x20
0x0,0x0,0x0,0x0,0x0,0x1c,0x1f,0xc6,0x33,0x6,0xc1,0xb0,0x6c,0x1b,0x6,0xc1,0xb0,0x66,0x31,0xfc,0x1c,0x0,0x0,0x0,0x0,0x0,
//0x031 -- 0x31  1   10x20
0x0,0x0,0x0,0x0,0x0,0x7,0x1,0xc0,0xf1,0xfc,0x73,0x0,0xc0,0x30,0xc,0x3,0x0,0xc0,0x30,0xc,0x3,0x0,0x0,0x0,0x0,0x0,
//0x032 -- 0x32  2   10x20
0x0,0x0,0x0,0x0,0x0,0x1c,0x1f,0xc6,0x33,0x6,0xc1,0x80,0xe0,0xf0,0xf0,0x70,0x38,0xc,0x3,0xfe,0xff,0x80,0x0,0x0,0x0,0x0,
//0x033 -- 0x33  3   10x20
0x0,0x0,0x0,0x0,0x0,0xfc,0x3f,0xc0,0x30,0x6,0x3,0x81,0xc7,0xe1,0xfc,0x3,0x80,0x60,0x33,0xfc,0xfc,0x0,0x0,0x0,0x0,0x0,
//0x034 -- 0x34  4   10x20
0x0,0x0,0x0,0x0,0x0,0xf,0x3,0xc1,0xb0,0x6c,0x33,0xc,0xc3,0x31,0x8c,0x63,0x3f,0xef,0xf8,0xc,0x3,0x0,0x0,0x0,0x0,0x0,
//0x035 -- 0x35  5   10x20
0x0,0x0,0x0,0x0,0x0,0xff,0x3f,0xcc,0x3,0x0,0xfc,0x3f,0xc0,0x30,0x6,0xc1,0xb0,0x66,0x31,0xfc,0x1c,0x0,0x0,0x0,0x0,0x0,
//0x036 -- 0x36  6   10x20
0x0,0x0,0x0,0x0,0x0,0x1f,0x1f,0xc6,0x3,0x0,0xc0,0x37,0xf,0xf3,0x8c,0xc1,0xb0,0x66,0x31,0xfc,0x1c,0x0,0x0,0x0,0x0,0x0,
//0x037 -- 0x37  7   10x20
0x0,0x0,0x0,0x0,0x0,0xff,0xbf,0xe0,0x18,0x6,0x3,0x0,0xc0,0x60,0x18,0xc,0x6,0x1,0x80,0xc0,0x30,0x0,0x0,0x0,0x0,0x0,
//0x038 -- 0x38  8   10x20
0x0,0x0,0x0,0x0,0x0,0x1c,0x1f,0xc6,0x33,0x6,0xc1,0xb8,0xe7,0xf3,0xde,0xc1,0xb0,0x66,0x31,0xfc,0x1c,0x0,0x0,0x0,0x0,0x0,
//0x039 -- 0x39  9   10x20
0x0,0x0,0x0,0x0,0x0,0x1c,0x1f,0xc6,0x33,0x6,0xc1,0xb8,0xe7,0xf8,0x76,0x1,0x80,0x60,0x31,0xfc,0x7c,0x0,0x0,0x0,0x0,0x0,
//0x03a -- 0x3a  :   5x20
0x0,0x0,0x0,0x0,0x0,0x63,0x0,0x6,0x30,0x0,0x0,0x0,0x0,
//0x03b -- 0x3b  ;   5x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x31,0x80,0x61,0x4,0x0,
//0x03c -- 0x3c  <   7x20
0x0,0x0,0x0,0x0,0x20,0xc3,0x8e,0x38,0xe3,0x83,0x83,0x83,0x83,0x83,0x2,0x0,0x0,0x0,
//0x03d -- 0x3d  =   8x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff,0xff,0x0,0x0,0xff,0xff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
//0x03e -- 0x3e  >   7x20
0x0,0x0,0x0,0x8,0x18,0x38,0x38,0x38,0x38,0x38,0xe3,0x8e,0x38,0x60,0x80,0x0,0x0,0x0,
//0x03f -- 0x3f  ?   9x20
0x0,0x0,0x0,0x0,0x1,0xc3,0xfb,0x8f,0x83,0x1,0x81,0xc3,0xc3,0x81,0x80,0xc0,0x0,0x0,0x18,0xc,0x0,0x0,0x0,
//0x040 -- 0x40  @   17x20
0x0,0x0,0x0,0x0,0x0,0xfc,0x1,0xff,0x81,0xe1,0xe1,0xc0,0x39,0xc0,0xc,0xc7,0xa6,0xe7,0xf1,0xe7,0x38,0xf3,0xc,0xd9,0xce,0xec,0x7f,0xe7,0x1e,0xe1,0x80,0x0,0xe0,0x1c,0x3c,0x3c,0xf,0xfc,0x1,0xf8,0x0,0x0,0x0,
//0x041 -- 0x41  A   13x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x3,0x80,0x1c,0x1,0xf0,0xd,0x80,0xee,0x6,0x30,0x71,0xc3,0x6,0x3f,0xf9,0xff,0xdc,0x7,0xc0,0x18,0x0,0x0,0x0,0x0,0x0,
//0x042 -- 0x42  B   10x20
0x0,0x0,0x0,0x0,0x0,0xfc,0x3f,0xcc,0x33,0x6,0xc1,0xb0,0xef,0xf3,0xfe,0xc0,0xf0,0x3c,0x1b,0xfe,0xfe,0x0,0x0,0x0,0x0,0x0,
//0x043 -- 0x43  C   10x20
0x0,0x0,0x0,0x0,0x0,0x1f,0xdf,0xf7,0x3,0x0,0xc0,0x30,0xc,0x3,0x0,0xc0,0x30,0x7,0x1,0xff,0x1f,0xc0,0x0,0x0,0x0,0x0,
//0x044 -- 0x44  D   10x20
0x0,0x0,0x0,0x0,0x0,0xfe,0x3f,0xec,0x3b,0x3,0xc0,0xf0,0x3c,0xf,0x3,0xc0,0xf0,0x3c,0x3b,0xfe,0xfe,0x0,0x0,0x0,0x0,0x0,
//0x045 -- 0x45  E   8x20
0x0,0x0,0x0,0x0,0xff,0xff,0xc0,0xc0,0xc0,0xfc,0xfc,0xc0,0xc0,0xc0,0xc0,0xff,0xff,0x0,0x0,0x0,0x0,
//0x046 -- 0x46  F   8x20
0x0,0x0,0x0,0x0,0xff,0xff,0xc0,0xc0,0xc0,0xfc,0xfc,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0x0,0x0,0x0,0x0,
//0x047 -- 0x47  G   10x20
0x0,0x0,0x0,0x0,0x0,0x1f,0x9f,0xe6,0x3,0x0,0xc0,0x30,0xc,0x3,0x1f,0xc7,0xf0,0x36,0x19,0xfe,0x1e,0x0,0x0,0x0,0x0,0x0,
//0x048 -- 0x48  H   10x20
0x0,0x0,0x0,0x0,0x0,0xc0,0xf0,0x3c,0xf,0x3,0xc0,0xff,0xff,0xff,0x3,0xc0,0xf0,0x3c,0xf,0x3,0xc0,0xc0,0x0,0x0,0x0,0x0,
//0x049 -- 0x49  I   5x20
0x0,0x0,0x6,0x31,0x8c,0x63,0x18,0xc6,0x31,0x8c,0x60,0x0,0x0,
//0x04a -- 0x4a  J   8x20
0x0,0x0,0x0,0x0,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0xfe,0xf8,0x0,0x0,0x0,0x0,
//0x04b -- 0x4b  K   10x20
0x0,0x0,0x0,0x0,0x0,0xc1,0x30,0xec,0x73,0x38,0xdc,0x3e,0xf,0x83,0x70,0xce,0x31,0xcc,0x3b,0x7,0xc0,0xc0,0x0,0x0,0x0,0x0,
//0x04c -- 0x4c  L   8x20
0x0,0x0,0x0,0x0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xff,0xff,0x0,0x0,0x0,0x0,
//0x04d -- 0x4d  M   13x20
0x0,0x0,0x0,0x0,0x0,0x0,0xc,0x1,0xe0,0xf,0x80,0xfc,0x7,0xf0,0x7f,0x83,0xf6,0x37,0xbb,0xbc,0xd9,0xe7,0xcf,0x1c,0x78,0xe3,0xc2,0x18,0x0,0x0,0x0,0x0,0x0,
//0x04e -- 0x4e  N   10x20
0x0,0x0,0x0,0x0,0x0,0x80,0xf0,0x3e,0xf,0xc3,0xf8,0xf7,0x3c,0xef,0x1f,0xc3,0xf0,0x7c,0xf,0x3,0xc0,0xc0,0x0,0x0,0x0,0x0,
//0x04f -- 0x4f  O   11x20
0x0,0x0,0x0,0x0,0x0,0x1,0xf0,0xff,0x98,0x36,0x3,0xc0,0x78,0xf,0x1,0xe0,0x3c,0x7,0x80,0xd8,0x33,0xfe,0x1f,0x0,0x0,0x0,0x0,0x0,
//0x050 -- 0x50  P   10x20
0x0,0x0,0x0,0x0,0x0,0xfe,0x3f,0xec,0x3b,0x3,0xc0,0xf0,0x3c,0x3b,0xfe,0xfe,0x30,0xc,0x3,0x0,0xc0,0x0,0x0,0x0,0x0,0x0,
//0x051 -- 0x51  Q   12x20
0x0,0x0,0x0,0x0,0x0,0x0,0x1f,0x7,0xfc,0x60,0xce,0xe,0xc0,0x6c,0x6,0xc0,0x6c,0xe,0xc1,0xee,0x1e,0x60,0xc7,0xff,0x1f,0x30,0x0,0x0,0x0,0x0,0x0,
//0x052 -- 0x52  R   10x20
0x0,0x0,0x0,0x0,0x0,0xfe,0x3f,0xec,0x3b,0x3,0xc0,0xf0,0x3c,0x3b,0xfe,0xfe,0x31,0xcc,0x3b,0x7,0xc0,0xc0,0x0,0x0,0x0,0x0,
//0x053 -- 0x53  S   10x20
0x0,0x0,0x0,0x0,0x0,0x1f,0x9f,0xe7,0x3,0x0,0xc0,0x1f,0xe7,0xf8,0x7,0x0,0xc0,0x30,0x3b,0xfe,0xfe,0x0,0x0,0x0,0x0,0x0,
//0x054 -- 0x54  T   10x20
0x0,0x0,0x0,0x0,0x0,0xff,0xff,0xf0,0xc0,0x30,0xc,0x3,0x0,0xc0,0x30,0xc,0x3,0x0,0xc0,0x30,0xc,0x0,0x0,0x0,0x0,0x0,
//0x055 -- 0x55  U   11x20
0x0,0x0,0x0,0x0,0x0,0xc,0x7,0x80,0xf0,0x1e,0x3,0xc0,0x78,0xf,0x1,0xe0,0x3c,0x7,0xc1,0xd8,0x33,0xfe,0x1f,0x0,0x0,0x0,0x0,0x0,
//0x056 -- 0x56  V   10x20
0x0,0x0,0x0,0x0,0x0,0xc0,0xf0,0x3c,0xf,0x87,0x61,0x98,0x67,0x39,0xce,0x33,0xf,0xc3,0xf0,0x30,0xc,0x0,0x0,0x0,0x0,0x0,
//0x057 -- 0x57  W   16x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0,0x3,0xc0,0x3,0xc0,0x3,0xe1,0x87,0x61,0x86,0x61,0x86,0x73,0xce,0x73,0xce,0x33,0xcc,0x3f,0xfc,0x3f,0xfc,0xc,0x30,0xc,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
//0x058 -- 0x58  X   11x20
0x0,0x0,0x0,0x0,0x0,0x8,0x3,0x80,0xf8,0x3b,0x8e,0x3b,0x83,0xe0,0x38,0xf,0x83,0xb8,0xe3,0xb8,0x3e,0x3,0x80,0x20,0x0,0x0,0x0,0x0,
//0x059 -- 0x59  Y   10x20
0x0,0x0,0x0,0x0,0x0,0xc0,0xf0,0x3e,0x1d,0x86,0x73,0x8c,0xc3,0xf0,0x78,0xc,0x3,0x0,0xc0,0x30,0xc,0x0,0x0,0x0,0x0,0x0,
//0x05a -- 0x5a  Z   9x20
0x0,0x0,0x0,0x0,0xf,0xff,0xfc,0x6,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x1,0xff,0xff,0x80,0x0,0x0,0x0,
//0x05b -- 0x5b  [   5x20
0x0,0x0,0xf,0x7b,0x18,0xc6,0x31,0x8c,0x63,0x1e,0xf0,0x0,0x0,
//0x05c -- 0x5c  \   5x20
0x0,0x0,0xc,0x63,0x1c,0x63,0x1c,0x63,0x1c,0x63,0x18,0x0,0x0,
//0x05d -- 0x5d  ]   5x20
0x0,0x0,0xf,0x78,0xc6,0x31,0x8c,0x63,0x18,0xde,0xf0,0x0,0x0,
//0x05e -- 0x5e  ^   11x20
0x0,0x0,0x0,0x38,0xf,0x83,0xb8,0xe3,0xb8,0x38,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
//0x05f -- 0x5f  _   10x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0xff,0xff,0x0,
//0x060 -- 0x60  `   5x20
0x0,0x38,0xe3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
//0x061 -- 0x61  a   10x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0xf1,0xfe,0xe1,0xc0,0x33,0xfd,0xff,0xe0,0xf0,0x3e,0x1d,0xff,0x3e,0xc0,0x0,0x0,0x0,0x0,
//0x062 -- 0x62  b   10x20
0x0,0x0,0x0,0x0,0x0,0xc0,0x30,0xd,0xf3,0xfe,0xe1,0xf0,0x3c,0xf,0x3,0xc0,0xf0,0x3e,0x1f,0xfe,0xdf,0x0,0x0,0x0,0x0,0x0,
//0x063 -- 0x63  c   9x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8,0xfe,0xe3,0xe0,0x30,0x18,0xc,0x6,0xf,0x8e,0xfe,0x3e,0x0,0x0,0x0,0x0,
//0x064 -- 0x64  d   10x20
0x0,0x0,0x0,0x0,0x0,0x0,0xc0,0x33,0xed,0xff,0xe1,0xf0,0x3c,0xf,0x3,0xc0,0xf0,0x3e,0x1d,0xff,0x3e,0xc0,0x0,0x0,0x0,0x0,
//0x065 -- 0x65  e   9x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf8,0xfe,0xe3,0xe0,0xff,0xdf,0xcc,0x6,0xf,0x8e,0xfe,0x3e,0x0,0x0,0x0,0x0,
//0x066 -- 0x66  f   6x20
0x0,0x0,0x0,0x1c,0xf7,0x18,0xfb,0xe6,0x18,0x61,0x86,0x18,0x60,0x0,0x0,0x0,
//0x067 -- 0x67  g   9x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf6,0xff,0xe3,0xe0,0xf0,0x78,0x3c,0x1e,0xf,0x8e,0xff,0x3d,0x80,0xff,0xcf,0xc0,
//0x068 -- 0x68  h   9x20
0x0,0x0,0x0,0x18,0xc,0x6,0x3,0x79,0xfe,0xe3,0xe0,0xf0,0x78,0x3c,0x1e,0xf,0x7,0x83,0xc1,0x80,0x0,0x0,0x0,
//0x069 -- 0x69  i   5x20
0x0,0x0,0xc6,0x0,0xc,0x63,0x18,0xc6,0x31,0x8c,0x60,0x0,0x0,
//0x06a -- 0x6a  j   5x20
0x0,0x0,0x31,0x80,0x3,0x18,0xc6,0x31,0x8c,0x63,0x19,0xfd,0xc0,
//0x06b -- 0x6b  k   10x20
0x0,0x0,0x0,0x3,0x0,0xc0,0x30,0xc,0x3b,0x1c,0xce,0x37,0xf,0x83,0xe0,0xdc,0x33,0x8c,0x73,0xe,0xc1,0xc0,0x0,0x0,0x0,0x0,
//0x06c -- 0x6c  l   5x20
0x0,0x0,0xc6,0x31,0x8c,0x63,0x18,0xc6,0x31,0x8c,0x60,0x0,0x0,
//0x06d -- 0x6d  m   16x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xce,0x1c,0xdf,0x3e,0xf3,0xe7,0xe1,0xc3,0xc1,0x83,0xc1,0x83,0xc1,0x83,0xc1,0x83,0xc1,0x83,0xc1,0x83,0xc1,0x83,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
//0x06e -- 0x6e  n   9x20
0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x39,0xbe,0xf3,0xf0,0xf0,0x78,0x3c,0x1e,0xf,0x7,0x83,0xc1,0x80,0x0,0x0,0x0,
//0x06f -- 0x6f  o   10x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0xf1,0xfe,0xe1,0xf0,0x3c,0xf,0x3,0xc0,0xf0,0x3e,0x1d,0xfe,0x3f,0x0,0x0,0x0,0x0,0x0,
//0x070 -- 0x70  p   10x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd,0xf3,0xfe,0xe1,0xf0,0x3c,0xf,0x3,0xc0,0xf0,0x3e,0x1f,0xfe,0xdf,0x30,0xc,0x3,0x0,0x0,
//0x071 -- 0x71  q   10x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0xed,0xff,0xe1,0xf0,0x3c,0xf,0x3,0xc0,0xf0,0x3e,0x1d,0xff,0x3e,0xc0,0x30,0xc,0x3,0x0,
//0x072 -- 0x72  r   9x20
0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x39,0xbe,0xf3,0xf0,0xf0,0x18,0xc,0x6,0x3,0x1,0x80,0xc0,0x0,0x0,0x0,0x0,
//0x073 -- 0x73  s   10x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0xf1,0xfe,0xe1,0xf0,0x3e,0x0,0xf8,0xf,0xf0,0x3e,0x1d,0xfe,0x3f,0x0,0x0,0x0,0x0,0x0,
//0x074 -- 0x74  t   8x20
0x0,0x0,0x0,0x0,0x60,0x60,0xfc,0xfc,0x60,0x60,0x60,0x60,0x60,0x63,0x77,0x3e,0x1c,0x0,0x0,0x0,0x0,
//0x075 -- 0x75  u   9x20
0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x7,0x83,0xc1,0xe0,0xf0,0x78,0x3c,0x1e,0x1f,0x8e,0xff,0x3d,0x80,0x0,0x0,0x0,
//0x076 -- 0x76  v   11x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30,0x1f,0x7,0x60,0xce,0x38,0xc6,0x1d,0xc1,0xb0,0x3e,0x3,0x80,0x70,0x4,0x0,0x0,0x0,0x0,0x0,
//0x077 -- 0x77  w   16x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0,0x3,0xe1,0x87,0x61,0x86,0x71,0x8e,0x31,0x8c,0x3b,0xdc,0x1b,0xd8,0x1f,0xf8,0xe,0x70,0xe,0x70,0x4,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
//0x078 -- 0x78  x   9x20
0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x3,0x83,0xe3,0xbb,0x8f,0x83,0x83,0xe3,0xbb,0x8f,0x83,0x80,0x80,0x0,0x0,0x0,
//0x079 -- 0x79  y   10x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe,0xd,0x83,0x61,0xdc,0x63,0x18,0xee,0x1b,0x7,0xc0,0xf0,0x38,0x6,0x3,0x8f,0xe1,0xf0,0x0,
//0x07a -- 0x7a  z   7x20
0x0,0x0,0x0,0x0,0x0,0x3f,0xff,0x6,0xc,0x30,0xc3,0xc,0x30,0x7f,0xfe,0x0,0x0,0x0,
//0x07b -- 0x7b  {   6x20
0x0,0x0,0x1,0xc,0x61,0x86,0x18,0x63,0xb8,0x38,0x61,0x86,0x18,0x60,0xc1,0x0,
//0x07c -- 0x7c  |   5x20
0x0,0x0,0xc6,0x31,0x8c,0x63,0x18,0xc6,0x31,0x8c,0x63,0x18,0x0,
//0x07d -- 0x7d  }   6x20
0x0,0x0,0x20,0xc1,0x86,0x18,0x61,0x87,0x7,0x71,0x86,0x18,0x61,0x8c,0x20,0x0,
//0x07e -- 0x7e  ~   11x20
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0,0x3f,0x3c,0xfc,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
//0x07f -- 0x7f     0x20
0x0,0x0,0x0,
//0x0a8 -- 0xa8a1    8x20
0x0,0x0,0x0,0x0,0x6c,0x0,0x0,0x3c,0x46,0x6,0x6,0x3e,0x66,0xc6,0xc6,0x7b,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8a2  ?  8x20
0x0,0x0,0xc,0x18,0x30,0x0,0x0,0x3c,0x46,0x6,0x6,0x3e,0x66,0xc6,0xc6,0x7b,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8a3  ?  8x20
0x0,0x0,0x38,0x28,0x44,0x0,0x0,0x3c,0x46,0x6,0x6,0x3e,0x66,0xc6,0xc6,0x7b,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8a4  ?  8x20
0x0,0x0,0x30,0x18,0xc,0x0,0x0,0x3c,0x46,0x6,0x6,0x3e,0x66,0xc6,0xc6,0x7b,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8a5  ?  8x20
0x0,0x0,0x0,0x0,0x6c,0x0,0x0,0x3c,0x66,0xc3,0xc3,0xff,0xc0,0xc0,0x60,0x3f,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8a6  ?  8x20
0x0,0x0,0x6,0xc,0x18,0x0,0x0,0x3c,0x66,0xc3,0xc3,0xff,0xc0,0xc0,0x60,0x3f,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8a7  ?  7x20
0x0,0x1,0xb0,0xf,0xf8,0x30,0x60,0xc1,0xfb,0x6,0xc,0x18,0x30,0x7f,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8a8  ?  8x20
0x0,0x0,0x60,0x30,0x18,0x0,0x0,0x3c,0x66,0xc3,0xc3,0xff,0xc0,0xc0,0x60,0x3f,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8a9  ?  5x20
0x0,0x0,0xd,0x80,0xc,0x63,0x18,0xc6,0x31,0x8c,0x0,0x0,0x0,
//0x0a8 -- 0xa8aa  ?  5x20
0x0,0xc,0xcc,0x0,0x18,0xc6,0x31,0x8c,0x63,0x18,0x0,0x0,0x0,
//0x0a8 -- 0xa8ab  ?  5x20
0x0,0x1c,0xa8,0x80,0x6,0x31,0x8c,0x63,0x18,0xc6,0x0,0x0,0x0,
//0x0a8 -- 0xa8ac  ?  5x20
0x0,0x36,0x6,0x31,0x8c,0x63,0x18,0xc6,0x31,0x8c,0x0,0x0,0x0,
//0x0a8 -- 0xa8ad  ?  8x20
0x0,0x0,0x0,0x0,0x6c,0x0,0x0,0x3c,0x66,0xc3,0xc3,0xc3,0xc3,0xc3,0x66,0x3c,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8ae  ?  8x20
0x0,0x0,0x6,0xc,0x18,0x0,0x0,0x3c,0x66,0xc3,0xc3,0xc3,0xc3,0xc3,0x66,0x3c,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8af  ?  8x20
0x0,0x0,0x1c,0x14,0x22,0x0,0x0,0x3c,0x66,0xc3,0xc3,0xc3,0xc3,0xc3,0x66,0x3c,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8b0  ?  5x20
0x0,0x18,0x6,0x31,0x8c,0x63,0x18,0xc6,0x31,0x8c,0x0,0x0,0x0,
//0x0a8 -- 0xa8b1  ?  8x20
0x0,0x0,0x0,0x0,0x6c,0x0,0x0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc7,0x7b,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8b2  ?  8x20
0x0,0x0,0x6,0xc,0x18,0x0,0x0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc7,0x7b,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8b3  ?  8x20
0x0,0x0,0x1c,0x14,0x22,0x0,0x0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc7,0x7b,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8b4  ?  8x20
0x0,0x0,0x60,0x30,0x18,0x0,0x0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc7,0x7b,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8b5  ?  11x20
0x0,0x0,0x0,0x6c,0x0,0x0,0x40,0x18,0x3,0x80,0xb0,0x13,0x2,0x60,0x86,0x1f,0xc4,0x18,0x81,0x90,0x34,0x3,0x0,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8b6  ?  9x20
0x0,0x0,0x0,0x0,0x1,0xf3,0x85,0x81,0x80,0xc0,0x60,0x30,0x18,0xc,0x3,0x1,0xc2,0x3e,0x6,0x1,0x3,0x80,0x0,
//0x0a8 -- 0xa8b7  ?  7x20
0x0,0x0,0x0,0x0,0x0,0x0,0x1f,0x61,0x83,0x6,0xc,0x18,0x18,0x1f,0xc,0x8,0x70,0x0,
//0x0a8 -- 0xa8b8  ?  11x20
0x0,0x0,0x0,0x6c,0x0,0x1,0xf0,0xe3,0x98,0x36,0x3,0xc0,0x78,0xf,0x1,0xe0,0x3c,0x6,0xc1,0x9c,0x70,0xf8,0x0,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8b9  ?  8x20
0x0,0x0,0x36,0x0,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0x66,0x3c,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8ba  ?  8x20
0x0,0x0,0x1c,0x14,0x22,0x0,0x0,0x3c,0x66,0xc3,0xc3,0xff,0xc0,0xc0,0x60,0x3f,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8bb  ?  11x20
0x3,0x0,0xc0,0x30,0x0,0x0,0x40,0x18,0x3,0x80,0xb0,0x13,0x2,0x60,0x86,0x1f,0xc4,0x18,0x81,0x90,0x34,0x3,0x0,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8bc  ?  7x20
0x18,0x61,0x80,0xf,0xf8,0x30,0x60,0xc1,0xfb,0x6,0xc,0x18,0x30,0x7f,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8bd  ?  9x20
0x0,0x1d,0xb,0x80,0xc,0xf,0x7,0x83,0x61,0xb8,0xcc,0x63,0x31,0xd8,0x6c,0x1e,0xf,0x3,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8be  ?  8x20
0x0,0x0,0x0,0x3a,0x2e,0x0,0x0,0xde,0xe3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8bf  ?  9x20
0x0,0x1d,0xb,0x80,0xc,0xf,0x7,0x83,0x61,0xb8,0xcc,0x63,0x31,0xd8,0x6c,0x1e,0xf,0x3,0x0,0x0,0x0,0x0,0x0,
//0x0a8 -- 0xa8c0  ?  8x20
0x0,0x0,0x0,0x0,0x78,0xcc,0xcc,0xcc,0xd8,0xd8,0xdc,0xce,0xc7,0xc3,0xc3,0xde,0x0,0x0,0x0,0x0,0x0,
0x0
};

unsigned char *ISO_88591_20GetCharacterFontBit(unsigned short ch, unsigned short *font_width)
{
    unsigned short iIndex, iPos ;
    
    if(ch > 0x80)//special character
    {
    	iPos = iIndex = ((ch  + (ch & 0xff)*18) % SPECIAL_CHARACTER_NUM) + SPECIAL_CHARACTER_START ; //simple Harsh search
    	
    	while((ISO_88591_20_font_map[iIndex].character != ch)&&(ISO_88591_20_font_map[iIndex].character != 0))
    	{
    	    iIndex++ ;
    	    if(iIndex == TOTAL_CHARACTER_NUM) //at the end of font list
		iIndex = SPECIAL_CHARACTER_START ;
	    if(iPos == iIndex) //search all list
		break ;
	}
	if(ISO_88591_20_font_map[iIndex].character != ch) //don't found this character
	    iIndex = '?' - START_CHARACTER ;
    }
    else //normal asicii character
    {
	iIndex = ch - START_CHARACTER ;
	if(ISO_88591_20_font_map[iIndex].character != ch)
	    iIndex = '?' - START_CHARACTER ;
    }
    *font_width = ISO_88591_20_font_map[iIndex].width ;
    return (unsigned char *)&ISO_88591_20_osdfont_dat[ISO_88591_20_font_map[iIndex].offset] ;
}

FONT ISO_88591_20Font = {
    "ISO_88591_20",
    20,
    0,
    20,
    0,
    3,
    TOTAL_CHARACTER_NUM,
    ISO_88591_20GetCharacterFontBit
} ;

#undef TOTAL_CHARACTER_NUM
#endif