/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.contentassist;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.contentassist.AbstractControlContentAssistSubjectAdapter;
import org.eclipse.jface.contentassist.ComboContentAssistSubjectAdapter;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.contentassist.TextContentAssistSubjectAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.contentassist.ContentAssistMessages;

public class ContentAssistHandler {
    private Control fControl;
    private AbstractControlContentAssistSubjectAdapter fContentAssistSubjectAdapter;
    private SubjectControlContentAssistant fContentAssistant;
    private FocusListener fFocusListener;
    private HandlerSubmission fHandlerSubmission;

    public static ContentAssistHandler createHandlerForCombo(Combo combo, SubjectControlContentAssistant contentAssistant) {
        return new ContentAssistHandler((Control)combo, (AbstractControlContentAssistSubjectAdapter)new ComboContentAssistSubjectAdapter(combo), contentAssistant);
    }

    public static ContentAssistHandler createHandlerForText(Text text, SubjectControlContentAssistant contentAssistant) {
        return new ContentAssistHandler((Control)text, (AbstractControlContentAssistSubjectAdapter)new TextContentAssistSubjectAdapter(text), contentAssistant);
    }

    private ContentAssistHandler(Control control, AbstractControlContentAssistSubjectAdapter subjectAdapter, SubjectControlContentAssistant contentAssistant) {
        this.fControl = control;
        this.fContentAssistant = contentAssistant;
        this.fContentAssistSubjectAdapter = subjectAdapter;
        this.setEnabled(true);
        this.fControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ContentAssistHandler.this.setEnabled(false);
            }
        });
    }

    public boolean isEnabled() {
        return this.fFocusListener != null;
    }

    public void setEnabled(boolean enable) {
        if (enable == this.isEnabled()) {
            return;
        }
        if (enable) {
            this.enable();
        } else {
            this.disable();
        }
    }

    private void enable() {
        if (!this.fControl.isDisposed()) {
            this.fContentAssistant.install((IContentAssistSubjectControl)this.fContentAssistSubjectAdapter);
            this.installCueLabelProvider();
            this.installFocusListener();
            if (this.fControl.isFocusControl()) {
                this.activateHandler();
            }
        }
    }

    private void disable() {
        if (!this.fControl.isDisposed()) {
            this.fContentAssistant.uninstall();
            this.fContentAssistSubjectAdapter.setContentAssistCueProvider(null);
            this.fControl.removeFocusListener(this.fFocusListener);
            this.fFocusListener = null;
            if (this.fHandlerSubmission != null) {
                this.deactivateHandler();
            }
        }
    }

    private void installCueLabelProvider() {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                ICommandManager commandManager = PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
                ICommand command = commandManager.getCommand("org.eclipse.ui.edit.text.contentAssist.proposals");
                List bindings = command.getKeySequenceBindings();
                if (bindings.size() == 0) {
                    return ContentAssistMessages.getString("ContentAssistHandler.contentAssistAvailable");
                }
                IKeySequenceBinding ksb = (IKeySequenceBinding)bindings.get(0);
                Object[] args = new Object[]{ksb.getKeySequence().format()};
                return ContentAssistMessages.getFormattedString("ContentAssistHandler.contentAssistAvailableWithKeyBinding", args);
            }
        };
        this.fContentAssistSubjectAdapter.setContentAssistCueProvider((ILabelProvider)labelProvider);
    }

    private void installFocusListener() {
        this.fFocusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                ContentAssistHandler.this.activateHandler();
            }

            public void focusLost(FocusEvent e) {
                if (ContentAssistHandler.this.fHandlerSubmission != null) {
                    ContentAssistHandler.this.deactivateHandler();
                }
            }
        };
        this.fControl.addFocusListener(this.fFocusListener);
    }

    private void activateHandler() {
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(Map parameterValuesByName) throws ExecutionException {
                if (ContentAssistHandler.this.isEnabled()) {
                    ContentAssistHandler.this.fContentAssistant.showPossibleCompletions();
                }
                return null;
            }
        };
        this.fHandlerSubmission = new HandlerSubmission(null, this.fControl.getShell(), null, "org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)handler, Priority.MEDIUM);
        IWorkbenchCommandSupport commandSupport = PlatformUI.getWorkbench().getCommandSupport();
        commandSupport.addHandlerSubmission(this.fHandlerSubmission);
    }

    private void deactivateHandler() {
        IWorkbenchCommandSupport commandSupport = PlatformUI.getWorkbench().getCommandSupport();
        commandSupport.removeHandlerSubmission(this.fHandlerSubmission);
        this.fHandlerSubmission = null;
    }
}

