/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.workingset;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class HelpWorkingSet {
    private WorkingSet workingSet;
    private IWorkingSet iworkingSet;

    public HelpWorkingSet(String name, IAdaptable[] elements) {
        this(BaseHelpSystem.getWorkingSetManager().createWorkingSet(name, (AdaptableHelpResource[])elements));
    }

    public HelpWorkingSet(WorkingSet ws) {
        this.workingSet = ws;
        this.iworkingSet = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSet(ws.getName(), (IAdaptable[])ws.getElements());
        this.iworkingSet.setId("org.eclipse.help.ui.HelpWorkingSetPage");
    }

    public HelpWorkingSet(IWorkingSet iws) {
        this.iworkingSet = iws;
        AdaptableHelpResource[] elements = new AdaptableHelpResource[iws.getElements().length];
        System.arraycopy(iws.getElements(), 0, elements, 0, elements.length);
        this.workingSet = BaseHelpSystem.getWorkingSetManager().createWorkingSet(iws.getName(), elements);
    }

    public HelpWorkingSet(WorkingSet ws, IWorkingSet iws) {
        this.workingSet = ws;
        this.iworkingSet = iws;
    }

    public IWorkingSet getIWorkingSet() {
        return this.iworkingSet;
    }

    public WorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HelpWorkingSet) {
            HelpWorkingSet ws = (HelpWorkingSet)object;
            return this.workingSet == ws.workingSet;
        }
        return false;
    }
}

