/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.internal.ui.stringsubstitution.StringSubstitutionMessages;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.help.WorkbenchHelp;

public class RefreshTab
extends AbstractLaunchConfigurationTab {
    public static final String ATTR_REFRESH_RECURSIVE = DebugPlugin.getUniqueIdentifier() + ".ATTR_REFRESH_RECURSIVE";
    public static final String ATTR_REFRESH_SCOPE = DebugPlugin.getUniqueIdentifier() + ".ATTR_REFRESH_SCOPE";
    private static final String NO_WORKING_SET = "NONE";
    private Button fRefreshButton;
    private Button fRecursiveButton;
    private Group fGroup;
    private Button fContainerButton;
    private Button fProjectButton;
    private Button fResourceButton;
    private Button fWorkingSetButton;
    private Button fWorkspaceButton;
    private Button fSelectButton;
    private IWorkingSet fWorkingSet;
    private static final String TAG_LAUNCH_CONFIGURATION_WORKING_SET = "launchConfigurationWorkingSet";
    private static final String TAG_FACTORY_ID = "factoryID";
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_REFRESH_TAB);
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gd);
        mainComposite.setFont(parent.getFont());
        this.fRefreshButton = this.createCheckButton(mainComposite, StringSubstitutionMessages.getString("RefreshTab.31"));
        this.fRefreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefreshTab.this.updateEnabledState();
                RefreshTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fGroup = new Group(mainComposite, 0);
        this.fGroup.setFont(mainComposite.getFont());
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        this.fGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fGroup.setLayoutData((Object)gd);
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    RefreshTab.this.updateEnabledState();
                    RefreshTab.this.updateLaunchConfigurationDialog();
                }
            }
        };
        this.fWorkspaceButton = this.createRadioButton((Composite)this.fGroup, StringSubstitutionMessages.getString("RefreshTab.32"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fWorkspaceButton.setLayoutData((Object)gd);
        this.fWorkspaceButton.addSelectionListener((SelectionListener)adapter);
        this.fResourceButton = this.createRadioButton((Composite)this.fGroup, StringSubstitutionMessages.getString("RefreshTab.33"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fResourceButton.setLayoutData((Object)gd);
        this.fResourceButton.addSelectionListener((SelectionListener)adapter);
        this.fProjectButton = this.createRadioButton((Composite)this.fGroup, StringSubstitutionMessages.getString("RefreshTab.34"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fProjectButton.setLayoutData((Object)gd);
        this.fProjectButton.addSelectionListener((SelectionListener)adapter);
        this.fContainerButton = this.createRadioButton((Composite)this.fGroup, StringSubstitutionMessages.getString("RefreshTab.35"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fContainerButton.setLayoutData((Object)gd);
        this.fContainerButton.addSelectionListener((SelectionListener)adapter);
        this.fWorkingSetButton = this.createRadioButton((Composite)this.fGroup, StringSubstitutionMessages.getString("RefreshTab.36"));
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fWorkingSetButton.setLayoutData((Object)gd);
        this.fWorkingSetButton.addSelectionListener((SelectionListener)adapter);
        this.fSelectButton = this.createPushButton((Composite)this.fGroup, StringSubstitutionMessages.getString("RefreshTab.37"), null);
        gd = (GridData)this.fSelectButton.getLayoutData();
        gd.horizontalAlignment = 128;
        this.fSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefreshTab.this.selectResources();
            }
        });
        this.createVerticalSpacer((Composite)this.fGroup, 2);
        this.createRecursiveComponent((Composite)this.fGroup);
    }

    private void selectResources() {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        if (this.fWorkingSet == null) {
            this.fWorkingSet = workingSetManager.createWorkingSet(StringSubstitutionMessages.getString("RefreshTab.40"), new IAdaptable[0]);
        }
        IWorkingSetEditWizard wizard = workingSetManager.createWorkingSetEditWizard(this.fWorkingSet);
        WizardDialog dialog = new WizardDialog(DebugUIPlugin.getStandardDisplay().getActiveShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 1) {
            return;
        }
        this.fWorkingSet = wizard.getSelection();
        this.updateLaunchConfigurationDialog();
    }

    private void createRecursiveComponent(Composite parent) {
        this.fRecursiveButton = this.createCheckButton(parent, StringSubstitutionMessages.getString("RefreshTab.0"));
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.fRecursiveButton.setLayoutData((Object)data);
        this.fRecursiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefreshTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateRefresh(configuration);
        this.updateRecursive(configuration);
        this.updateScope(configuration);
        this.updateEnabledState();
    }

    private void updateScope(ILaunchConfiguration configuration) {
        String scope = null;
        try {
            scope = configuration.getAttribute(ATTR_REFRESH_SCOPE, (String)null);
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(DebugUIPlugin.newErrorStatus("Exception reading launch configuration", ce));
        }
        this.fWorkspaceButton.setSelection(false);
        this.fResourceButton.setSelection(false);
        this.fContainerButton.setSelection(false);
        this.fProjectButton.setSelection(false);
        this.fWorkingSetButton.setSelection(false);
        if (scope == null) {
            this.fWorkspaceButton.setSelection(true);
        } else if (scope.equals("${workspace}")) {
            this.fWorkspaceButton.setSelection(true);
        } else if (scope.equals("${resource}")) {
            this.fResourceButton.setSelection(true);
        } else if (scope.equals("${container}")) {
            this.fContainerButton.setSelection(true);
        } else if (scope.equals("${project}")) {
            this.fProjectButton.setSelection(true);
        } else if (scope.startsWith("${resource:")) {
            this.fWorkingSetButton.setSelection(true);
            try {
                IResource[] resources = RefreshTab.getRefreshResources(scope);
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                this.fWorkingSet = workingSetManager.createWorkingSet(StringSubstitutionMessages.getString("RefreshTab.40"), (IAdaptable[])resources);
            }
            catch (CoreException e) {
                this.fWorkingSet = null;
            }
        } else if (scope.startsWith("${working_set:")) {
            this.fWorkingSetButton.setSelection(true);
            String memento = scope.substring(14, scope.length() - 1);
            this.fWorkingSet = RefreshTab.restoreWorkingSet(memento);
        }
    }

    private void updateRecursive(ILaunchConfiguration configuration) {
        boolean recursive = true;
        try {
            recursive = configuration.getAttribute(ATTR_REFRESH_RECURSIVE, true);
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(DebugUIPlugin.newErrorStatus("Exception reading launch configuration", ce));
        }
        this.fRecursiveButton.setSelection(recursive);
    }

    private void updateRefresh(ILaunchConfiguration configuration) {
        String scope = null;
        try {
            scope = configuration.getAttribute(ATTR_REFRESH_SCOPE, (String)null);
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(DebugUIPlugin.newErrorStatus("Exception reading launch configuration", ce));
        }
        this.fRefreshButton.setSelection(scope != null);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fRefreshButton.getSelection()) {
            String scope = this.generateScopeMemento();
            configuration.setAttribute(ATTR_REFRESH_SCOPE, scope);
            this.setAttribute(ATTR_REFRESH_RECURSIVE, configuration, this.fRecursiveButton.getSelection(), true);
        } else {
            configuration.setAttribute(ATTR_REFRESH_SCOPE, (String)null);
            this.setAttribute(ATTR_REFRESH_RECURSIVE, configuration, true, true);
        }
    }

    private String generateScopeMemento() {
        if (this.fWorkspaceButton.getSelection()) {
            return "${workspace}";
        }
        if (this.fResourceButton.getSelection()) {
            return "${resource}";
        }
        if (this.fContainerButton.getSelection()) {
            return "${container}";
        }
        if (this.fProjectButton.getSelection()) {
            return "${project}";
        }
        if (this.fWorkingSetButton.getSelection()) {
            return RefreshTab.getRefreshAttribute(this.fWorkingSet);
        }
        return null;
    }

    public String getName() {
        return StringSubstitutionMessages.getString("RefreshTab.6");
    }

    private void updateEnabledState() {
        boolean enabled = this.fRefreshButton.getSelection();
        this.fRecursiveButton.setEnabled(enabled);
        this.fGroup.setEnabled(enabled);
        this.fWorkspaceButton.setEnabled(enabled);
        this.fResourceButton.setEnabled(enabled);
        this.fContainerButton.setEnabled(enabled);
        this.fProjectButton.setEnabled(enabled);
        this.fWorkingSetButton.setEnabled(enabled);
        this.fSelectButton.setEnabled(enabled && this.fWorkingSetButton.getSelection());
        if (!enabled) {
            super.setErrorMessage(null);
        }
    }

    public Image getImage() {
        return DebugPluginImages.getImage("IMG_OBJS_REFRESH_TAB");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fWorkingSetButton.getSelection() && (this.fWorkingSet == null || this.fWorkingSet.getElements().length == 0)) {
            this.setErrorMessage(StringSubstitutionMessages.getString("RefreshTab.42"));
            return false;
        }
        return true;
    }

    public static void refreshResources(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String scope = RefreshTab.getRefreshScope(configuration);
        IResource[] resources = null;
        if (scope != null) {
            resources = RefreshTab.getRefreshResources(scope);
        }
        if (resources == null || resources.length == 0) {
            return;
        }
        int depth = 1;
        if (RefreshTab.isRefreshRecursive(configuration)) {
            depth = 2;
        }
        if (monitor.isCanceled()) {
            return;
        }
        monitor.beginTask(StringSubstitutionMessages.getString("RefreshTab.7"), resources.length);
        MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 0, StringSubstitutionMessages.getString("RefreshTab.8"), null);
        for (int i = 0; i < resources.length && !monitor.isCanceled(); ++i) {
            if (resources[i] != null && resources[i].isAccessible()) {
                try {
                    resources[i].refreshLocal(depth, null);
                }
                catch (CoreException e) {
                    status.merge(e.getStatus());
                }
            }
            monitor.worked(1);
        }
        monitor.done();
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
    }

    public static IResource[] getRefreshResources(String scope) throws CoreException {
        if (scope.startsWith("${resource:")) {
            String pathString = scope.substring(11, scope.length() - 1);
            Path path = new Path(pathString);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (resource == null) {
                throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, MessageFormat.format(StringSubstitutionMessages.getString("RefreshTab.38"), pathString), null));
            }
            return new IResource[]{resource};
        }
        if (scope.startsWith("${working_set:")) {
            IWorkingSet workingSet = RefreshTab.getWorkingSet(scope);
            if (workingSet == null) {
                throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, StringSubstitutionMessages.getString("RefreshTab.39"), null));
            }
            IAdaptable[] elements = workingSet.getElements();
            IResource[] resources = new IResource[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                IAdaptable adaptable = elements[i];
                resources[i] = adaptable instanceof IResource ? (IResource)adaptable : (IResource)adaptable.getAdapter(class$org$eclipse$core$resources$IResource == null ? RefreshTab.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
            }
            return resources;
        }
        if (scope.equals("${workspace}")) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        IResource resource = SelectedResourceManager.getDefault().getSelectedResource();
        if (resource == null) {
            return new IResource[0];
        }
        if (!scope.equals("${resource}")) {
            if (scope.equals("${container}")) {
                resource = resource.getParent();
            } else if (scope.equals("${project}")) {
                resource = resource.getProject();
            }
        }
        return new IResource[]{resource};
    }

    private static IWorkingSet restoreWorkingSet(String mementoString) {
        if (NO_WORKING_SET.equals(mementoString)) {
            return null;
        }
        StringReader reader = new StringReader(mementoString);
        XMLMemento memento = null;
        try {
            memento = XMLMemento.createReadRoot((Reader)reader);
        }
        catch (WorkbenchException e) {
            DebugUIPlugin.log(e);
            return null;
        }
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        return workingSetManager.createWorkingSet((IMemento)memento);
    }

    public static String getRefreshScope(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(ATTR_REFRESH_SCOPE, (String)null);
    }

    public static boolean isRefreshRecursive(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(ATTR_REFRESH_RECURSIVE, true);
    }

    public static String getRefreshAttribute(IWorkingSet workingSet) {
        String set = null;
        if (workingSet == null || workingSet.getElements().length == 0) {
            set = NO_WORKING_SET;
        } else {
            XMLMemento workingSetMemento = XMLMemento.createWriteRoot((String)TAG_LAUNCH_CONFIGURATION_WORKING_SET);
            if (workingSet != null) {
                workingSetMemento.putString(TAG_FACTORY_ID, workingSet.getFactoryId());
                workingSet.saveState((IMemento)workingSetMemento);
                StringWriter writer = new StringWriter();
                try {
                    workingSetMemento.save((Writer)writer);
                }
                catch (IOException e) {
                    DebugUIPlugin.log(e);
                }
                set = writer.toString();
            }
        }
        if (set != null) {
            StringBuffer memento = new StringBuffer();
            memento.append("${working_set:");
            memento.append(set);
            memento.append("}");
            return memento.toString();
        }
        return null;
    }

    public static IWorkingSet getWorkingSet(String refreshAttribute) {
        if (refreshAttribute.startsWith("${working_set:")) {
            String memento = refreshAttribute.substring(14, refreshAttribute.length() - 1);
            return RefreshTab.restoreWorkingSet(memento);
        }
        return null;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

