/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.ContentConsumer;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SiteFile;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteFilePluginContentConsumer
extends ContentConsumer {
    private IPluginEntry pluginEntry;
    private ISite site;
    private boolean closed = false;
    private Map renames = new HashMap(2);
    private List installedFiles;

    public SiteFilePluginContentConsumer(IPluginEntry pluginEntry, ISite site) {
        this.pluginEntry = pluginEntry;
        this.site = site;
        this.installedFiles = new ArrayList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(ContentReference contentReference, IProgressMonitor monitor) throws CoreException {
        InputStream inStream = null;
        String pluginPath = null;
        if (this.closed) {
            UpdateCore.warn("Attempt to store in a closed SiteFilePluginContentConsumer", new Exception());
            return;
        }
        try {
            try {
                URL newURL = new URL(this.site.getURL(), "plugins/" + this.pluginEntry.getVersionedIdentifier().toString());
                pluginPath = newURL.getFile();
                String contentKey = contentReference.getIdentifier();
                inStream = contentReference.getInputStream();
                pluginPath = pluginPath + (pluginPath.endsWith(File.separator) ? contentKey : File.separator + contentKey);
                String logEntry = null;
                if ("plugin.xml".equals(contentKey)) {
                    logEntry = "PLUGIN";
                } else if ("fragment.xml".equals(contentKey)) {
                    logEntry = "FRAGMENT";
                } else if ("META-INF/MANIFEST.MF".equals(contentKey)) {
                    logEntry = "BUNDLE_MANIFEST";
                }
                if (logEntry != null) {
                    String originalName = pluginPath.replace(File.separatorChar, '/');
                    File localFile = new File(originalName);
                    if (localFile.exists()) {
                        throw Utilities.newCoreException(Policy.bind("UpdateManagerUtils.FileAlreadyExists", new Object[]{localFile}), null);
                    }
                    pluginPath = ErrorRecoveryLog.getLocalRandomIdentifier(pluginPath);
                    this.renames.put(pluginPath, originalName);
                    ErrorRecoveryLog.getLog().appendPath(logEntry, pluginPath);
                }
                UpdateManagerUtils.copyToLocal(inStream, pluginPath, null);
                UpdateManagerUtils.checkPermissions(contentReference, pluginPath);
                this.installedFiles.add(pluginPath);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(Policy.bind("GlobalConsumer.ErrorCreatingFile", pluginPath), e);
            }
            Object var11_11 = null;
            if (inStream == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        inStream.close();
        return;
    }

    public void close() throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to close a closed SiteFilePluginContentConsumer", new Exception());
            return;
        }
        Iterator it = this.renames.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String temporary = (String)entry.getKey();
            String original = (String)entry.getValue();
            ErrorRecoveryLog.getLog().appendPath("RENAME", temporary);
            File fileToRename = new File(temporary);
            boolean sucess = false;
            if (fileToRename.exists()) {
                File renamedFile = new File(original);
                sucess = fileToRename.renameTo(renamedFile);
            }
            if (sucess) continue;
            String msg = Policy.bind("ContentConsumer.UnableToRename", temporary, original);
            throw Utilities.newCoreException(msg, new Exception(msg));
        }
        if (this.site instanceof SiteFile) {
            ((SiteFile)this.site).addPluginEntry(this.pluginEntry);
        }
        this.closed = true;
    }

    public void abort() throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to abort a closed SiteFilePluginContentConsumer", new Exception());
            return;
        }
        boolean success = true;
        Iterator it = this.renames.values().iterator();
        while (it.hasNext()) {
            String originalName = (String)it.next();
            ErrorRecoveryLog.getLog().appendPath("DELETE", originalName);
            File fileToRemove = new File(originalName);
            if (!fileToRemove.exists() || fileToRemove.delete()) continue;
            String msg = Policy.bind("Unable to delete", originalName);
            UpdateCore.log(msg, null);
            success = false;
        }
        if (success) {
            Iterator iter = this.installedFiles.iterator();
            File featureFile = null;
            while (iter.hasNext()) {
                String path = (String)iter.next();
                featureFile = new File(path);
                UpdateManagerUtils.removeFromFileSystem(featureFile);
            }
            try {
                URL newURL = new URL(this.site.getURL(), "plugins/" + this.pluginEntry.getVersionedIdentifier().toString());
                String pluginPath = newURL.getFile();
                UpdateManagerUtils.removeEmptyDirectoriesFromFileSystem(new File(pluginPath));
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(e.getMessage(), e);
            }
        }
        this.closed = true;
    }
}

