/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.Policy;

public class CVSTag {
    public static final int HEAD = 0;
    public static final int BRANCH = 1;
    public static final int VERSION = 2;
    public static final int DATE = 3;
    public static final CVSTag DEFAULT = new CVSTag();
    public static final CVSTag BASE = new CVSTag("BASE", 2);
    protected String name;
    protected int type;
    private static final String DATE_TAG_NAME_FORMAT = "dd MMM yyyy HH:mm:ss Z";
    private static final SimpleDateFormat tagNameFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss Z", Locale.US);

    protected static synchronized String dateToTagName(Date date) {
        tagNameFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return tagNameFormat.format(date);
    }

    protected static Date tagNameToDate(String name) {
        if (name == null) {
            return null;
        }
        try {
            return tagNameFormat.parse(name);
        }
        catch (ParseException e) {
            CVSProviderPlugin.log((CoreException)((Object)new CVSException("Tag name " + name + " is not of the expected format " + DATE_TAG_NAME_FORMAT, e)));
            return null;
        }
    }

    public CVSTag() {
        this("HEAD", 0);
    }

    public CVSTag(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public CVSTag(Date date) {
        this(CVSTag.dateToTagName(date), 3);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CVSTag)) {
            return false;
        }
        CVSTag tag = (CVSTag)other;
        if (this.getType() != tag.getType()) {
            return false;
        }
        return this.getName().equals(tag.getName());
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int compareTo(CVSTag other) {
        if (this.getType() == 3 && other.getType() == 3) {
            Date date1 = this.asDate();
            Date date2 = other.asDate();
            if (date1 == null || date2 == null) {
                return -1;
            }
            return date1.compareTo(date2);
        }
        return this.getName().compareTo(other.getName());
    }

    public static boolean equalTags(CVSTag tag1, CVSTag tag2) {
        if (tag1 == null) {
            tag1 = DEFAULT;
        }
        if (tag2 == null) {
            tag2 = DEFAULT;
        }
        return tag1.equals(tag2);
    }

    public static IStatus validateTagName(String tagName) {
        if (tagName == null) {
            return new CVSStatus(4, Policy.bind("CVSTag.nullName"));
        }
        if (tagName.equals("")) {
            return new CVSStatus(4, Policy.bind("CVSTag.emptyName"));
        }
        if (!Character.isLetter(tagName.charAt(0))) {
            return new CVSStatus(4, Policy.bind("CVSTag.beginName"));
        }
        for (int i = 0; i < tagName.length(); ++i) {
            char c = tagName.charAt(i);
            if (!Character.isSpaceChar(c) && c != '$' && c != ',' && c != '.' && c != ':' && c != ';' && c != '@' && c != '|') continue;
            return new CVSStatus(4, Policy.bind("CVSTag.badCharName"));
        }
        return new CVSStatus(0, Policy.bind("ok"));
    }

    public Date asDate() {
        return CVSTag.tagNameToDate(this.name);
    }
}

