/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.util.SearchUtils;

public class ReferenceFinderUtil {
    private ReferenceFinderUtil() {
    }

    public static IType[] getTypesReferencedIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        SearchMatch[] results = ReferenceFinderUtil.getTypeReferencesIn(elements, pm);
        Set referencedTypes = ReferenceFinderUtil.extractElements(results, 7);
        return referencedTypes.toArray(new IType[referencedTypes.size()]);
    }

    private static SearchMatch[] getTypeReferencesIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        ArrayList referencedTypes = new ArrayList();
        pm.beginTask("", elements.length);
        for (int i = 0; i < elements.length; ++i) {
            referencedTypes.addAll(ReferenceFinderUtil.getTypeReferencesIn(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        }
        pm.done();
        return referencedTypes.toArray(new SearchMatch[referencedTypes.size()]);
    }

    private static List getTypeReferencesIn(IJavaElement element, IProgressMonitor pm) throws JavaModelException {
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        new SearchEngine().searchDeclarationsOfReferencedTypes(element, (SearchRequestor)requestor, pm);
        return requestor.getResults();
    }

    public static IField[] getFieldsReferencedIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        SearchMatch[] results = ReferenceFinderUtil.getFieldReferencesIn(elements, pm);
        Set referencedFields = ReferenceFinderUtil.extractElements(results, 8);
        return referencedFields.toArray(new IField[referencedFields.size()]);
    }

    private static SearchMatch[] getFieldReferencesIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        ArrayList referencedFields = new ArrayList();
        pm.beginTask("", elements.length);
        for (int i = 0; i < elements.length; ++i) {
            referencedFields.addAll(ReferenceFinderUtil.getFieldReferencesIn(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        }
        pm.done();
        return referencedFields.toArray(new SearchMatch[referencedFields.size()]);
    }

    private static List getFieldReferencesIn(IJavaElement element, IProgressMonitor pm) throws JavaModelException {
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        new SearchEngine().searchDeclarationsOfAccessedFields(element, (SearchRequestor)requestor, pm);
        return requestor.getResults();
    }

    public static IMethod[] getMethodsReferencedIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        SearchMatch[] results = ReferenceFinderUtil.getMethodReferencesIn(elements, pm);
        Set referencedMethods = ReferenceFinderUtil.extractElements(results, 9);
        return referencedMethods.toArray(new IMethod[referencedMethods.size()]);
    }

    private static SearchMatch[] getMethodReferencesIn(IJavaElement[] elements, IProgressMonitor pm) throws JavaModelException {
        ArrayList referencedMethods = new ArrayList();
        pm.beginTask("", elements.length);
        for (int i = 0; i < elements.length; ++i) {
            referencedMethods.addAll(ReferenceFinderUtil.getMethodReferencesIn(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        }
        pm.done();
        return referencedMethods.toArray(new SearchMatch[referencedMethods.size()]);
    }

    private static List getMethodReferencesIn(IJavaElement element, IProgressMonitor pm) throws JavaModelException {
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        new SearchEngine().searchDeclarationsOfSentMessages(element, (SearchRequestor)requestor, pm);
        return requestor.getResults();
    }

    public static ITypeBinding[] getTypesReferencedInDeclarations(MethodDeclaration[] methods) {
        HashSet typesUsed = new HashSet();
        for (int i = 0; i < methods.length; ++i) {
            typesUsed.addAll(ReferenceFinderUtil.getTypesUsedInDeclaration(methods[i]));
        }
        return typesUsed.toArray(new ITypeBinding[typesUsed.size()]);
    }

    public static Set getTypesUsedInDeclaration(MethodDeclaration methodDeclaration) {
        if (methodDeclaration == null) {
            return new HashSet(0);
        }
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        ITypeBinding binding = methodDeclaration.getReturnType().resolveBinding();
        if (binding != null) {
            result.add(binding);
        }
        Iterator iter = methodDeclaration.parameters().iterator();
        while (iter.hasNext()) {
            binding = ((SingleVariableDeclaration)iter.next()).getType().resolveBinding();
            if (binding == null) continue;
            result.add(binding);
        }
        iter = methodDeclaration.thrownExceptions().iterator();
        while (iter.hasNext()) {
            binding = ((Name)iter.next()).resolveTypeBinding();
            if (binding == null) continue;
            result.add(binding);
        }
        return result;
    }

    private static Set extractElements(SearchMatch[] searchResults, int elementType) {
        HashSet<IJavaElement> elements = new HashSet<IJavaElement>();
        for (int i = 0; i < searchResults.length; ++i) {
            IJavaElement el = SearchUtils.getEnclosingJavaElement(searchResults[i]);
            if (!el.exists() || el.getElementType() != elementType) continue;
            elements.add(el);
        }
        return elements;
    }
}

