/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.ui.AbstractDebugView;

public class VariablesViewEventHandler
extends AbstractDebugEventHandler {
    public VariablesViewEventHandler(AbstractDebugView view) {
        super(view);
    }

    protected void doHandleDebugEvents(DebugEvent[] events) {
        block5: for (int i = 0; i < events.length; ++i) {
            DebugEvent event = events[i];
            switch (event.getKind()) {
                case 2: {
                    this.doHandleSuspendEvent(event);
                    continue block5;
                }
                case 16: {
                    this.doHandleChangeEvent(event);
                    continue block5;
                }
                case 1: {
                    this.doHandleResumeEvent(event);
                }
            }
        }
    }

    protected void updateForDebugEvents(DebugEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            DebugEvent event = events[i];
            switch (event.getKind()) {
                case 8: {
                    this.doHandleTerminateEvent(event);
                }
            }
        }
    }

    protected void doHandleResumeEvent(DebugEvent event) {
        if (!event.isStepStart() && !event.isEvaluation()) {
            this.getVariablesView().clearExpandedVariables(event.getSource());
        }
    }

    protected void doHandleTerminateEvent(DebugEvent event) {
        this.getVariablesView().clearExpandedVariables(event.getSource());
    }

    protected void doHandleSuspendEvent(DebugEvent event) {
        if (event.getDetail() != 128) {
            if (event.getSource() instanceof ISuspendResume && !((ISuspendResume)event.getSource()).isSuspended()) {
                return;
            }
            this.refresh();
            this.getVariablesView().populateDetailPane();
        }
    }

    protected void doHandleChangeEvent(DebugEvent event) {
        if (event.getDetail() == 256) {
            if (event.getSource() instanceof IVariable) {
                this.refresh(event.getSource());
            }
        } else if (!(event.getSource() instanceof IExpression)) {
            this.refresh();
        }
    }

    protected VariablesView getVariablesView() {
        return (VariablesView)this.getView();
    }

    protected void viewBecomesVisible() {
        super.viewBecomesVisible();
        this.getVariablesView().populateDetailPane();
    }
}

