/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Assert;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public abstract class ModelObject
extends PlatformObject {
    private boolean readOnly = false;
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static Map bundles;

    protected ModelObject() {
    }

    protected final void assertIsWriteable() {
        Assert.isTrue(!this.isReadOnly(), Policy.bind("ModelObject.ModelReadOnly"));
    }

    public void markReadOnly() {
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void markReferenceReadOnly(ModelObject o) {
        if (o == null) {
            return;
        }
        o.markReadOnly();
    }

    protected void markListReferenceReadOnly(ModelObject[] o) {
        if (o == null) {
            return;
        }
        for (int i = 0; i < o.length; ++i) {
            o[i].markReadOnly();
        }
    }

    public void resolve(URL base, URL bundleURL) throws MalformedURLException {
    }

    protected void resolveReference(ModelObject o, URL url, URL bundleURL) throws MalformedURLException {
        if (o == null) {
            return;
        }
        o.resolve(url, bundleURL);
    }

    protected void resolveListReference(ModelObject[] o, URL url, URL bundleURL) throws MalformedURLException {
        if (o == null) {
            return;
        }
        for (int i = 0; i < o.length; ++i) {
            o[i].resolve(url, bundleURL);
        }
    }

    protected URL resolveURL(URL context, URL bundleURL, String urlString) throws MalformedURLException {
        if (urlString == null || urlString.trim().equals("")) {
            return null;
        }
        String resolvedUrlString = this.resolveNLString(bundleURL, urlString);
        resolvedUrlString = this.resolvePlatfromConfiguration(resolvedUrlString);
        if (context == null) {
            return new URL(resolvedUrlString);
        }
        return new URL(context, resolvedUrlString);
    }

    private String resolvePlatfromConfiguration(String resolvedUrlString) {
        int osIndex = resolvedUrlString.indexOf("$os$");
        if (osIndex != -1) {
            return this.getExtendedString(resolvedUrlString);
        }
        int wsIndex = resolvedUrlString.indexOf("$ws$");
        if (wsIndex != -1) {
            return this.getExtendedString(resolvedUrlString);
        }
        int nlIndex = resolvedUrlString.indexOf("$nl$");
        if (nlIndex != -1) {
            return this.getExtendedString(resolvedUrlString);
        }
        int archIndex = resolvedUrlString.indexOf("$arch$");
        if (archIndex != -1) {
            return this.getExtendedString(resolvedUrlString);
        }
        return resolvedUrlString;
    }

    private String getExtendedString(String resolvedUrlString) {
        Path path = new Path(resolvedUrlString);
        path = this.getExpandedPath((IPath)path);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_WARNINGS) {
            UpdateCore.warn("Resolved :" + resolvedUrlString + " as:" + path.toOSString());
        }
        return path.toOSString();
    }

    private IPath getExpandedPath(IPath path) {
        String first = path.segment(0);
        if (first != null) {
            IPath rest = this.getExpandedPath(path.removeFirstSegments(1));
            if (first.equals("$ws$")) {
                path = new Path(SiteManager.getWS()).append(rest);
            } else if (first.equals("$os$")) {
                path = new Path(SiteManager.getOS()).append(rest);
            } else if (first.equals("$nl$")) {
                path = new Path(SiteManager.getNL()).append(rest);
            } else if (first.equals("$arch$")) {
                path = new Path(SiteManager.getOSArch()).append(rest);
            }
        }
        return path;
    }

    protected String resolveNLString(URL bundleURL, String string) {
        if (string == null) {
            return null;
        }
        String s = string.trim();
        if (s.equals("")) {
            return string;
        }
        if (!s.startsWith(KEY_PREFIX)) {
            return string;
        }
        if (s.startsWith(KEY_DOUBLE_PREFIX)) {
            return s.substring(1);
        }
        int ix = s.indexOf(" ");
        String key = ix == -1 ? s : s.substring(0, ix);
        String dflt = ix == -1 ? s : s.substring(ix + 1);
        ResourceBundle b = this.getResourceBundle(bundleURL);
        if (b == null) {
            return dflt;
        }
        try {
            return b.getString(key.substring(1));
        }
        catch (MissingResourceException e) {
            return dflt;
        }
    }

    protected Object[] arrayTypeFor(List l) {
        if (l == null || l.size() == 0) {
            return null;
        }
        return (Object[])Array.newInstance(l.get(0).getClass(), 0);
    }

    protected Object[] arrayTypeFor(Set s) {
        if (s == null || s.size() == 0) {
            return null;
        }
        Iterator i = s.iterator();
        return (Object[])Array.newInstance(i.next().getClass(), 0);
    }

    protected ResourceBundle getResourceBundle(URL url) {
        ResourceBundle bundle;
        if (url == null) {
            return null;
        }
        if (bundles == null) {
            bundles = new HashMap();
        } else {
            bundle = (ResourceBundle)bundles.get(url.toExternalForm());
            if (bundle != null) {
                return bundle;
            }
        }
        bundle = null;
        try {
            url = UpdateManagerUtils.asDirectoryURL(url);
            URLClassLoader l = new URLClassLoader(new URL[]{url}, null);
            bundle = ResourceBundle.getBundle(this.getPropertyName(), Locale.getDefault(), l);
            bundles.put(url.toExternalForm(), bundle);
        }
        catch (MissingResourceException e) {
            UpdateCore.warn(e.getLocalizedMessage() + ":" + url.toExternalForm());
        }
        catch (MalformedURLException e) {
            UpdateCore.warn(e.getLocalizedMessage());
        }
        return bundle;
    }

    protected String getPropertyName() {
        return "feature";
    }
}

