/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;
import org.eclipse.ui.views.tasklist.TaskListMessages;

class PasteTaskAction
extends TaskAction {
    public PasteTaskAction(TaskList tasklist, String id) {
        super(tasklist, id);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.paste_task_action_context");
    }

    public void run() {
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        final IMarker[] markerData = (IMarker[])this.getTaskList().getClipboard().getContents((Transfer)transfer);
        if (markerData == null) {
            return;
        }
        final ArrayList newMarkers = new ArrayList();
        try {
            this.getTaskList().getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (int i = 0; i < markerData.length; ++i) {
                        if (!markerData[i].getType().equals("org.eclipse.core.resources.taskmarker")) continue;
                        IResource resource = markerData[i].getResource();
                        Map attributes = markerData[i].getAttributes();
                        IMarker marker = resource.createMarker("org.eclipse.core.resources.taskmarker");
                        marker.setAttributes(attributes);
                        newMarkers.add(marker);
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)TaskListMessages.getString("PasteTask.errorMessage"), null, (IStatus)e.getStatus());
            return;
        }
        if (newMarkers.size() > 0) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TaskList taskList = PasteTaskAction.this.getTaskList();
                    taskList.setSelection((ISelection)new StructuredSelection((List)newMarkers), true);
                }
            });
        }
    }
}

