/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.JavaBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

public class JavaLineBreakpointTypeChange
extends JavaBreakpointTypeChange {
    private int fLineNumber;
    private int fCharStart;
    private int fCharEnd;

    public JavaLineBreakpointTypeChange(IJavaLineBreakpoint lineBreakpoint, Object changedElement, Object argument, int changeType) throws CoreException {
        super((IJavaBreakpoint)lineBreakpoint, changedElement, argument, changeType);
        this.fLineNumber = lineBreakpoint.getLineNumber();
        this.fCharStart = lineBreakpoint.getCharStart();
        this.fCharEnd = lineBreakpoint.getCharEnd();
    }

    public String getErrorMessageNoMoreExists() {
        return MessageFormat.format(RefactoringMessages.getString("JavaLineBreakpointTypeChange.0"), this.getDeclaringType().getElementName(), Integer.toString(this.fLineNumber));
    }

    public String getName() {
        return MessageFormat.format(RefactoringMessages.getString("JavaLineBreakpointTypeChange.1"), this.getDeclaringType().getElementName(), Integer.toString(this.fLineNumber));
    }

    public Change performChange(IType newType, Object undoChangedElement, Object undoArgument, int changeType) throws CoreException {
        Map attributes = this.getAttributes();
        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)newType);
        IJavaLineBreakpoint newLineBreakpoint = JDIDebugModel.createLineBreakpoint((IResource)newType.getResource(), (String)newType.getFullyQualifiedName(), (int)this.fLineNumber, (int)this.fCharStart, (int)this.fCharEnd, (int)this.getHitCount(), (boolean)true, (Map)attributes);
        this.getBreakpoint().delete();
        return new JavaLineBreakpointTypeChange(newLineBreakpoint, undoChangedElement, undoArgument, changeType);
    }

    public int getCharEnd() {
        return this.fCharEnd;
    }

    public int getCharStart() {
        return this.fCharStart;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }
}

