/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.synchronize;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoFilter;

public class FastSyncInfoFilter
extends SyncInfoFilter {
    public static FastSyncInfoFilter getDirectionAndChangeFilter(int direction, int change) {
        return new AndSyncInfoFilter(new FastSyncInfoFilter[]{new SyncInfoDirectionFilter(direction), new SyncInfoChangeTypeFilter(change)});
    }

    public boolean select(SyncInfo info) {
        return info.getKind() != 0;
    }

    public final boolean select(SyncInfo info, IProgressMonitor monitor) {
        return this.select(info);
    }

    public static class SyncInfoDirectionFilter
    extends FastSyncInfoFilter {
        int[] directionFilters = new int[]{4, 8, 12};

        public SyncInfoDirectionFilter(int[] directionFilters) {
            this.directionFilters = directionFilters;
        }

        public SyncInfoDirectionFilter(int direction) {
            this(new int[]{direction});
        }

        public boolean select(SyncInfo info) {
            int syncKind = info.getKind();
            for (int i = 0; i < this.directionFilters.length; ++i) {
                int filter = this.directionFilters[i];
                if ((syncKind & 0xC) != filter) continue;
                return true;
            }
            return false;
        }
    }

    public static class SyncInfoChangeTypeFilter
    extends FastSyncInfoFilter {
        private int[] changeFilters = new int[]{1, 2, 3};

        public SyncInfoChangeTypeFilter(int[] changeFilters) {
            this.changeFilters = changeFilters;
        }

        public SyncInfoChangeTypeFilter(int change) {
            this(new int[]{change});
        }

        public boolean select(SyncInfo info) {
            int syncKind = info.getKind();
            for (int i = 0; i < this.changeFilters.length; ++i) {
                int filter = this.changeFilters[i];
                if ((syncKind & 3) != filter) continue;
                return true;
            }
            return false;
        }
    }

    public static class OrSyncInfoFilter
    extends CompoundSyncInfoFilter {
        public OrSyncInfoFilter(FastSyncInfoFilter[] filters) {
            super(filters);
        }

        public boolean select(SyncInfo info) {
            for (int i = 0; i < this.filters.length; ++i) {
                FastSyncInfoFilter filter = this.filters[i];
                if (!filter.select(info)) continue;
                return true;
            }
            return false;
        }
    }

    public static class PseudoConflictFilter
    extends FastSyncInfoFilter {
        public boolean select(SyncInfo info) {
            return info.getKind() != 0 && (info.getKind() & 0x10) == 0;
        }
    }

    public static class AutomergableFilter
    extends FastSyncInfoFilter {
        public boolean select(SyncInfo info) {
            return (info.getKind() & 0x20) != 0;
        }
    }

    public static class AndSyncInfoFilter
    extends CompoundSyncInfoFilter {
        public AndSyncInfoFilter(FastSyncInfoFilter[] filters) {
            super(filters);
        }

        public boolean select(SyncInfo info) {
            for (int i = 0; i < this.filters.length; ++i) {
                FastSyncInfoFilter filter = this.filters[i];
                if (filter.select(info)) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class CompoundSyncInfoFilter
    extends FastSyncInfoFilter {
        protected FastSyncInfoFilter[] filters;

        protected CompoundSyncInfoFilter(FastSyncInfoFilter[] filters) {
            this.filters = filters;
        }
    }
}

