/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.File;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public class Path
implements IPath,
Cloneable {
    private String[] segments;
    private String device = null;
    private int separators;
    private static final int HAS_LEADING = 1;
    private static final int IS_UNC = 2;
    private static final int HAS_TRAILING = 4;
    private static final int ALL_SEPARATORS = 7;
    private static final int HASH_MASK = -5;
    private static final String[] NO_SEGMENTS = new String[0];
    private static final String ROOT_STRING = "/";
    public static final Path ROOT = new Path("/");
    private static final String EMPTY_STRING = "";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Path EMPTY = new Path("");

    private Path() {
    }

    private Path(String device, String[] segments, int _separators) {
        this.segments = segments;
        this.device = device;
        this.separators = this.computeHashCode() << 3 | _separators & 7;
    }

    public Path(String fullPath) {
        this.initialize(null, fullPath);
    }

    public Path(String device, String path) {
        this.initialize(device, path);
    }

    public IPath addFileExtension(String extension) {
        if (this.isRoot() || this.isEmpty() || this.hasTrailingSeparator()) {
            return this;
        }
        int len = this.segments.length;
        String[] newSegments = new String[len];
        System.arraycopy(this.segments, 0, newSegments, 0, len - 1);
        newSegments[len - 1] = this.segments[len - 1] + "." + extension;
        return new Path(this.device, newSegments, this.separators);
    }

    public IPath addTrailingSeparator() {
        if (this.hasTrailingSeparator() || this.isRoot()) {
            return this;
        }
        if (this.isEmpty()) {
            return new Path(this.device, this.segments, 1);
        }
        return new Path(this.device, this.segments, this.separators | 4);
    }

    public IPath append(String tail) {
        if (tail.indexOf(47) == -1 && tail.indexOf("\\") == -1 && tail.indexOf(58) == -1) {
            int tailLength = tail.length();
            if (tailLength < 3) {
                if (tailLength == 0 || ".".equals(tail)) {
                    return this;
                }
                if ("..".equals(tail)) {
                    return this.removeLastSegments(1);
                }
            }
            int myLen = this.segments.length;
            String[] newSegments = new String[myLen + 1];
            System.arraycopy(this.segments, 0, newSegments, 0, myLen);
            newSegments[myLen] = tail;
            return new Path(this.device, newSegments, this.separators & 0xFFFFFFFB);
        }
        if (this.isEmpty()) {
            return new Path(this.device, tail).makeRelative();
        }
        if (this.isRoot()) {
            return new Path(this.device, tail).makeAbsolute();
        }
        return this.append(new Path(tail));
    }

    public IPath append(IPath tail) {
        if (tail == null || tail.segmentCount() == 0) {
            return this;
        }
        if (this.isEmpty()) {
            return tail.setDevice(this.device).makeRelative();
        }
        if (this.isRoot()) {
            return tail.setDevice(this.device).makeAbsolute();
        }
        int myLen = this.segments.length;
        int tailLen = tail.segmentCount();
        String[] newSegments = new String[myLen + tailLen];
        System.arraycopy(this.segments, 0, newSegments, 0, myLen);
        for (int i = 0; i < tailLen; ++i) {
            newSegments[myLen + i] = tail.segment(i);
        }
        Path result = new Path(this.device, newSegments, this.separators & 3 | (tail.hasTrailingSeparator() ? 4 : 0));
        String tailFirstSegment = newSegments[myLen];
        if (tailFirstSegment.equals("..") || tailFirstSegment.equals(".")) {
            result.canonicalize();
        }
        return result;
    }

    private boolean canonicalize() {
        int max = this.segments.length;
        for (int i = 0; i < max; ++i) {
            String segment = this.segments[i];
            if (segment.charAt(0) != '.' || !segment.equals("..") && !segment.equals(".")) continue;
            this.collapseParentReferences();
            if (this.segments.length == 0) {
                this.separators &= 3;
            }
            this.separators = this.separators & 7 | this.computeHashCode() << 3;
            return true;
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void collapseParentReferences() {
        int segmentCount = this.segments.length;
        String[] stack = new String[segmentCount];
        int stackPointer = 0;
        for (int i = 0; i < segmentCount; ++i) {
            String segment = this.segments[i];
            if (segment.equals("..")) {
                if (stackPointer == 0) {
                    if (this.isAbsolute()) continue;
                    stack[stackPointer++] = segment;
                    continue;
                }
                if ("..".equals(stack[stackPointer - 1])) {
                    stack[stackPointer++] = "..";
                    continue;
                }
                --stackPointer;
                continue;
            }
            if (segment.equals(".") && (i != 0 || this.isAbsolute())) continue;
            stack[stackPointer++] = segment;
        }
        if (stackPointer == segmentCount) {
            return;
        }
        String[] newSegments = new String[stackPointer];
        System.arraycopy(stack, 0, newSegments, 0, stackPointer);
        this.segments = newSegments;
    }

    private String collapseSlashes(String path) {
        int length = path.length();
        if (length < 3) {
            return path;
        }
        if (path.indexOf("//", 1) == -1) {
            return path;
        }
        char[] result = new char[path.length()];
        int count = 0;
        boolean hasPrevious = false;
        char[] characters = path.toCharArray();
        for (int index = 0; index < characters.length; ++index) {
            char c = characters[index];
            if (c == '/') {
                if (hasPrevious) {
                    if (this.device != null || index != 1) continue;
                    result[count] = c;
                    ++count;
                    continue;
                }
                hasPrevious = true;
                result[count] = c;
                ++count;
                continue;
            }
            hasPrevious = false;
            result[count] = c;
            ++count;
        }
        return new String(result, 0, count);
    }

    private int computeHashCode() {
        int hash = this.device == null ? 17 : this.device.hashCode();
        int segmentCount = this.segments.length;
        for (int i = 0; i < segmentCount; ++i) {
            hash = hash * 37 + this.segments[i].hashCode();
        }
        return hash;
    }

    private int computeLength() {
        int max;
        int length = 0;
        if (this.device != null) {
            length += this.device.length();
        }
        if ((this.separators & 1) != 0) {
            ++length;
        }
        if ((this.separators & 2) != 0) {
            ++length;
        }
        if ((max = this.segments.length) > 0) {
            for (int i = 0; i < max; ++i) {
                length += this.segments[i].length();
            }
            length += max - 1;
        }
        if ((this.separators & 4) != 0) {
            ++length;
        }
        return length;
    }

    private int computeSegmentCount(String path) {
        int i;
        int len = path.length();
        if (len == 0 || len == 1 && path.charAt(0) == '/') {
            return 0;
        }
        int count = 1;
        int prev = -1;
        while ((i = path.indexOf(47, prev + 1)) != -1) {
            if (i != prev + 1 && i != len) {
                ++count;
            }
            prev = i;
        }
        if (path.charAt(len - 1) == '/') {
            --count;
        }
        return count;
    }

    private String[] computeSegments(String path) {
        int firstPosition;
        int segmentCount = this.computeSegmentCount(path);
        if (segmentCount == 0) {
            return NO_SEGMENTS;
        }
        String[] newSegments = new String[segmentCount];
        int len = path.length();
        int n = firstPosition = path.charAt(0) == '/' ? 1 : 0;
        if (firstPosition == 1 && len > 1 && path.charAt(1) == '/') {
            firstPosition = 2;
        }
        int lastPosition = path.charAt(len - 1) != '/' ? len - 1 : len - 2;
        int next = firstPosition;
        for (int i = 0; i < segmentCount; ++i) {
            int start = next;
            int end = path.indexOf(47, next);
            newSegments[i] = end == -1 ? path.substring(start, lastPosition + 1) : path.substring(start, end);
            next = end + 1;
        }
        return newSegments;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        Path target = (Path)obj;
        if ((this.separators & 0xFFFFFFFB) != (target.separators & 0xFFFFFFFB)) {
            return false;
        }
        int i = this.segments.length;
        String[] targetSegments = target.segments;
        if (i != targetSegments.length) {
            return false;
        }
        while (--i >= 0) {
            if (this.segments[i].equals(targetSegments[i])) continue;
            return false;
        }
        return this.device == target.device || this.device != null && this.device.equals(target.device);
    }

    public String getDevice() {
        return this.device;
    }

    public String getFileExtension() {
        if (this.hasTrailingSeparator()) {
            return null;
        }
        String lastSegment = this.lastSegment();
        if (lastSegment == null) {
            return null;
        }
        int index = lastSegment.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return lastSegment.substring(index + 1);
    }

    public int hashCode() {
        return this.separators & 0xFFFFFFFB;
    }

    public boolean hasTrailingSeparator() {
        return (this.separators & 4) != 0;
    }

    private void initialize(String device, String fullPath) {
        int len;
        Assert.isNotNull(fullPath);
        this.device = device;
        String path = fullPath.indexOf(92) == -1 ? fullPath : fullPath.replace('\\', '/');
        int i = path.indexOf(58);
        if (i != -1) {
            if (device == null) {
                this.device = path.substring(0, i + 1);
            }
            path = path.substring(i + 1, path.length());
        }
        if ((len = (path = this.collapseSlashes(path)).length()) < 2) {
            this.separators = len == 1 && path.charAt(0) == '/' ? 1 : 0;
        } else {
            boolean hasLeading = path.charAt(0) == '/';
            boolean isUNC = hasLeading && path.charAt(1) == '/';
            boolean hasTrailing = (!isUNC || len != 2) && path.charAt(len - 1) == '/';
            int n = this.separators = hasLeading ? 1 : 0;
            if (isUNC) {
                this.separators |= 2;
            }
            if (hasTrailing) {
                this.separators |= 4;
            }
        }
        this.segments = this.computeSegments(path);
        if (!this.canonicalize()) {
            this.separators = this.separators & 7 | this.computeHashCode() << 3;
        }
    }

    public boolean isAbsolute() {
        return (this.separators & 1) != 0;
    }

    public boolean isEmpty() {
        return this.segments.length == 0 && (this.separators & 7) != 1;
    }

    public boolean isPrefixOf(IPath anotherPath) {
        if (this.device == null ? anotherPath.getDevice() != null : !this.device.equalsIgnoreCase(anotherPath.getDevice())) {
            return false;
        }
        if (this.isEmpty() || this.isRoot() && anotherPath.isAbsolute()) {
            return true;
        }
        int len = this.segments.length;
        if (len > anotherPath.segmentCount()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.segments[i].equals(anotherPath.segment(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isRoot() {
        return this == ROOT || this.segments.length == 0 && (this.separators & 7) == 1;
    }

    public boolean isUNC() {
        if (this.device != null) {
            return false;
        }
        return (this.separators & 2) != 0;
    }

    public boolean isValidPath(String path) {
        if (path.indexOf("//", 1) > 0) {
            return false;
        }
        Path test = new Path(path);
        int segmentCount = test.segmentCount();
        for (int i = 0; i < segmentCount; ++i) {
            if (test.isValidSegment(test.segment(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isValidSegment(String segment) {
        int size = segment.length();
        if (size == 0) {
            return false;
        }
        if (Character.isWhitespace(segment.charAt(0)) || Character.isWhitespace(segment.charAt(size - 1))) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            char c = segment.charAt(i);
            if (c != '/' && c != '\\' && c != ':') continue;
            return false;
        }
        return true;
    }

    public String lastSegment() {
        int len = this.segments.length;
        return len == 0 ? null : this.segments[len - 1];
    }

    public IPath makeAbsolute() {
        String first;
        if (this.isAbsolute()) {
            return this;
        }
        Path result = new Path(this.device, this.segments, this.separators | 1);
        if (result.segmentCount() > 0 && ((first = result.segment(0)).equals("..") || first.equals("."))) {
            result.canonicalize();
        }
        return result;
    }

    public IPath makeRelative() {
        if (!this.isAbsolute()) {
            return this;
        }
        return new Path(this.device, this.segments, this.separators & 4);
    }

    public IPath makeUNC(boolean toUNC) {
        if (!(toUNC ^ this.isUNC())) {
            return this;
        }
        int newSeparators = this.separators;
        newSeparators = toUNC ? (newSeparators |= 3) : (newSeparators &= 5);
        return new Path(toUNC ? null : this.device, this.segments, newSeparators);
    }

    public int matchingFirstSegments(IPath anotherPath) {
        Assert.isNotNull(anotherPath);
        int anotherPathLen = anotherPath.segmentCount();
        int max = Math.min(this.segments.length, anotherPathLen);
        int count = 0;
        for (int i = 0; i < max; ++i) {
            if (!this.segments[i].equals(anotherPath.segment(i))) {
                return count;
            }
            ++count;
        }
        return count;
    }

    public IPath removeFileExtension() {
        String extension = this.getFileExtension();
        if (extension == null || extension.equals(EMPTY_STRING)) {
            return this;
        }
        String lastSegment = this.lastSegment();
        int index = lastSegment.lastIndexOf(extension) - 1;
        return this.removeLastSegments(1).append(lastSegment.substring(0, index));
    }

    public IPath removeFirstSegments(int count) {
        if (count == 0) {
            return this;
        }
        if (count >= this.segments.length) {
            return new Path(this.device, NO_SEGMENTS, 0);
        }
        Assert.isLegal(count > 0);
        int newSize = this.segments.length - count;
        String[] newSegments = new String[newSize];
        System.arraycopy(this.segments, count, newSegments, 0, newSize);
        return new Path(this.device, newSegments, this.separators & 4);
    }

    public IPath removeLastSegments(int count) {
        if (count == 0) {
            return this;
        }
        if (count >= this.segments.length) {
            return new Path(this.device, NO_SEGMENTS, this.separators & 3);
        }
        Assert.isLegal(count > 0);
        int newSize = this.segments.length - count;
        String[] newSegments = new String[newSize];
        System.arraycopy(this.segments, 0, newSegments, 0, newSize);
        return new Path(this.device, newSegments, this.separators);
    }

    public IPath removeTrailingSeparator() {
        if (!this.hasTrailingSeparator()) {
            return this;
        }
        return new Path(this.device, this.segments, this.separators & 3);
    }

    public String segment(int index) {
        if (index >= this.segments.length) {
            return null;
        }
        return this.segments[index];
    }

    public int segmentCount() {
        return this.segments.length;
    }

    public String[] segments() {
        String[] segmentCopy = new String[this.segments.length];
        System.arraycopy(this.segments, 0, segmentCopy, 0, this.segments.length);
        return segmentCopy;
    }

    public IPath setDevice(String value) {
        if (value != null) {
            Assert.isTrue(value.indexOf(58) == value.length() - 1, "Last character should be the device separator");
        }
        if (value == this.device || value != null && value.equals(this.device)) {
            return this;
        }
        return new Path(value, this.segments, this.separators);
    }

    public File toFile() {
        return new File(this.toOSString());
    }

    public String toOSString() {
        int len;
        int resultSize = this.computeLength();
        if (resultSize <= 0) {
            return EMPTY_STRING;
        }
        char FILE_SEPARATOR = File.separatorChar;
        char[] result = new char[resultSize];
        int offset = 0;
        if (this.device != null) {
            int size = this.device.length();
            this.device.getChars(0, size, result, offset);
            offset += size;
        }
        if ((this.separators & 1) != 0) {
            result[offset++] = FILE_SEPARATOR;
        }
        if ((this.separators & 2) != 0) {
            result[offset++] = FILE_SEPARATOR;
        }
        if ((len = this.segments.length - 1) >= 0) {
            for (int i = 0; i < len; ++i) {
                int size = this.segments[i].length();
                this.segments[i].getChars(0, size, result, offset);
                offset += size;
                result[offset++] = FILE_SEPARATOR;
            }
            int size = this.segments[len].length();
            this.segments[len].getChars(0, size, result, offset);
            offset += size;
        }
        if ((this.separators & 4) != 0) {
            result[offset++] = FILE_SEPARATOR;
        }
        return new String(result);
    }

    public String toString() {
        int len;
        int resultSize = this.computeLength();
        if (resultSize <= 0) {
            return EMPTY_STRING;
        }
        char[] result = new char[resultSize];
        int offset = 0;
        if (this.device != null) {
            int size = this.device.length();
            this.device.getChars(0, size, result, offset);
            offset += size;
        }
        if ((this.separators & 1) != 0) {
            result[offset++] = 47;
        }
        if ((this.separators & 2) != 0) {
            result[offset++] = 47;
        }
        if ((len = this.segments.length - 1) >= 0) {
            for (int i = 0; i < len; ++i) {
                int size = this.segments[i].length();
                this.segments[i].getChars(0, size, result, offset);
                offset += size;
                result[offset++] = 47;
            }
            int size = this.segments[len].length();
            this.segments[len].getChars(0, size, result, offset);
            offset += size;
        }
        if ((this.separators & 4) != 0) {
            result[offset++] = 47;
        }
        return new String(result);
    }

    public IPath uptoSegment(int count) {
        if (count == 0) {
            return new Path(this.device, EMPTY_STRING_ARRAY, this.separators & 3);
        }
        if (count >= this.segments.length) {
            return this;
        }
        Assert.isTrue(count > 0, "Invalid parameter to Path.uptoSegment");
        String[] newSegments = new String[count];
        System.arraycopy(this.segments, 0, newSegments, 0, count);
        return new Path(this.device, newSegments, this.separators);
    }
}

