/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.PluginErrorReporter;
import org.eclipse.pde.internal.builders.ValidatingSAXParser;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;

public class UpdateSiteBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDERS_VERIFYING = "Builders.verifying";
    public static final String BUILDERS_UPDATING = "Builders.updating";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = null;
        if (kind != 6) {
            delta = this.getDelta(this.getProject());
        }
        if (delta == null || kind == 6) {
            IProject project = this.getProject();
            IFile file = project.getFile("site.xml");
            if (file.exists()) {
                this.checkFile(file, monitor);
            }
        } else {
            delta.accept((IResourceDeltaVisitor)new DeltaVisitor(monitor));
        }
        return null;
    }

    private void checkFile(IFile file, IProgressMonitor monitor) {
        String message = PDE.getFormattedMessage(BUILDERS_VERIFYING, file.getFullPath().toString());
        monitor.subTask(message);
        PluginErrorReporter reporter = new PluginErrorReporter(file);
        ValidatingSAXParser.parse(file, reporter, true);
        if (reporter.getErrorCount() == 0) {
            this.validateFile(file, reporter);
        }
        monitor.subTask(PDE.getResourceString(BUILDERS_UPDATING));
        monitor.done();
    }

    private boolean isSiteFile(IFile file) {
        return file.getParent().equals(file.getProject()) && file.getName().toLowerCase().equals("site.xml");
    }

    private void validateFile(IFile file, PluginErrorReporter reporter) {
        ISite site;
        WorkspaceSiteModel model = new WorkspaceSiteModel(file);
        model.load();
        if (model.isLoaded() && (site = model.getSite()) != null) {
            this.validateRequiredAttributes(site, reporter);
        }
    }

    private void validateRequiredAttributes(ISite site, PluginErrorReporter reporter) {
        ISiteFeature[] features = site.getFeatures();
        for (int i = 0; i < features.length; ++i) {
            ISiteFeature feature = features[i];
            UpdateSiteBuilder.assertNotNull("url", "feature", UpdateSiteBuilder.getLine((ISiteObject)feature), feature.getURL(), reporter);
            ISiteCategory[] categories = feature.getCategories();
            for (int j = 0; j < categories.length; ++j) {
                ISiteCategory category = categories[j];
                UpdateSiteBuilder.assertNotNull("name", "category", UpdateSiteBuilder.getLine((ISiteObject)category), category.getName(), reporter);
            }
        }
        ISiteArchive[] archives = site.getArchives();
        for (int i = 0; i < archives.length; ++i) {
            ISiteArchive archive = archives[i];
            UpdateSiteBuilder.assertNotNull("path", "archive", UpdateSiteBuilder.getLine((ISiteObject)archive), archive.getPath(), reporter);
            UpdateSiteBuilder.assertNotNull("url", "archive", UpdateSiteBuilder.getLine((ISiteObject)archive), archive.getURL(), reporter);
        }
        ISiteCategoryDefinition[] defs = site.getCategoryDefinitions();
        for (int i = 0; i < defs.length; ++i) {
            ISiteCategoryDefinition def = defs[i];
            UpdateSiteBuilder.assertNotNull("name", "category-def", UpdateSiteBuilder.getLine((ISiteObject)def), def.getName(), reporter);
            UpdateSiteBuilder.assertNotNull("label", "category-def", UpdateSiteBuilder.getLine((ISiteObject)def), def.getLabel(), reporter);
        }
    }

    private static int getLine(ISiteObject object) {
        int line = -1;
        if (object instanceof ISourceObject) {
            line = ((ISourceObject)object).getStartLine();
        }
        return line;
    }

    private static void assertNotNull(String att, String el, int line, String value, PluginErrorReporter reporter) {
        if (value == null) {
            String message = PDE.getFormattedMessage("Builders.manifest.missingRequired", new String[]{att, el});
            reporter.reportError(message, line);
        }
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        public DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) {
            IFile candidate;
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                try {
                    return project.hasNature("org.eclipse.pde.UpdateSiteNature");
                }
                catch (CoreException e) {
                    PDE.logException(e);
                    return false;
                }
            }
            if (resource instanceof IFile && UpdateSiteBuilder.this.isSiteFile(candidate = (IFile)resource) && delta.getKind() != 2) {
                UpdateSiteBuilder.this.checkFile(candidate, this.monitor);
                return true;
            }
            return true;
        }
    }
}

