/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.SubActionBars2;
import org.eclipse.ui.internal.ActionSetMenuManager;
import org.eclipse.ui.internal.PluginActionCoolBarContributionItem;

public class ActionSetActionBars
extends SubActionBars2 {
    private String actionSetId;
    private ArrayList adjunctContributions = new ArrayList();
    private IToolBarManager coolItemToolBarMgr = null;
    private ToolBarContributionItem toolBarContributionItem = null;

    public ActionSetActionBars(IActionBars2 parent, String actionSetId) {
        super(parent);
        this.actionSetId = actionSetId;
    }

    void addAdjunctContribution(IContributionItem item) {
        this.adjunctContributions.add(item);
    }

    protected SubMenuManager createSubMenuManager(IMenuManager parent) {
        return new ActionSetMenuManager(parent, this.actionSetId);
    }

    protected SubToolBarManager createSubToolBarManager(IToolBarManager parent) {
        return null;
    }

    public void dispose() {
        IContributionItem item;
        int i;
        super.dispose();
        if (this.coolItemToolBarMgr == null) {
            return;
        }
        IContributionItem[] items = this.coolItemToolBarMgr.getItems();
        for (i = 0; i < items.length; ++i) {
            PluginActionCoolBarContributionItem actionSetItem;
            item = items[i];
            if (!(item instanceof PluginActionCoolBarContributionItem) || !(actionSetItem = (PluginActionCoolBarContributionItem)item).getActionSetId().equals(this.actionSetId)) continue;
            this.coolItemToolBarMgr.remove(item);
            item.dispose();
        }
        for (i = 0; i < this.adjunctContributions.size(); ++i) {
            item = (ContributionItem)this.adjunctContributions.get(i);
            ToolBarManager parent = (ToolBarManager)item.getParent();
            if (parent == null) continue;
            parent.remove(item);
            item.dispose();
        }
        this.toolBarContributionItem = null;
        this.coolItemToolBarMgr = null;
        this.adjunctContributions = new ArrayList();
    }

    private IContributionItem findAlphabeticalOrder(String startId, String itemId, IContributionManager mgr) {
        IContributionItem item;
        int insertIndex;
        IContributionItem[] items = mgr.getItems();
        for (insertIndex = 0; !(insertIndex >= items.length || (item = items[insertIndex]).getId() != null && item.getId().equals(startId)); ++insertIndex) {
        }
        int i = insertIndex + 1;
        while (i < items.length) {
            IContributionItem item2 = items[i];
            String testId = item2.getId();
            if (item2.isGroupMarker() || itemId != null && testId != null && itemId.compareTo(testId) < 1) break;
            insertIndex = i++;
        }
        if (insertIndex >= items.length) {
            return null;
        }
        return items[insertIndex];
    }

    String getActionSetId() {
        return this.actionSetId;
    }

    public IToolBarManager getToolBarManager() {
        ICoolBarManager coolBarManager = this.getCastedParent().getCoolBarManager();
        if (coolBarManager == null) {
            return null;
        }
        return new ToolBarManager(coolBarManager.getStyle());
    }

    public IToolBarManager getToolBarManager(String actionId) {
        ICoolBarManager coolBarManager;
        String toolBarId = this.actionSetId;
        boolean isAdjunctType = false;
        if (!actionId.equals(this.actionSetId)) {
            toolBarId = actionId;
            isAdjunctType = true;
        }
        if ((coolBarManager = this.getCastedParent().getCoolBarManager()) == null) {
            return null;
        }
        if (this.coolItemToolBarMgr != null && !isAdjunctType) {
            return this.coolItemToolBarMgr;
        }
        IContributionItem cbItem = coolBarManager.find(toolBarId);
        if (cbItem instanceof ToolBarContributionItem) {
            ToolBarContributionItem tbcbItem = (ToolBarContributionItem)cbItem;
            this.coolItemToolBarMgr = tbcbItem.getToolBarManager();
            if (!isAdjunctType) {
                this.toolBarContributionItem = tbcbItem;
            }
        } else {
            this.coolItemToolBarMgr = new ToolBarManager(coolBarManager.getStyle());
            this.toolBarContributionItem = new ToolBarContributionItem(this.coolItemToolBarMgr, toolBarId);
            this.toolBarContributionItem.setParent((IContributionManager)this.coolItemToolBarMgr);
            this.toolBarContributionItem.setVisible(this.getActive());
            this.coolItemToolBarMgr.markDirty();
            IContributionItem refItem = this.findAlphabeticalOrder("additions", toolBarId, (IContributionManager)coolBarManager);
            if (refItem != null) {
                coolBarManager.insertAfter(refItem.getId(), (IContributionItem)this.toolBarContributionItem);
            } else {
                coolBarManager.add((IContributionItem)this.toolBarContributionItem);
            }
        }
        return this.coolItemToolBarMgr;
    }

    void removeAdjunctContribution(ContributionItem item) {
        this.adjunctContributions.remove(item);
    }

    protected void setActive(boolean set) {
        super.setActive(set);
        ICoolBarManager coolBarManager = this.getCastedParent().getCoolBarManager();
        if (coolBarManager == null) {
            return;
        }
        if (this.coolItemToolBarMgr != null) {
            IContributionItem[] items = this.coolItemToolBarMgr.getItems();
            for (int i = 0; i < items.length; ++i) {
                PluginActionCoolBarContributionItem actionSetItem;
                IContributionItem item = items[i];
                if (!(item instanceof PluginActionCoolBarContributionItem) || !(actionSetItem = (PluginActionCoolBarContributionItem)item).getActionSetId().equals(this.actionSetId)) continue;
                item.setVisible(set);
                this.coolItemToolBarMgr.markDirty();
                if (coolBarManager.isDirty()) continue;
                coolBarManager.markDirty();
            }
            this.coolItemToolBarMgr.update(false);
            if (this.toolBarContributionItem != null) {
                this.toolBarContributionItem.update("size");
            }
        }
        if (this.adjunctContributions.size() > 0) {
            Iterator i = this.adjunctContributions.iterator();
            while (i.hasNext()) {
                IContributionItem item = (IContributionItem)i.next();
                if (!(item instanceof ContributionItem)) continue;
                item.setVisible(set);
                IContributionManager manager = ((ContributionItem)item).getParent();
                manager.markDirty();
                manager.update(false);
                if (!coolBarManager.isDirty()) {
                    coolBarManager.markDirty();
                }
                item.update("size");
            }
        }
        coolBarManager.update(false);
    }
}

