/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands.ws;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class HandlerProxy
extends AbstractHandler {
    private static final String HANDLER_ATTRIBUTE_NAME = "handler";
    private final String commandId;
    private IConfigurationElement configurationElement;
    private IHandler handler;

    public HandlerProxy(String newCommandId, IConfigurationElement newConfigurationElement) {
        this.commandId = newCommandId;
        this.configurationElement = newConfigurationElement;
        this.handler = null;
    }

    public void dispose() {
        if (this.handler != null) {
            this.handler.dispose();
        }
    }

    public Object execute(Map parameterValuesByName) throws ExecutionException {
        if (this.loadHandler()) {
            return this.handler.execute(parameterValuesByName);
        }
        return null;
    }

    final String getCommandId() {
        return this.commandId;
    }

    public Map getAttributeValuesByName() {
        if (this.loadHandler()) {
            return this.handler.getAttributeValuesByName();
        }
        return Collections.EMPTY_MAP;
    }

    private final boolean loadHandler() {
        if (this.handler == null) {
            try {
                this.handler = (IHandler)this.configurationElement.createExecutableExtension(HANDLER_ATTRIBUTE_NAME);
                this.configurationElement = null;
                return true;
            }
            catch (CoreException e) {
                String message = "The proxied handler for '" + this.commandId + "' could not be loaded";
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e);
                WorkbenchPlugin.log(message, (IStatus)status);
                return false;
            }
        }
        return true;
    }
}

